<?php

namespace CodeConfig\EAW\Ajax;

defined('ABSPATH') || exit('No direct script access allowed');

class Post
{
    public static function getAttachment()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $attachment_id = intval(wp_unslash($_POST['id'] ?? 0));

        if (!$attachment_id) {
            wp_send_json_error(['message' => 'Invalid attachment ID']);
        }

        $attachment_url = wp_get_attachment_url($attachment_id);

        if (!$attachment_url) {
            wp_send_json_error(['message' => 'Invalid attachment URL']);
        }

        $attachment_data = [
            'id'    => $attachment_id,
            'url'   => $attachment_url,
            'title' => get_the_title($attachment_id),
        ];

        wp_send_json_success($attachment_data);
    }
}
