<?php

namespace CodeConfig\EAW\Ajax;

use CodeConfig\EAW\Utils\Helpers;

defined('ABSPATH') || exit('No direct script access allowed');

class Menus
{
    public static function getMenus()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $menus = Helpers::getMenus();

        if (empty($menus)) {
            wp_send_json_error(
                [
                    'success' => false,
                    'message' => 'No menus found',
                ]
            );
        }

        $menus = array_map(function ($menu) {
            return [
                'value' => $menu['value'],
                'label' => $menu['label'],
            ];
        }, $menus);

        wp_send_json_success(
            [
                'success' => true,
                'menus'   => $menus,
            ]
        );
    }
}
