<?php

namespace CodeConfig\EAW\Ajax;

use CodeConfig\EAW\App\CartManager\SidebarCartContent;

defined('ABSPATH') || exit('No direct script access allowed');

class Checkout
{
    public static function getCheckoutFormPreview()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $result = [
            'status' => 'error',
            'html'   => '',
        ];

        $eaw_get_checkout = sanitize_text_field(wp_unslash($_POST['eaw_get_checkout'] ?? ''));

        if ($eaw_get_checkout) {
            //phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
            $param             = wc_clean(wp_unslash($_POST['eaw_checkout_form'] ?? []));
            $param['language'] = sanitize_text_field(wp_unslash($_POST['eaw_language'] ?? ''));
            if (isset($_POST['is_paysoncheckout'])) {
                $param['is_paysoncheckout'] = sanitize_text_field(wp_unslash($_POST['is_paysoncheckout'] ?? ''));
            }

            $result['status'] = 'success';
            ob_start();

            wc_get_template(
                'sc-form-checkout.php',
                [
                    'checkout'     => WC()->checkout(),
                    'param'        => $param,
                    'settings'     => !empty($param['is_customize']) ? SidebarCartContent::getInstance() : null,
                ],
                'essential-addons-for-woocommerce' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR . 'sidebar-cart' . DIRECTORY_SEPARATOR,
                CCPEAW_TEMPLATES . 'atc/' . 'sidebar-cart' . DIRECTORY_SEPARATOR
            );

            $html                                = ob_get_clean();
            $result['html']                      = $html;
            $result['update_order_review_nonce'] = wp_create_nonce('ccpeaw');
        }

        wp_send_json($result);
    }
}
