<?php

namespace CodeConfig\EAW\Ajax;

use CodeConfig\EAW\Utils\Helpers;

defined('ABSPATH') || exit('No direct script access allowed');

class CategoryList
{
    public static function get()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $categories = Helpers::getAllCategories();

        if (!$categories) {
            return wp_send_json_error([
                'success' => false,
                'message' => __('No categories found.', 'essential-addons-for-woocommerce')
            ]);
        }

        return wp_send_json_success([
            'success' => true,
            'data'    => $categories
        ]);
    }
}
