<?php

namespace CodeConfig\EAW;

use CodeConfig\EAW\Ajax\Cart;
use CodeConfig\EAW\Ajax\CategoryList;
use CodeConfig\EAW\Ajax\Checkout;
use CodeConfig\EAW\Ajax\Frontend;
use CodeConfig\EAW\Ajax\Menus;
use CodeConfig\EAW\Ajax\Post;
use CodeConfig\EAW\Ajax\Product;
use CodeConfig\EAW\Ajax\ProductVariation;
use CodeConfig\EAW\Ajax\SaveCart;
use CodeConfig\EAW\Ajax\Settings;
use CodeConfig\EAW\Ajax\Sidebar;
use CodeConfig\EAW\Ajax\Users;
use CodeConfig\EAW\Ajax\Utilities;
use CodeConfig\EAW\Ajax\Wishlist;
use CodeConfig\EAW\App\QuickView;
use CodeConfig\EAW\Utils\Singleton;
defined( 'ABSPATH' ) || exit( 'No direct script access allowed' );
class Ajax {
    use Singleton;
    private function doHooks() {
        // Settings
        $this->addAction( 'GetSettings', [Settings::class, 'get'] );
        $this->addAction( 'UpdateSettings', [Settings::class, 'update'] );
        // Menus
        $this->addAction( 'GetWPMenus', [Menus::class, 'getMenus'] );
        // Category
        $this->addAction( 'GetCategories', [CategoryList::class, 'get'] );
        // Product
        $this->addAction( 'GetProduct', [Product::class, 'get'] );
        $this->addAction( 'AddToCartById', [Product::class, 'set'] );
        $this->addAction( 'GetProducts', [Product::class, 'getProducts'] );
        $this->addAction( 'SearchCats', [Product::class, 'getSearchCats'] );
        $this->addAction( 'GetCategories', [Product::class, 'getCategories'] );
        $this->addAction( 'GetProductUrl', [Product::class, 'getProductUrl'] );
        $this->addAction( 'GetProductSKUs', [Product::class, 'getProductSkus'] );
        $this->addAction( 'SearchProduct', [Product::class, 'getSearchProduct'] );
        $this->addAction( 'GetCategoryById', [Product::class, 'getCategoryById'] );
        $this->addAction( 'GetProductsById', [Product::class, 'getProductsById'] );
        $this->addAction( 'GetProductsByTitle', [Product::class, 'getProductsByTitle'] );
        $this->addAction( 'GetCategoryByTitle', [Product::class, 'getCategoryByTitle'] );
        $this->addAction( 'GetProductVariations', [Product::class, 'getProductVariations'] );
        $this->addAction( 'GetVariationByProductId', [Product::class, 'getProductVariationById'] );
        // Product Video
        $this->addAction( 'GetProductVideo', [Product::class, 'getProductVideo'] );
        // Recently Viewed Products
        $this->addAction( 'GetViewedProducts', [Product::class, 'getViewedProducts'] );
        $this->addAction( 'DeleteViewedProducts', [Product::class, 'deleteViewedProducts'] );
        // Product Variation
        $this->addAction( 'AddProductAttribute', [ProductVariation::class, 'addProductAttribute'] );
        $this->addAction( 'GetProductAttributes', [ProductVariation::class, 'getProductAttributes'] );
        $this->addAction( 'DeleteProductAttribute', [ProductVariation::class, 'deleteProductAttribute'] );
        $this->addAction( 'GetProductAttributeTerms', [ProductVariation::class, 'getProductAttributeTerms'] );
        // SaveCart
        $this->addAction( 'CopyCart', [SaveCart::class, 'copy'] );
        $this->addAction( 'SaveCart', [SaveCart::class, 'update'] );
        $this->addAction( 'DeleteSavedCart', [SaveCart::class, 'delete'] );
        $this->addAction( 'RestoreSavedCart', [SaveCart::class, 'restore'] );
        $this->addAction( 'ShareCartOnSocial', [SaveCart::class, 'shareCartOnSocial'] );
        // Sidebar
        $this->addAction( 'GetScFootMsgHtml', [Sidebar::class, 'getSidebarFootMessageHtml'] );
        $this->addAction( 'GetScFootPdPlusHtml', [Sidebar::class, 'getSidebarFootPdPlusHtml'] );
        $this->addAction( 'ChangeScPdPriceStyle', [Sidebar::class, 'getSidebarProductPriceStyle'] );
        // Checkout
        $this->addAction( 'GetCheckoutFormPreview', [Checkout::class, 'getCheckoutFormPreview'] );
        // Wishlist
        $this->addAction(
            'HandleWishlist',
            [Wishlist::class, 'handleWishlist'],
            true,
            [
                'noPrevCallback' => [Wishlist::class, 'noPrevSetWishlist'],
            ]
        );
        $this->addAction( 'GetWishlist', [Wishlist::class, 'getWishlist'] );
        $this->addAction(
            'DeleteFromWishList',
            [Wishlist::class, 'deleteFromWishList'],
            true,
            [
                'noPrevCallback' => [Wishlist::class, 'noPrevSetWishlist'],
            ]
        );
        // Users
        $this->addAction( 'GetUserRoles', [Users::class, 'getUserRoles'] );
        // Post
        $this->addAction( 'GetAttachment', [Post::class, 'getAttachment'] );
        // Get Currency
        $this->addAction( 'FetchCurrency', [Utilities::class, 'getCurrency'] );
        // Frontend
        $this->addAction( 'GetClassIcon', [Frontend::class, 'getClassIcon'] );
        // QuickView
        $this->addAction( 'GetProductQuickData', [QuickView::class, 'getPopUpContent'], true );
    }

    /**
     * Add an AJAX action.
     *
     * @param string $hook The action hook name.
     * @param callable $callback The callback function.
     * @param bool $isNopriv Whether the callback should be accessible via the {@link wp_ajax_nopriv_{$hook}} action hook.
     */
    private function addAction(
        $hook,
        $callback,
        $isNopriv = false,
        $args = []
    ) {
        $defaultArgs = [
            'prefix'         => 'ccpeaw',
            'handle'         => 'wp_ajax',
            'noPrevCallback' => null,
        ];
        $args = array_merge( $defaultArgs, $args );
        $handle = $args['handle'];
        $prefix = $args['prefix'];
        $noPrevCallback = $args['noPrevCallback'] ?? $callback;
        $hookName = "{$handle}_{$prefix}{$hook}";
        add_action( $hookName, $callback );
        if ( $isNopriv ) {
            $noprivHookName = "{$handle}_nopriv_{$prefix}{$hook}";
            add_action( $noprivHookName, $noPrevCallback );
        }
    }

}
