<?php

namespace CodeConfig\EAW;

use CodeConfig\EAW\Utils\Helpers;

defined('ABSPATH') || exit('No direct script access allowed');

class Activation
{
    public static function init()
    {
        Helpers::checkPluginRequirements();
        $update = Update::getInstance();

        if ($update->isUpdateAvailable()) {
            $update->performUpdates();
        } else {
            self::setDefaultSettings();
        }
    }

    private static function setDefaultSettings()
    {
        $ccpeaw_settings = get_option(CCPEAW_OPTIONS_NAME, false);

        if (! $ccpeaw_settings) {

            $default_settings = ccpeaw_default_settings();

            update_option(CCPEAW_OPTIONS_NAME, $default_settings);
        }
    }
}
