<?php

namespace CodeConfig;

use CodeConfig\EAW\Autoload;
use CodeConfig\EAW\CodeConfig;
/**
 * Plugin Name:       Essential Addons for WooCommerce
 * Plugin URI:        https://codeconfig.dev/essential-addons-for-woocommerce/
 * Description:       Boost your WooCommerce store with dynamic features like customizable cart incentives, free shipping banners, discount triggers, cart reminders, and advanced mini-cart designs. Enhance user engagement, reduce cart abandonment, and increase sales effortlessly.
 * Requires Plugins: woocommerce
 * Version:           1.0.9
 * Requires at least: 6.2
 * Requires PHP:      7.4
 * Author:            CodeConfig
 * Author URI:        https://codeconfig.dev
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       essential-addons-for-woocommerce
 * Domain Path:       /languages/
 */
if ( !defined( 'ABSPATH' ) ) {
    exit( 'Direct access to this file is not allowed.' );
}
if ( function_exists( 'CodeConfig\\eaw_fs' ) ) {
    eaw_fs()->set_basename( false, __FILE__ );
} else {
    if ( !function_exists( 'CodeConfig\\eaw_fs' ) ) {
        function eaw_fs() {
            global $eaw_fs;
            if ( !isset( $eaw_fs ) ) {
                if ( !function_exists( 'Freemius' ) ) {
                    require_once dirname( __FILE__ ) . '/freemius/start.php';
                }
                $eaw_fs = fs_dynamic_init( [
                    'id'               => '17786',
                    'slug'             => 'essential-addons-for-woocommerce',
                    'type'             => 'plugin',
                    'public_key'       => 'pk_179760a4a450dc42afd06e0662e1b',
                    'premium_suffix'   => 'PRO',
                    'is_premium'       => false,
                    'has_addons'       => false,
                    'has_paid_plans'   => false,
                    "is_org_compliant" => true,
                    'trial'            => [
                        'days'               => 7,
                        'is_require_payment' => true,
                    ],
                    'menu'             => [
                        'slug' => 'essential-addons-for-woocommerce',
                    ],
                    'is_live'          => true,
                ] );
            }
            return $eaw_fs;
        }

        eaw_fs();
        do_action( 'CCPEAW_loaded' );
    }
    define( 'CCPEAW_FILE', __FILE__ );
    require_once plugin_dir_path( CCPEAW_FILE ) . 'core/config.php';
    require_once plugin_dir_path( CCPEAW_FILE ) . 'core/functions.php';
    $ccpeaw_include_files = ['Autoload'];
    foreach ( $ccpeaw_include_files as $include_file ) {
        $include_file = CCPEAW_INCLUDES . '/' . $include_file . '.php';
        if ( file_exists( $include_file ) ) {
            require_once $include_file;
        }
    }
    Autoload::register();
    CodeConfig::getInstance();
}