<?php

defined("ABSPATH") or exit("No direct script access allowed");

/**
 * Retrieves and includes a template file based on the provided slug and optional name.
 *
 * This function attempts to locate a template file using the given slug and name.
 * If a template is found, it will be included, and any provided arguments will
 * be extracted and available within the template scope.
 *
 * @param string $slug The slug name for the template.
 * @param array $args (Optional) An associative array of variables to be extracted into the template.
 * @param string $name (Optional) The name of the specialized template.
 */

function ccpeaw_get_template($slug, $args = [], $name = null)
{
    $template = locate_template("{$slug}-{$name}.php");

    if (!$template) {
        $template = CCPEAW_PATH . "templates/{$slug}.php";
        if ($name) {
            $template = CCPEAW_PATH . "templates/{$slug}-{$name}.php";
        }
    }

    if (file_exists($template)) {
        if (!empty($args) && is_array($args)) {
            extract($args);
        }
        include $template;
    }
}


/**
 * Add custom query vars for our purposes.
 *
 * @param array $query_vars the existing query vars.
 *
 * @return array the updated query vars.
 */
add_filter('query_vars', 'ccpeaw_add_query_var');
function ccpeaw_add_query_var($query_vars)
{
    $query_vars[] = 'shared_cart';
    $query_vars[] = 'wishlist';
    $query_vars[] = 'saved-cart';
    $query_vars[] = 'ccpeaw_live_editor';

    return $query_vars;
}

function ccpeaw_fs()
{
    return CodeConfig\eaw_fs();
}

/**
 * Returns the default settings for the plugin.
 *
 * @return array
 */
function ccpeaw_default_settings()
{
    $ajaxATC = [
        'atcBtnHoverEffect'                => 0,
        'redirectCartPageForSimpleProduct' => 0,
        'enableAjaxATC'                    => 0,
        'enableVariationPopUp'             => 0,
        'atcBtnTextEnable'                 => 1,
        'simpleProductBtnTxt'              => 'Add To Cart',
        'variationButtonText'              => 'Select Variation',
        'groupedButtonText'                => 'View Products',
        'externalButtonText'               => 'Buy Now',
    ];

    $stickyATC = [
        'sbEnable'                => 1,
        'sbMobileEnable'          => 0,
        'sbProductExclude'        => [],
        'sbExcludeCategories'     => [],
        'sbShowSwatches'          => 1,
        'sbAlwaysShow'            => '',
        'sbSelectProduct'         => '',
        'sbTemplate'              => 2,
        'sbPosition'              => 0,
        'sbMobilePosition'        => 0,
        'sbBgColor'               => '#fff',
        'sbBoxShadowColor'        => '#bababa',
        'sbPadding'               => '5px',
        'sbBorderRadius'          => 0,
        'sbShowRating'            => 0,
        'sbRatingColor'           => '',
        'sbShowQuantity'          => 1,
        'sbProductImgWidth'       => 60,
        'sbProductImgHeight'      => 60,
        'sbProductNameColor'      => '',
        'sbProductPriceColor'     => '',
        'sbPriceColor2'           => '',
        'sbAtcTitle'              => '{cart_icon}',
        'sbAtcIcon'               => 5,
        'sbAtcBgColor'            => '#1a7efb',
        'sbAtcTextColor'          => '#fff',
        'sbAtcBorderRadius'       => 0,
        'sbAtcFontSize'           => 15,
        'sbMobileAtcBgColor'      => '#1a7efb',
        'sbMobileAtcTextColor'    => '#fff',
        'sbMobileAtcBorderRadius' => 0,
        'sbMobileAtcFontSize'     => 13,
        'sbMobileImg'             => 1,
    ];

    $sideBarCart = [
        'scEnable'                             => 1,
        'scMobileEnable'                       => 0,
        'scIconEnable'                         => 1,
        'scEmptyEnable'                        => 1,
        'scAssignPage'                         => '!is_cart() && !is_checkout()',
        'scContentClassOpen'                   => '',
        'scDisplayType'                        => 2,
        'scPosition'                           => 'bottom_left',
        'scHorizontal'                         => 20,
        'scVertical'                           => 10,
        'scRadius'                             => 0,
        'scEffectAfterAtc'                     => 'shake_vertical',
        'scFlyToCart'                          => 1,
        'scTriggerStyle'                       => 'slide',
        'scTriggerType'                        => 'click',
        'scAutoClose'                          => '',
        'scLoading'                            => 'default',
        'scLoadingColor'                       => '#1a7efb',
        'scIconPosition'                       => 'bottom_left',
        'scIconHorizontal'                     => 20,
        'scIconVertical'                       => 10,
        'scIconStyle'                          => 1,
        'scIconBoxShadow'                      => 1,
        'scIconScale'                          => 1,
        'scIconHoverScale'                     => 1,
        'scIconBorderRadius'                   => 30,
        'scIconUseImg'                         => 0,
        'scIconImg'                            => '',
        'scIconDefaultIcon'                    => 2,
        'scIconBgColor'                        => '#fff',
        'scIconColor'                          => '#1a7efb',
        'scIconCountType'                      => 'pd_count',
        'scIconCountBgColor'                   => '#212121',
        'scIconCountColor'                     => '#fff',
        'scIconCountBorderRadius'              => 10,
        'scHeaderBgColor'                      => '#fff',
        'scHeaderBorderStyle'                  => 'solid',
        'scHeaderBorderColor'                  => '#e6e6e6',
        'scHeaderTitle'                        => 'YOUR CART',
        'scHeaderTitleColor'                   => '#181818',
        'scHeaderCouponEnable'                 => 1,
        'scHeaderCouponInputRadius'            => 0,
        'scHeaderCouponBtnBgColor'             => '#212121',
        'scHeaderCouponBtnTextColor'           => '#fff',
        'scHeaderCouponBtnBgColorHover'        => '#1a7efb',
        'scHeaderCouponBtnTextColorHover'      => '#fff',
        'scHeaderCouponButtonBorderRadius'     => 0,
        'scFootBgColor'                        => '#fff',
        'scFootBorderType'                     => 'solid',
        'scFootBorderWidth'                    => '#e6e6e6',
        'scFootCoupon'                         => 0,
        'scFootCartTotal'                      => 'subtotal',
        'scFootCartTotalText'                  => 'Subtotal:',
        'scFootCartTotalColor'                 => '#181818',
        'scFootCartTotalColor1'                => '#181818',
        'scFootButton'                         => 'checkout',
        'scFootBtCartText'                     => 'View Cart',
        'scFootBtCheckoutText'                 => 'CHECKOUT',
        'scFootButtonBgColor'                  => '#1a7efb',
        'scFootButtonColor'                    => '#fff',
        'scFootButtonHoverBgColor'             => '#ff7b54',
        'scFootButtonHoverColor'               => '#212121',
        'scFootButtonBorderRadius'             => 0,
        'scFootBtUpdateBgColor'                => '#a4a7a9',
        'scFootBtUpdateTextColor'              => '#fff',
        'scFootBtUpdateHoverBgColor'           => '#181818',
        'scFootBtUpdateHoverColor'             => '#fff',
        'scFootBtUpdateBorderRadius'           => 0,
        'scFootMsg'                            => '{product_plus}',
        'scFootPdPlus'                         => 'best_selling',
        'scFootPdPlusCats'                     => '',
        'scFootPdPlusProducts'                 => '',
        'scFootPdPlusTitle'                    => 'BEST SELLING PRODUCTS',
        'scFootPdPlusColor'                    => '#181818',
        'scFootPdPlusBtAtcTitle'               => '{cart_icon}',
        'scFootPdPlusBtAtcCartIcon'            => 1,
        'scFootPdPlusBtAtcBgColor'             => '#181818',
        'scFootPdPlusBtAtcColor'               => '#fff',
        'scFootPdPlusBtAtcHoverBgColor'        => '#1a7efb',
        'scFootPdPlusBtAtcHoverTextColor'      => '#fff',
        'scFootPdPlusLimit'                    => 5,
        'scFootPdPlusOutOfStock'               => 0,
        'scPdUpdateCart'                       => 1,
        'scPdBgColor'                          => '#fff',
        'scPdImgBoxShadow'                     => 0,
        'scPdImgBorderRadius'                  => 0,
        'scPdDescEnable'                       => 0,
        'scPdNameLink'                         => 1,
        'scPdNameColor'                        => '#2b3e51',
        'scPdNameHoverColor'                   => '#1a7efb',
        'scPdPriceColor'                       => '#222',
        'scPdPriceStyle'                       => 'price',
        'scPdQtyColor'                         => '#ddd',
        'scPdQtyBorderRadius'                  => 3,
        'scPdDeleteIcon'                       => 1,
        'scPdDeleteIconFontSize'               => '15',
        'scPdDeleteIconColor'                  => '#e6e6e6',
        'scPdDeleteIconHoverColor'             => '#fe2740',
        'scCheckOutEnable'                     => 0,
        'scCheckOutMobileEnable'               => 0,
        'scCheckOutCart'                       => 0,
        'scCheckOutKeyboardNav'                => 1,
        'scCheckOutBgColor'                    => '#fff',
        'scCheckoutLogin'                      => 0,
        'scCheckoutBillingTitle'               => 'Billing',
        'scCheckoutShippingTitle'              => 'Shipping',
        'scCheckoutOrderReviewTitle'           => 'Order Review',
        'scCheckoutPaymentTitle'               => 'Payments',
        'scCheckoutBillingShipping'            => 1,
        'scCheckoutBillingShippingTitle'       => 'Billing & Shipping',
        'scCheckoutOrderPayment'               => 1,
        'scCheckoutOrderPaymentTitle'          => 'Order & Payment',
        'scCheckoutBtBtcEnable'                => 1,
        'scCheckoutBtBtcTitle'                 => 'Back to Cart',
        'scCheckoutBtBtcIcon'                  => 0,
        'scCheckoutBtBtcBgColor'               => '#e6e6e6',
        'scCheckoutBtBtcColor'                 => '#fff',
        'scCheckoutBtBtcHoverBgColor'          => '#181818',
        'scCheckoutBtBtcHoverColor'            => '#fff',
        'scCheckoutBtBtcBorderRadius'          => 0,
        'scCheckoutBtNextTitle'                => '{next_title}',
        'scCheckoutBtNextBgColor'              => '#1a7efb',
        'scCheckoutBtNextColor'                => '#fff',
        'scCheckoutBtNextHoverBgColor'         => '#181818',
        'scCheckoutBtNextHoverColor'           => '#fff',
        'scCheckoutBtNextBorderRadius'         => 0,
        'scCheckoutBtPreTitle'                 => '{pre_title}',
        'scCheckoutBtPreBgColor'               => '#e6e6e6',
        'scCheckoutBtPreColor'                 => '#fff',
        'scCheckoutBtPreHoverBgColor'          => '#181818',
        'scCheckoutBtPreHoverColor'            => '#fff',
        'scCheckoutBtPreBorderRadius'          => 0,
        'scCheckoutBtPlaceOrderTitle'          => '{order_button_text}',
        'scCheckoutBtPlaceOrderBgColor'        => '#1a7efb',
        'scCheckoutBtPlaceOrderTextColor'      => '#fff',
        'scCheckoutBtPlaceOrderHoverBgColor'   => '#181818',
        'scCheckoutBtPlaceOrderHoverTextColor' => '#fff',
        'scCheckoutBtPlaceOrderBorderRadius'   => 0,
        'scCheckoutNavBar'                     => 1,
        'scCheckoutNavBarColor'                => '#eaeaea',
        'scCheckoutNavBarHoverColor'           => '#dadada',
        'scCheckoutNavBarSelectedColor'        => '#1a7efb',
    ];

    $customQuantity = [
        'cqEnable'                => 0,
        'cqSelectProduct'         => '',
        'enableInlineQuantity'    => 0,
        'cqItem'                  => 1,
        'cqPmBgColor'             => '#D1E5FE',
        'cqPmTextColor'           => '#1A7EFB',
        'cqBtnBgColor'            => '#FFFFFF',
        'cqBtnTextColor'          => '#6b7280',
        'cqQuantityTextColor'     => '#6b7280',
        'cqBtnBorderColor'        => '#ebebeb',
        'cqBtnBorderRadius'       => '5',
        'showQuantityText'        => 0,
    ];

    $menuCart = [
        'mcEnable'         => 0,
        'mcMobileEnable'   => 0,
        'mcEmptyEnable'    => 1,
        'mcMenuDisplay'    => [],
        'mcNavPage'        => 'cart',
        'mcContent'        => 1,
        'mcIcon'           => 1,
        'mcIconColor'      => '',
        'mcIconHoverColor' => '',
        'mcDisplayStyle'   => 'all',
        'mcCartTotal'      => 'subtotal',
        'mcColor'          => '',
        'mcHoverColor'     => '',
    ];

    $viewedProducts = [
        'vpEnable'             => 0,
        'vpDots'               => 0,
        'vpArrows'             => 0,
        'vpTitle'              => 'Your recently viewed items',
        'vpPdSlideToShow'      => 4,
        'vpSliderInfinity'     => 0,
        'vpSliderAuto'         => 0,
        'vpSliderSpeed'        => 2000,
        'vpSliderPause'        => 0,
        'vpEnableDeleteItem'   => 0,
    ];

    $productVariation = [
        'pvEnable'                     => 0,
        'enableSingleProductVariation' => 0,
        'convertDropdownToLabel'       => 0,
        'labelSettings'                => [
            'shape'   => 'square',
            'labelTT' => 1,
        ],
        'imageSettings' => [
            'shape'   => 'circle',
            'colorTT' => 1,
        ],
        'colorSettings' => [
            'shape'    => 'circle',
            'imageTT'  => 1,
            'lazyLoad' => 0,
        ],
    ];

    $tabCustomization = [
        'enableTabCustomization' => 0,
        'tabCustomization'       => [
            [
                'id'                         => '1',
                'tabTitle'                   => '',
                'tabDescription'             => '',
                'tabShowHide'                => true,
                'tabConditional'             => false,
                'userRoleBaseTabShow'        => [],
                'categoryBaseTabShow'        => [],
                'isGlobalTab'                => true,
                'specificProductBaseTabShow' => [],
            ],
        ],
    ];
    $quickView = [
        'enableQuickView' => 1,
        'quickViewBtn'    => [
            'name'           => 'qv-1',
            'icon'           => 'view-1',
            'bgColor'        => '#0a5fc7',
            'bgHoverColor'   => "#000000",
            'textColor'      => '#ffffff',
            'textHoverColor' => "#ffffff",
            'borderRadius'   => "100px",
            'padding'        => "0px",
        ],
        'advancedEditing'         => 0,
        'quickViewDisplayEffect'  => ['in' => 'fadeIn', 'out' => 'fadeOut'],
        'quickViewDisplayDevices' => ['Desktop', 'Tablet', 'Mobile'],
        'quickViewBtnPosition'    => 'afterCartBtn',
        'quickViewLayoutType'     => 'modal',
        'showElementOnQuickView'  => [
            'showProductImage',
            'quickShowProductName',
            'quickShowProductRating',
            'quickShowProductPrice',
            'quickShowProductShortDescription',
            'quickShowAddToCart',
            'quickShowProductSKU',
            'quickShowProductCategories',
            'quickShowProductTags',
            'quickShowProductReviews',
            'quickShowWishlist',
            'quickShowProductMeta',

        ],
        'quickViewBtnPositionHorizontal' => 'right',
    ];

    $saveShareCart = [
        'enableSaveCart'         => 1,
        'saveCartButtonPosition' => 'afterCartTable',
    ];

    $discountRule = [
        'discountRules' => [],
        'discountRule'  => [
            'id'               => null,
            'ruleStatus'       => false,
            'ruleName'         => 'Untitled Rule',
            'ruleType'         => 'fixed',
            'ruleValue'        => '',
            'discountCriteria' => [
                [
                    'id'       => null,
                    'criteria' => 'product_name',
                    'option'   => [],
                    'items'    => [],
                    'logic'    => 'or',
                ]
            ],
            'maximumUsageLimit' => '',
            'ruleStartDate'     => 'unknown',
            'ruleEnd'           => 'unknown',
            'ruleCreatedBy'     => 'unknown',
            'ruleCreatedAt'     => 'unknown',
            'ruleModifiedBy'    => 'unknown',
            'ruleModifiedAt'    => 'unknown',
        ],
    ];

    $gallerySettings = [
        'enableGallerySlider'        => 1,
        'galleryLayoutType'          => 'thumb-bottom',
        'enableGalleryOnShopPage'    => 0,
        'shopPageArrows'             => 0,
        'shopPageDots'               => 0,
        'shopPageAutoPlay'           => 0,
        'enableGalleryThumbnail'     => 1,
        'galleryThumbType'           => 'nav-border-around',
        'enableFeaturedImage'        => 1,
        'enableProductGallery'       => 1,
        'enableVariationImages'      => 0,
        'enableImageCaption'         => 1,
        'enableSliderAutoPlay'       => 1,
        'galleryAutoPlaySpeed'       => 3000,
        'enableSliderLoop'           => 1,
        'enableSliderFadeEffect'     => 0,
        'enableAutoHeight'           => 0,
        'gallerySliderDraggable'     => 0,
        'galleryLazyLoad'            => 0,
        'galleryPauseOnHover'        => 0,
        'galleryPauseOnDotsHover'    => 0,
        'galleryPauseOnFocus'        => 0,
        'gallerySwipe'               => 0,
        'gallerySlidesToShow'        => 1,
        'gallerySlidesToScroll'      => 1,
        'gTabletSlidesToShow'        => 1,
        'gTabletSlidesToScroll'      => 1,
        'gTabletSliderArrows'        => 0,
        'gTabletSliderDots'          => 0,
        'gSmallSlidesToShow'         => 1,
        'gSmallSlidesToScroll'       => 1,
        'gSmallSliderArrows'         => 0,
        'gSmallSliderDots'           => 0,
        'gExSmallSlidesToShow'       => 1,
        'gExSmallSlidesToScroll'     => 1,
        'gExSmallSliderArrows'       => 0,
        'gExSmallSliderDots'         => 0,
        'gallerySpeed'               => 300,
        'galleryVertical'            => 0,
        'gallerySliderArrows'        => 1,
        'gallerySliderDots'          => 1,
        'galleryNavPosition'         => 'center-center',
        'sliderNavBorderRadius'      => '3',
        'selectPaginationType'       => 'bullets',
        'enablePaginationVisibility' => 1,
        'pSliderArrowBgColor'        => '#ff0000',
        'pSliderArrowActiveBgColor'  => '#022b59',
        'pSliderArrowIconColor'      => '#ffffff',
        'pSliderArrowIconHoverColor' => '#ffffff'
    ];

    $productVideo = [
        'productVideo'       => 0,
        'videoUrl'           => 'https://youtu.be/i9U1E12ntSc?si=jJ1l7iTxSYcsOScd',
        'playMode'           => 'inline',
        'videoIconPosition'  => 'top-right',
        'playIconColor'      => '#5D6B7D',
        'playIconHoverColor' => '#1A7EFB',
        'videoBGColor'       => '#1A7EFB',
        'bgGaps'             => 0,
        'bgGapsRadius'       => 0,
        'videoPlayMode'      => 'auto',
        'playerControls'     => 1,
        'videoMute'          => 1,
        'VideoSize'          => 'auto',
        'videoPoster'        => 1
    ];

    $wishlistSettings = [
        'enableViewWishlist'          => 1,
        'showWishlistOnSingleProduct' => 1,
        'wishListBtn'                 => [
            'name'           => 'wishlist-1',
            'icon'           => 'wishlist-1',
            'bgColor'        => '#0a5fc7',
            'bgHoverColor'   => "#000000",
            'textColor'      => '#ffffff',
            'textHoverColor' => "#ffffff",
            'borderRadius'   => "100px",
            'padding'        => "0px",
        ],
        'wishlistAdvancedDesign'    => 0,
        'wishlistBtnPos'            => 'afterCartBtn',
        'viewWishlistPosition'      => 'right',
        'wishlistShortcode'         => '[eaw_wishlist product_id=0]',
        'wishlistViewLayoutType'    => 'modal',
        'wishlistDisplayDevices'    => ['Desktop', 'Tablet', 'Mobile'],
        'wishlistDisplayEffect'     => ['in' => 'fadeIn', 'out' => 'fadeOut']
    ];

    $currencySwitcher = [
        'enableCurrencySwitcher'            => 0,
        'selectedCurrency'                  => ['USD', 'EUR', 'GBP'],
        'currencyBarPosition'               => 'web-right-middle',
        'switcherDisplayDevices'            => ['desktop', 'tablet', 'mobile'],
        'currencyByCountry'                 => 0,
        'currencyBarTitle'                  => 'Switch Currency',
    ];

    $default_settings = array_merge(
        ['custom_css' => ''],
        $ajaxATC,
        $stickyATC,
        $sideBarCart,
        $customQuantity,
        $menuCart,
        $stickyATC,
        $viewedProducts,
        $productVariation,
        $quickView,
        $saveShareCart,
        $tabCustomization,
        $discountRule,
        $gallerySettings,
        $productVideo,
        $wishlistSettings,
        $currencySwitcher
    );

    return $default_settings;
}

/**
 * Returns an array of icon classes for the plugin.
 *
 * The array contains the following keys:
 *
 * - `back_icons`: icons for back button.
 * - `cart_icons_atc`: icons for add to cart button.
 * - `cart_icons`: icons for cart.
 * - `delete_icons`: icons for delete button.
 *
 * @return array
 */
function ccpeaw_icon_classes()
{
    return [
        'back_icons' => [
            'eaw_back_icons-back-arrow',
            'eaw_back_icons-back-arrow-1',
            'eaw_back_icons-back',
            'eaw_back_icons-left-arrow-2',
            'eaw_back_icons-previous',
            'eaw_back_icons-go-back-arrow',
            'eaw_back_icons-x-mark',
            'eaw_back_icons-back-button',
            'eaw_back_icons-return',
            'eaw_back_icons-undo',
            'eaw_back_icons-left-arrow-1',
            'eaw_back_icons-back-1',
            'eaw_back_icons-left-arrow',
            'eaw_cart_icon-clear-button',
        ],
        'cart_icons_atc' => [
            'eaw_cart_icon_atc-plus',
            'eaw_cart_icon_atc-plus-1',
            'eaw_cart_icon_atc-add-to-basket',
            'eaw_cart_icon_atc-shopping-cart-4',
            'eaw_cart_icon_atc-shopping-basket',
            'eaw_cart_icon_atc-add-to-cart-3',
            'eaw_cart_icon_atc-shopping-cart-2',
            'eaw_cart_icon_atc-cart',
            'eaw_cart_icon_atc-shopping-cart-5',
            'eaw_cart_icon_atc-add-to-cart-4',
            'eaw_cart_icon_atc-shopping-cart-6',
            'eaw_cart_icon_atc-add-to-cart-1',
            'eaw_cart_icon_atc-add-to-cart',
            'eaw_cart_icon_atc-add-to-shopping-cart-1',
            'eaw_cart_icon_atc-add-to-basket-1',
            'eaw_cart_icon_atc-add-to-cart-2',
            'eaw_cart_icon_atc-add-to-shopping-cart',
            'eaw_cart_icon_atc-shopping-cart-1',
            'eaw_cart_icon_atc-shopping-cart-3',
            'eaw_cart_icon_atc-shopping-cart',
        ],
        'cart_icons' => [
            'eaw_cart_icon-commerce',
            'eaw_cart_icon-shopping-cart-13',
            'eaw_cart_icon-cart-of-ecommerce',
            'eaw_cart_icon-shopping-cart-with-product-inside',
            'eaw_cart_icon-plus',
            'eaw_cart_icon-shopping-store-cart',
            'eaw_cart_icon-shopping-cart-black-shape',
            'eaw_cart_icon-shopping-cart-2',
            'eaw_cart_icon-empty-shopping-cart',
            'eaw_cart_icon-supermarket-2',
            'eaw_cart_icon-cart-6',
            'eaw_cart_icon-shopping-cart-5',
            'eaw_cart_icon-sell',
            'eaw_cart_icon-supermarket-4',
            'eaw_cart_icon-supermarket-5',
            'eaw_cart_icon-shopping-cart-of-checkered-design',
            'eaw_cart_icon-shopping-cart-9',
            'eaw_cart_icon-buy',
            'eaw_cart_icon-grocery-trolley',
            'eaw_cart_icon-supermarket-6',
            'eaw_cart_icon-shopping-cart-4',
            'eaw_cart_icon-shopping-cart-11',
            'eaw_cart_icon-shopping-cart-16',
            'eaw_cart_icon-supermarket-3',
            'eaw_cart_icon-shopping-cart-15',
            'eaw_cart_icon-cart-1',
            'eaw_cart_icon-cart-7',
            'eaw_cart_icon-commerce-and-shopping',
            'eaw_cart_icon-shopping-cart-8',
            'eaw_cart_icon-cart-5',
            'eaw_cart_icon-supermarket',
            'eaw_cart_icon-shopping-cart-1',
            'eaw_cart_icon-online-shopping-cart',
            'eaw_cart_icon-cart-4',
            'eaw_cart_icon-shopping-cart-14',
            'eaw_cart_icon-shopping-cart-3',
            'eaw_cart_icon-cart-3',
            'eaw_cart_icon-shopping-cart-6',
            'eaw_cart_icon-shopping-cart-10',
            'eaw_cart_icon-shopping-cart-12',
            'eaw_cart_icon-cart-2',
            'eaw_cart_icon-commerce-1',
            'eaw_cart_icon-shopping-cart',
            'eaw_cart_icon-shopping-cart-7',
            'eaw_cart_icon-supermarket-1',
        ],
        'delete_icons' => [
            'eaw_cart_icon-clear-button',
            'eaw_cart_icon-rubbish-bin-delete-button',
            'eaw_cart_icon-delete-1',
            'eaw_cart_icon-waste-bin',
            'eaw_cart_icon-trash',
            'eaw_cart_icon-garbage-1',
            'eaw_cart_icon-delete-button',
            'eaw_cart_icon-delete',
            'eaw_cart_icon-rubbish-bin',
            'eaw_cart_icon-dustbin',
            'eaw_cart_icon-garbage',
        ],
    ];
}
