<?php

defined('ABSPATH') or exit('Direct access to this file is not allowed.');


/**
 * Version of the plugin.
 *
 * @var string
 */
define('CCPEAW_VERSION', '1.0.9');

/**
 * Directory path of the plugin.
 *
 * @var string
 */
define('CCPEAW_PATH', plugin_dir_path(CCPEAW_FILE));

/**
 * URL of the plugin.
 *
 * @var string
 */
define('CCPEAW_URL', plugin_dir_url(CCPEAW_FILE));

/**
 * URL of the plugin assets.
 *
 * @var string
 */
define('CCPEAW_ASSETS', CCPEAW_URL . 'assets');

/**
 * Directory path of the plugin includes.
 *
 * @var string
 */
define('CCPEAW_INCLUDES', CCPEAW_PATH . 'includes');

define('CCPEAW_INTEGRATIONS', CCPEAW_INCLUDES . '/Integrations');

define('CCPEAW_INTEGRATIONS_URL', CCPEAW_URL . 'includes/Integrations');

/**
 * Directory path of the plugin models.
 *
 * @var string
 */
define('CCPEAW_MODELS', CCPEAW_PATH . 'models');

/**
 * Directory path of the plugin updates.
 *
 * @var string
 */
define('CCPEAW_UPDATES', CCPEAW_INCLUDES . '/updates');

/**
 * Directory path of the plugin app.
 *
 * @var string
 */
define('CCPEAW_APP', CCPEAW_PATH . 'app');

/**
 * Directory path of the plugin vendor.
 *
 * @var string
 */
define('CCPEAW_VENDORS', CCPEAW_PATH . 'vendors');

/**
 * Text domain of the plugin.
 *
 * @var string
 */
define('CCPEAW_TEXTDOMAIN', 'essential-addons-for-woocommerce');

/**
 * Path of the plugin textdomain.
 *
 * @var string
 */
define('CCPEAW_TEXTDOMAIN_PATH', dirname(plugin_basename(CCPEAW_FILE)) . '/languages/');

/**
 * Slug of the plugin.
 *
 * @var string
 */
define('CCPEAW_SLUG', 'essential-addons-for-woocommerce');

/**
 * Name of the plugin options.
 *
 * @var string
 */
define('CCPEAW_OPTIONS_NAME', 'ccpeaw_settings');

/**
 * Version of the plugin options.
 *
 * @var string
 */
define('CCPEAW_OPTIONS_VERSION', '1.0.0');

/**
 * Version of the plugin database.
 *
 * @var string
 */
define('CCPEAW_DB_VERSION', '1.0.0');

/**
 * Prefix of the plugin database tables.
 *
 * @var string
 */
define('CCPEAW_DB_PREFIX', 'eaw_');

/**
 * Author of the plugin.
 *
 * @var string
 */
define('CCPEAW_AUTHOR', 'CodeConfig');

/**
 * URL of the plugin author.
 *
 * @var string
 */
define('CCPEAW_AUTHOR_URL', 'https://codeconfig.dev');

/**
 * URL of the plugin.
 *
 * @var string
 */
define('CCPEAW_PLUGIN_URL', 'https://codeconfig.dev/essential-addons-for-woocommerce/');

/**
 * URL of the plugin documentation.
 *
 * @var string
 */
define('CCPEAW_DOCUMENTATION_URL', 'https://codeconfig.dev/docs-category/essential-addons-for-woocommerce/');
/**
 * Name of the plugin.
 *
 * @var string
 */
define('CCPEAW_NAME', 'Essential Addons for WooCommerce');

/**
 * Minimum PHP version required for the plugin.
 *
 * @var string
 */
define('CCPEAW_PHP_VERSION', '7.4');

/**
 * Minimum WordPress version required for the plugin.
 *
 * @var string
 */
define('CCPEAW_WP_VERSION', '5.2');

/**
 * Capability to access the plugin's file management pages.
 *
 * @var string
 */
define('CCPEAW_ACCESS_CAP', 'manage_CCPEAW_files');

/**
 * Initialize the plugin.
 *
 * @return void
 */
define('CCPEAW_TEMPLATES', CCPEAW_PATH . 'templates/');
