<?php

namespace CodeConfig\EAW\App;

use CodeConfig\EAW\Utils\Helpers;
use CodeConfig\EAW\Utils\Singleton;

defined('ABSPATH') || exit('No direct script access allowed');

class Tabs
{
    use Singleton;

    public function doHooks()
    {
        add_filter('woocommerce_product_tabs', [$this, 'tabs'], 98);
    }

    public function tabs($tabs)
    {
        $isEnableTab = Helpers::getSetting('enableTabCustomization');

        if (!$isEnableTab) {
            return $tabs;
        }

        $customTabs = Helpers::getSetting('tabCustomization');


        if (is_array($customTabs)) {
            global $product;
            $productId = $product->get_id();

            foreach ($customTabs as $key => $tab) {
                $showTab = true;

                // Check if tab conditions should be applied
                if (!empty($tab['tabConditional']) && $tab['tabConditional'] === '1') {
                    // Category-based condition
                    if (!empty($tab['categoryBaseTabShow'])) {
                        $productCategories = wc_get_product_terms($productId, 'product_cat', ['fields' => 'ids']);
                        $categoriesToShow  = array_filter($tab['categoryBaseTabShow']); // Remove empty strings
                        $showTab           = !empty(array_intersect($productCategories, $categoriesToShow));
                    }

                    // Product-based condition
                    if ($showTab && !empty($tab['productBaseTabShow'])) {
                        $productsToShow = array_filter($tab['productBaseTabShow']); // Remove empty strings
                        $showTab        = in_array((string) $productId, $productsToShow, true);
                    }

                    // User role-based condition
                    if ($showTab && !empty($tab['userRoleBaseTabShow'])) {
                        $user        = wp_get_current_user();
                        $userRoles   = !empty($user->roles) ? $user->roles : [];
                        $rolesToShow = array_filter($tab['userRoleBaseTabShow']); // Remove empty strings
                        $showTab     = !empty(array_intersect($userRoles, $rolesToShow));
                    }
                }

                // Add tab if conditions are met
                if ($showTab) {
                    $tabs[$key] = [
                        'title'    => $tab['label'] ?? __('Custom Tab', 'essential-addons-for-woocommerce'),
                        'priority' => isset($tab['id']) ? (int) $tab['id'] + 50 : 50,
                        'callback' => function () use ($tab) {
                            echo '<p>' . (esc_attr($tab['tabDescription']) ?? __('No content provided.', 'essential-addons-for-woocommerce')) . '</p>';
                        }
                    ];
                }
            }

            uasort($tabs, function ($a, $b) {
                $idA = isset($a['priority']) ? (int) $a['priority'] : 0;
                $idB = isset($b['priority']) ? (int) $b['priority'] : 0;

                return $idA <=> $idB;
            });
        }

        return $tabs;
    }
}
