<?php

namespace CodeConfig\EAW\App\CartManager;

use CodeConfig\EAW\AppSettings;
use CodeConfig\EAW\Utils\Singleton;

defined('ABSPATH') || exit('No direct script access allowed');

class VariableATC
{
    use Singleton;
    protected $settings;
    protected $language;

    public function doHooks()
    {
        $this->settings = AppSettings::getInstance();
        if ($this->settings->getParams('ajax_atc_pd_variable')) {
            add_action('wp_enqueue_scripts', [$this, 'eaw_wp_enqueue_scripts']);
            add_filter('woocommerce_loop_add_to_cart_link', [$this, 'eaw_woocommerce_loop_add_to_cart_link'], PHP_INT_MAX, 2);
        }
    }

    public function eaw_woocommerce_loop_add_to_cart_link($result, $product)
    {
        if ($product->is_type('variable')) {
            if (! wp_style_is('eaw-variable-atc', 'enqueued')) {
                wp_enqueue_style('eaw-variable-atc');
                wp_enqueue_style('eaw-nav-icons');
            }
            if (! wp_script_is('eaw-variable-atc', 'enqueued')) {
                wp_enqueue_script('eaw-variable-atc');
                wp_enqueue_script('eaw-ajax-atc');
                wp_enqueue_script('eaw-frontend-swatches');
            }
            $result = str_replace('class="', 'class="eaw-loop-variable-bt-atc ', $result);
        }

        return $result;
    }



    public function eaw_wp_enqueue_scripts()
    {
        if (is_admin()) {
            return;
        }
        wp_register_style('eaw-variable-atc', CCPEAW_ASSETS . '/frontend/css/' . 'variable-atc.min.css', [], CCPEAW_VERSION);
        wp_register_style('eaw-nav-icons', CCPEAW_ASSETS . '/frontend/css/' . 'nav-icons.min.css', [], CCPEAW_VERSION);

        wp_register_script('eaw-variable-atc', CCPEAW_ASSETS . '/frontend/js/' . 'variable-atc.js', ['jquery'], CCPEAW_VERSION, false);
        wp_register_script('eaw-ajax-atc', CCPEAW_ASSETS . '/js/' . 'ajax-add-to-cart.js', ['jquery'], CCPEAW_VERSION, false);
        wp_enqueue_script('eaw-frontend-swatches');
        $args = [
            'wc_ajax_url' => \WC_AJAX::get_endpoint("%%endpoint%%"),
        ];
        wp_localize_script('eaw-variable-atc', 'eaw_va_params', $args);
        $args1 = [
            'isAjaxAtcEnabled'                            => $this->settings->getParams('enableAjaxATC'),
            'wc_ajax_url'                                 => \WC_AJAX::get_endpoint("%%endpoint%%"),
            'nonce'                                       => wp_create_nonce('ccpeaw'),
            'woocommerce_enable_ajax_add_to_cart'         => 'yes' === get_option('woocommerce_enable_ajax_add_to_cart') ? 1 : '',
            'added_to_cart'                               => did_action('woocommerce_add_to_cart') ?: '',
            'ajax_atc_pd_exclude'                         => $this->settings->getParams('ajax_atc_pd_exclude') ?: [],
            'i18n_make_a_selection_text'                  => apply_filters('eaw-i18n_make_a_selection_text', esc_html__('Please select some product options before adding this product to your cart.', 'essential-addons-for-woocommerce')),
            'i18n_unavailable_text'                       => apply_filters('eaw-i18n_unavailable_text', esc_html__('Sorry, this product is unavailable. Please choose a different combination.', 'essential-addons-for-woocommerce')),
            'cart_url'                                    => apply_filters('woocommerce_add_to_cart_redirect', wc_get_cart_url(), null),
            'cart_redirect_after_add'                     => get_option('woocommerce_cart_redirect_after_add'),
        ];
        wp_localize_script('eaw-ajax-atc', 'eawAtcVars', $args1);
    }
}
