<?php

namespace CodeConfig\EAW\App\CartManager;

use CodeConfig\EAW\AppSettings;
use CodeConfig\EAW\Utils\Helpers;
use CodeConfig\EAW\Utils\Singleton;

defined('ABSPATH') || exit('No direct script access allowed');

class StickyBar
{
    use Singleton;
    protected $settings;
    protected $language;
    public static $product;

    public function doHooks()
    {
        $this->settings = AppSettings::getInstance();
        $this->language = '';
        add_action('wp_enqueue_scripts', [$this, 'enqueueScripts']);
        add_action('eaw-product-simple-add-to-cart', [$this, 'simpleProductATC'], 10, 3);
        add_action('eaw-product-variable-add-to-cart', [$this, 'variableProductATC'], 10, 3);
        add_action('eaw-product-external-add-to-cart', [$this, 'externalProductATC'], 10, 3);
        add_action('eaw-product-grouped-add-to-cart', [$this, 'groupedProductATC'], 10, 3);
        add_action('eaw_sb_mobile_button_action', [$this, 'MobileSbBtnAction'], 10, 1);
        add_action('eaw_sb_mobile_variable_add_to_cart', [
            $this,
            'MobileVariableProductATC'
        ], 10, 1);
    }

    public function enqueueScripts()
    {
        if (! is_single() && ! is_product()) {
            return;
        }
        if (! $this->settings->getParams('sbEnable') && ! is_customize_preview()) {
            return;
        }
        global $post;
        $product_id = isset($post->ID) ? absint($post->ID) : 0;

        if (!$product_id) {
            return;
        }

        $excluded_products = array_map('intval', (array) $this->settings->getParams('sbProductExclude'));

        if (!empty($excluded_products) && in_array($product_id, $excluded_products, true)) {
            return;
        }

        $product = wc_get_product($product_id);
        if (!$product) {
            return;
        }
        self::$product = $product;
        $cats_id       = wc_get_product_cat_ids($product_id);
        $cats_id_check = $this->settings->getParams('sbExcludeCategories');
        if ($cats_id_check && is_array($cats_id_check) && count(array_intersect($cats_id, $cats_id_check))) {
            return;
        }
        wp_enqueue_style('eaw-atc-cart-icons', CCPEAW_ASSETS . '/css/frontend/' . 'cart-icons-atc.min.css', [], CCPEAW_VERSION);

        wp_enqueue_style('eaw-sticky-bar', CCPEAW_ASSETS . '/css/frontend/' . 'sticky-bar.css', [], CCPEAW_VERSION);
        wp_enqueue_script('eaw-sticky-bar', CCPEAW_ASSETS . '/js/'  . 'sticky-bar.js', ['jquery'], CCPEAW_VERSION);
        if ($product && $product->is_type(['variable'])) {
            wp_enqueue_script('eaw-frontend-swatches');
        }

        $args = [
            'wc_ajax_url'     => \WC_AJAX::get_endpoint("%%endpoint%%"),
            'nonce'           => wp_create_nonce('ccpeaw'),
            'pvEnable'        => $this->settings->getParams('pvEnable'),
        ];
        wp_localize_script('eaw-sticky-bar', 'eawStickyBarVars', $args);
        $css = $this->get_inline_css();
        wp_add_inline_style('eaw-sticky-bar', $css);
        add_action('wp_footer', [$this, 'frontendHtml'], 11);

        $languageInfo   = Helpers::getLanguageInfo();
        $this->language = $languageInfo['default_language'];
    }

    public function get_inline_css()
    {
        $css = '';
        if ($sbBoxShadowColor = $this->settings->getParams('sbBoxShadowColor')) {
            $css .= ".eaw-sb-container:not(.eaw-sb-container-popup) { box-shadow: 0 1px 4px 0 " . esc_attr($sbBoxShadowColor) . ";}";
        }
        $frontend = Frontend::getInstance();
        $css      .= $frontend::add_inline_style(
            ['.eaw-sb-container'],
            ['sbBgColor', 'sbPadding', 'sbBorderRadius'],
            ['background', 'padding', 'border-radius'],
            ['', '', 'px']
        );

        $css      .= $frontend::add_inline_style(
            ['.eaw-sb-container .button.eaw-product-bt-atc'],
            ['sbAtcBgColor', 'sbAtcTextColor', 'sbAtcBorderRadius', 'sbAtcFontSize'],
            ['background', 'color', 'border-radius', 'font-size'],
            ['', '', 'px', 'px'],
            [false, true, false, false]
        );
        $css      .= $frontend::add_inline_style(
            ['.eaw-sb-container .eaw-sb-product-title'],
            ['sbProductNameColor'],
            ['color'],
            ['']
        );
        $css      .= $frontend::add_inline_style(
            ['.eaw-sb-container .eaw-sb-product-price-wrap .price'],
            ['sbPriceColor2'],
            ['color'],
            ['']
        );
        $css      .= $frontend::add_inline_style(
            ['.eaw-sb-container .eaw-sb-product-price-wrap .price del'],
            ['sbProductPriceColor'],
            ['color'],
            ['']
        );
        $css      .= $frontend::add_inline_style(
            ['.eaw-sb-container .eaw-sb-product-rating-wrap *:before'],
            ['sbRatingColor'],
            ['color'],
            ['']
        );
        $css      .= $frontend::add_inline_style(
            ['.eaw-sb-container .eaw-sb-product-img-wrap, .eaw-sb-container .eaw-sb-product-img-wrap img'],
            ['sbProductImgWidth', 'sbProductImgWidth', 'sbProductImgHeight', 'sbProductImgHeight'],
            ['width', 'max-width', 'height', 'max-height'],
            ['px', 'px', 'px', 'px']
        );
        $css      .= '@media screen and (max-width: 1000px){';
        $css      .= $frontend::add_inline_style(
            ['.eaw-sb-container .button.eaw-product-bt-atc'],
            [
                'sbMobileAtcBgColor',
                'sbMobileAtcTextColor',
                'sbMobileAtcBorderRadius',
                'sbAtcFontSize'
            ],
            ['background', 'color', 'border-radius', 'font-size'],
            ['', '', 'px', 'px'],
            [false, true, false, false]
        );
        $css      .= '}';

        return $css;
    }


    public function frontendHtml()
    {
        global $product;
        global $post;
        $post_default    = $post;
        $product_default = $product;
        $product         = self::$product;
        if (! $product && isset($post->ID)) {
            $product = wc_get_product(absint($post->ID));
        }
        if (! $product) {
            return;
        }
        $post       = get_post($product->get_id());
        $sbTemplate = absint($this->settings->getParams('sbTemplate'));
        $sbPosition = $this->settings->getParams('sbPosition') ? sanitize_text_field($this->settings->getParams('sbPosition')) : '0';
        if (is_customize_preview()) {
            for ($i = 1; $i < 5; $i++) {
                wc_get_template(
                    'sticky-bar.php',
                    [
                        'product'           => $product,
                        'template'          => $i,
                        'position'          => $sbPosition,
                        'settings'          => $this->settings,
                        'always_appear'     => 0,
                        'customize_preview' => true,
                    ],
                    'essential-addons-for-woocommerce' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR,
                    CCPEAW_TEMPLATES . 'atc/'
                );
            }
            wc_get_template(
                'sticky-bar-mobile.php',
                [
                    'product'           => $product,
                    'position'          => $this->settings->getParams('sbMobilePosition'),
                    'settings'          => $this->settings,
                    'always_appear'     => 0,
                    'customize_preview' => true,
                ],
                'essential-addons-for-woocommerce' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR,
                CCPEAW_TEMPLATES . 'atc/'
            );

            return;
        }
        if (wp_is_mobile()) {

            if ($this->settings->getParams('sbMobileEnable')) {
                wc_get_template(
                    'sticky-bar-mobile.php',
                    [
                        'product'       => $product,
                        'position'      => sanitize_text_field($this->settings->getParams('sbMobilePosition') ?: '0'),
                        'settings'      => $this->settings,
                        'always_appear' => absint($this->settings->getParams('sbAlwaysShow'))
                    ],
                    'essential-addons-for-woocommerce' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR,
                    CCPEAW_TEMPLATES . 'atc/'
                );
            }
        } else {
            wc_get_template(
                'sticky-bar.php',
                [
                    'product'           => $product,
                    'template'          => $sbTemplate,
                    'position'          => $sbPosition,
                    'settings'          => $this->settings,
                    'always_appear'     => absint($this->settings->getParams('sbAlwaysShow')),
                    'customize_preview' => false,
                ],
                'essential-addons-for-woocommerce' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR,
                CCPEAW_TEMPLATES . 'atc/'
            );
        }
        $product = $product_default;
        $post    = $post_default;
    }

    public function MobileVariableProductATC($product)
    {
        $attributes = $product->get_variation_attributes();
        if (empty($attributes)) {
            return;
        }
        $variation_count     = count($product->get_children());
        $get_variations      = $variation_count <= apply_filters('woocommerce_ajax_variation_threshold', 30, $product);
        $selected_attributes = $product->get_default_attributes();
        if ($get_variations) {
            $available_variations = $product->get_available_variations();
            if (empty($available_variations)) {
                return;
            }
            $variations_json = wp_json_encode($available_variations);
            $variations_attr = function_exists('wc_esc_json') ? wc_esc_json($variations_json) : _wp_specialchars($variations_json, ENT_QUOTES, 'UTF-8', true);
        } else {
            $variations_attr = false;
        }
        $product_id   = absint($product->get_id());
        $product_name = sanitize_text_field($product->get_name());
        ?>
		<form class="eaw-sb-cart-form eaw-sb-cart-swatches eaw-cart-swatches-wrap variations_form"
			action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>"
			method="post" enctype="multipart/form-data"
			data-product_id="<?php echo esc_attr($product_id); ?>"
			data-product_sku="<?php echo esc_attr(sanitize_text_field($product->get_sku())); ?>"
			data-product_name="<?php echo esc_attr($product_name); ?>"
			data-variation_count="<?php echo esc_attr(absint($variation_count)); ?>"
			data-product_variations="<?php echo esc_attr($variations_attr); ?>">
			<div class="eaw-sb-cart-form-header-wrap">
				<div class="eaw-sb-cart-form-header eaw-sb-cart-form-header-image">
					<?php
                        $product_img_url = wp_get_attachment_image_url(get_post_thumbnail_id($product_id), 'woocommerce_gallery_thumbnail');
        if (! $product_img_url) {
            $product_img_url = wc_placeholder_img_src();
        }


        echo sprintf(
            '<img src="%1$s" data-src="%2$s" class="eaw-sb-product-img" alt="%3$s">',
            esc_url($product_img_url),
            esc_url($product_img_url),
            esc_attr($product_name)
        );
        ?>

				</div>
				<div class="eaw-sb-cart-form-header eaw-sb-cart-form-header-desc">
					<div class="eaw-sb-product-price-wrap">
						<span class="price"><?php echo wp_kses($product->get_price_html(), AppSettings::extendPostAllowedHtml()); ?></span>
					</div>
					<div class="eaw-sb-product-rating-wrap"><?php echo esc_html(wc_get_rating_html($product->get_average_rating())); ?></div>
				</div>
			</div>
			<div class="eaw-sb-cart-form-content-wrap">
				<?php
                foreach ($attributes as $attribute_name => $options) {
                    $attribute_name = sanitize_text_field($attribute_name);
                    $selected       = isset($selected_attributes[$attribute_name]) ? sanitize_text_field($selected_attributes[$attribute_name]) : sanitize_text_field($product->get_variation_default_attribute($attribute_name));
                    echo sprintf('<div class="eaw-sb-cart-form-content eaw-sb-swatches-wrap eaw-swatches-wrap"><div class="eaw-sb-cart-form-content-title">%s</div>', esc_html(wc_attribute_label($attribute_name, $product)));
                    echo sprintf('<div class="eaw-sb-cart-form-content-value eaw-sb-swatches-value eaw-swatches-value value">');
                    wc_dropdown_variation_attribute_options(apply_filters('eaw_dropdown_variation_attribute_options', [
                        'options'                 => $options,
                        'attribute'               => $attribute_name,
                        'product'                 => $product,
                        'selected'                => $selected,
                        'id'                      => sanitize_title($attribute_name) . '_' . absint(current_time('timestamp')),
                        'class'                   => 'eaw-attribute-options eaw-sb-attribute-options',
                        'eaw_swatches_disable'    => ! $this->settings->getParams('sbShowSwatches')
                    ], $attribute_name, $product));
                    echo sprintf('</div></div>');
                }
        echo sprintf(
            '<div class="eaw-sb-cart-form-content eaw-sb-cart-form-content-qty"><div class="eaw-sb-cart-form-content-title">%s</div>',
            esc_html(apply_filters('eaw_sb_mobile_set_qty_title', __('Quantity', 'essential-addons-for-woocommerce')))
        );

        echo sprintf('<div class="eaw-sb-cart-form-content-value">');
        self::product_get_quantity($product, $this->settings->getParams('sbShowQuantity'));
        echo sprintf('</div></div>');
        ?>
			</div>
			<div class="eaw-sb-cart-form-footer-wrap">
				<?php do_action('eaw_before_add_to_cart_button'); ?>
				<button type="submit" class="eaw-product-bt-atc eaw-sb-product-bt-atc button">
					<?php echo wp_kses_post(self::product_get_bt_atc_html($this->settings, $this->language)); ?>
				</button>

				<?php do_action('eaw_after_add_to_cart_button'); ?>
			</div>
		</form>
		<?php
    }

    public function MobileSbBtnAction($product)
    {
        switch ($product_type = $product->get_type()) {
            case 'simple':
                $product_id   = absint($product->get_id());
                $product_name = sanitize_text_field($product->get_name());
                ?>
				<form class="eaw-sb-cart-form"
					action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>"
					method="post" enctype="multipart/form-data"
					data-product_sku="<?php echo esc_attr(sanitize_text_field($product->get_sku())); ?>"
					data-product_name="<?php echo esc_attr($product_name); ?>"
					data-product_id="<?php echo esc_attr($product_id); ?>">
					<?php
                            do_action('eaw_before_add_to_cart_button');
                self::product_get_quantity($product, $this->settings->getParams('sbShowQuantity'));
                ?>
					<button type="submit" class="eaw-product-bt-atc eaw-sb-product-bt-atc button">
						<?php echo wp_kses_post(self::product_get_bt_atc_html($this->settings, $this->language)); ?>
					</button>
					<input type="hidden" name="add-to-cart" class="eaw-add-to-cart"
						value="<?php echo esc_attr($product_id); ?>" />
					<input type="hidden" name="product_id" class="eaw-product_id"
						value="<?php echo esc_attr($product_id); ?>" />
					<?php do_action('eaw_after_add_to_cart_button'); ?>
				</form>
			<?php
                break;
            case 'variable':
                echo sprintf(
                    '<button class="eaw-product-bt-atc eaw-sb-product-bt-atc eaw-sb-product-bt-popup eaw-product-bt-not-atc button">%s</button>',
                    wp_kses_post(self::product_get_bt_atc_html($this->settings, $this->language))
                );

                break;
            case 'external':
                ?>
				<form class="eaw-sb-cart-form"
					action="<?php echo esc_attr(esc_url($product->add_to_cart_url())); ?>" method="get">
					<?php do_action('eaw_before_add_to_cart_button'); ?>
					<button type="submit"
						class="eaw-product-bt-atc eaw-sb-product-bt-atc eaw-product-bt-external eaw-product-bt-not-atc button">
						<?php echo wp_kses_post(self::product_get_bt_atc_html($this->settings, $this->language)); ?>
					</button>
					<?php do_action('eaw_after_add_to_cart_button'); ?>
				</form>
		<?php
                    break;
            case 'grouped':
                do_action('eaw_before_add_to_cart_button');
                echo sprintf(
                    '<button type="button" class="eaw-product-bt-atc eaw-sb-product-bt-atc eaw-product-bt-select eaw-product-bt-not-atc button">%s</button>',
                    wp_kses_post(self::product_get_bt_atc_html($this->settings, $this->language))
                );
                do_action('eaw_after_add_to_cart_button');
                break;
            default:
                echo sprintf(
                    '<button class="eaw-product-bt-atc eaw-sb-product-bt-atc eaw-product-bt-select eaw-product-bt-not-atc button">%s</button>',
                    wp_kses_post(self::product_get_bt_atc_html($this->settings, $this->language))
                );
        }
    }

    public function simpleProductATC($product, $template, $settings)
    {
        $product_id = absint($product->get_id());
        ?>
		<form class="eaw-sb-cart-form"
			action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>"
			method="post" enctype="multipart/form-data"
			data-product_sku="<?php echo esc_attr(sanitize_text_field($product->get_sku())); ?>"
			data-product_name="<?php echo esc_attr(sanitize_text_field($product->get_name())); ?>"
			data-product_price="<?php echo esc_attr(sanitize_text_field($product->get_price())); ?>"
			data-product_id="<?php echo esc_attr($product_id); ?>">
			<?php
            do_action('eaw_before_add_to_cart_button');
        self::product_get_quantity($product, $settings->getParams('sbShowQuantity'));
        if (in_array($template, [1, 3])) {
            ?>
				<div class="eaw-sb-product-price-wrap"><span
						class="price"><?php echo wp_kses($product->get_price_html(), AppSettings::extendPostAllowedHtml()); ?></span>
				</div><?php
        }
        ?>
			<button type="submit" class="eaw-product-bt-atc eaw-sb-product-bt-atc button">
				<?php echo wp_kses_post(self::product_get_bt_atc_html($settings, $this->language)); ?>
			</button>
			<input type="hidden" name="add-to-cart" class="eaw-add-to-cart"
				value="<?php echo esc_attr($product_id); ?>" />
			<input type="hidden" name="product_id" class="eaw-product_id"
				value="<?php echo esc_attr($product_id); ?>" />
			<?php do_action('eaw_after_add_to_cart_button'); ?>
		</form>
	<?php
    }

    public function variableProductATC($product, $template, $settings)
    {
        $attributes = $product->get_variation_attributes();
        if (empty($attributes)) {
            echo sprintf(
                '<button type="button" class="eaw-product-bt-atc eaw-sb-product-bt-atc eaw-product-bt-select eaw-product-bt-not-atc button">%s</button>',
                wp_kses_post(self::product_get_bt_atc_html($this->settings, $this->language))
            );

            return;
        }
        $variation_count     = count($product->get_children());
        $get_variations      = $variation_count <= apply_filters('woocommerce_ajax_variation_threshold', 30, $product);
        $selected_attributes = $product->get_default_attributes();
        if ($get_variations) {
            $available_variations = $product->get_available_variations();
            if (empty($available_variations)) {
                echo sprintf(
                    '<button type="button" class="eaw-product-bt-atc eaw-sb-product-bt-atc eaw-product-bt-select eaw-product-bt-not-atc button">%s</button>',
                    wp_kses_post(self::product_get_bt_atc_html($this->settings, $this->language))
                );

                return;
            }
            $variations_json = wp_json_encode($available_variations);
            $variations_attr = function_exists('wc_esc_json') ? wc_esc_json($variations_json) : _wp_specialchars($variations_json, ENT_QUOTES, 'UTF-8', true);
        } else {
            $variations_attr = false;
        }
        $product_id   = absint($product->get_id());
        $product_name = sanitize_text_field($product->get_name());
        ?>
		<form class="eaw-sb-cart-form eaw-sb-cart-swatches eaw-cart-swatches-wrap variations_form"
			action="<?php echo esc_url(apply_filters('woocommerce_add_to_cart_form_action', $product->get_permalink())); ?>"
			method="post" enctype="multipart/form-data"
			data-product_id="<?php echo esc_attr($product_id); ?>"
			data-product_name="<?php echo esc_attr($product_name); ?>"
			data-variation_count="<?php echo esc_attr(absint($variation_count)); ?>"
			data-product_variations="<?php echo esc_attr($variations_attr); ?>">
			<div class="eaw-sb-swatches-wrap-wrap eaw-swatches-wrap-wrap">
				<?php
                    foreach ($attributes as $attribute_name => $options) {
                        $attribute_name = sanitize_text_field($attribute_name);
                        $selected       = isset($selected_attributes[$attribute_name]) ? sanitize_text_field($selected_attributes[$attribute_name]) : sanitize_text_field($product->get_variation_default_attribute($attribute_name));
                        echo sprintf('<div class="eaw-sb-swatches-wrap eaw-swatches-wrap"><div class="eaw-sb-swatches-value eaw-swatches-value value">');
                        wc_dropdown_variation_attribute_options(apply_filters('eaw_dropdown_variation_attribute_options', [
                            'options'                 => $options,
                            'attribute'               => $attribute_name,
                            'product'                 => $product,
                            'selected'                => $selected,
                            'id'                      => sanitize_title($attribute_name) . '_' . absint(current_time('timestamp')),
                            'class'                   => 'eaw-attribute-options eaw-sb-attribute-options',
                            'eaw_swatches_disable'    => ! $this->settings->getParams('sbShowSwatches')
                        ], $attribute_name, $product));
                        echo sprintf('</div></div>');
                    }
        ?>
			</div>
			<?php
            do_action('eaw_before_add_to_cart_button');
        self::product_get_quantity($product, $settings->getParams('sbShowQuantity'));
        if (in_array($template, [1, 3])) {
            ?>
				<div class="eaw-sb-product-price-wrap"><span
						class="price"><?php echo wp_kses($product->get_price_html(), AppSettings::extendPostAllowedHtml()); ?></span>
				</div><?php
        }
        ?>
			<button type="submit" class="eaw-product-bt-atc eaw-sb-product-bt-atc button">
				<?php echo wp_kses_post(self::product_get_bt_atc_html($settings, $this->language)); ?>
			</button>
			<input type="hidden" name="add-to-cart" class="eaw-add-to-cart"
				value="<?php echo esc_attr($product_id); ?>" />
			<input type="hidden" name="product_id" class="eaw-product_id"
				value="<?php echo esc_attr($product_id); ?>" />
			<input type="hidden" name="variation_id" class="variation_id" value="0" />
			<?php do_action('eaw_after_add_to_cart_button'); ?>
		</form>
	<?php
    }

    public function externalProductATC($product, $template, $settings)
    {
        ?>
		<form class="eaw-sb-cart-form" action="<?php echo esc_attr(esc_url($product->add_to_cart_url())); ?>"
			method="get">
			<?php do_action('eaw_before_add_to_cart_button'); ?>
			<button type="submit"
				class="eaw-product-bt-atc eaw-sb-product-bt-atc eaw-product-bt-external eaw-product-bt-not-atc button">
				<?php echo wp_kses_post(self::product_get_bt_atc_html($settings, $this->language)); ?>
			</button>
			<?php do_action('eaw_after_add_to_cart_button'); ?>
		</form>
		<?php
    }

    public function groupedProductATC($product, $template, $settings)
    {
        do_action('eaw_before_add_to_cart_button');
        echo sprintf(
            '<button type="button" class="eaw-product-bt-atc eaw-sb-product-bt-atc eaw-product-bt-select eaw-product-bt-not-atc button">%s</button>',
            wp_kses_post(self::product_get_bt_atc_html($this->settings, $this->language))
        );
        do_action('eaw_after_add_to_cart_button');
    }

    public static function product_get_bt_atc_html($settings, $language)
    {
        if (! $settings) {
            return '';
        }
        $html            = $settings->getParams('sbAtcTitle', $language);
        $cart_icon_class = $settings->getClassIcon($settings->getParams('sbAtcIcon'), 'cart_icons_atc') ?: '';
        $cart_icon_class = esc_attr($cart_icon_class);
        $html            = str_replace('{cart_icon}', '<i class="eaw-sb-bt-atc-cart_icons ' . $cart_icon_class . '"></i>', $html);

        return $html;
    }

    public static function product_get_quantity($product, $enable = false)
    {
        if (! $product) {
            return;
        }
        if (! $enable && ! is_customize_preview()) {
            echo wp_kses_post(
                apply_filters(
                    'eaw_sticky_bar_qty',
                    sprintf('<input type="hidden" name="quantity" value="1" />'),
                    $product,
                    []
                )
            );


            return;
        }
        if ($product->is_sold_individually()) {
            echo wp_kses_post(
                apply_filters(
                    'eaw_sticky_bar_qty',
                    sprintf('<input type="hidden" name="quantity" value="1" />'),
                    $product,
                    []
                )
            );

        } else {
            $quantity_args = apply_filters('eaw_quantity_input_args', [
                'input_name'   => "quantity",
                'input_value'  => 1,
                'max_value'    => $product->get_max_purchase_quantity(),
                'min_value'    => '0',
                'classes'      => ['eaw-sb-product-qty'],
                'product_name' => $product->get_name()
            ], $product);
            echo wp_kses_post(apply_filters('eaw_sticky_bar_qty', self::product_get_quantity_html($quantity_args), $product, $quantity_args));
        }
    }

    public static function product_get_quantity_html($args = [])
    {
        if (empty($args)) {
            return '';
        }

        // Sanitize all extracted values
        $input_id    = isset($args['input_id']) ? sanitize_key($args['input_id']) : '';
        $input_name  = isset($args['input_name']) ? sanitize_key($args['input_name']) : '';
        $input_value = isset($args['input_value']) ? absint($args['input_value']) : 1;
        $max_value   = isset($args['max_value']) ? absint($args['max_value']) : '';
        $min_value   = isset($args['min_value']) ? absint($args['min_value']) : 0;
        $classes     = isset($args['classes']) && is_array($args['classes']) ? array_map('sanitize_html_class', $args['classes']) : [];
        $step        = isset($args['step']) ? absint($args['step']) : 1;
        $placeholder = isset($args['placeholder']) ? sanitize_text_field($args['placeholder']) : '';
        $inputmode   = isset($args['inputmode']) ? sanitize_text_field($args['inputmode']) : '';

        ob_start();
        if ($max_value && $min_value === $max_value) {
            ?>
			<input type="hidden" id="<?php echo esc_attr($input_id); ?>" name="<?php echo esc_attr($input_name); ?>"
				value="<?php echo esc_attr($min_value); ?>">
<?php
        } else {
            ccpeaw_get_template('quantity/eaw-quantity', ['type' => 'text', 'readonly' => true, 'input_id' => $input_id, 'classes' => $classes, 'input_name' => $input_name, 'input_value' => $input_value, 'min_value' => $min_value, 'max_value' => $max_value, 'step' => $step, 'placeholder' => $placeholder, 'inputmode' => $inputmode, 'autocomplete' => 'on'], 'input');
        }
        $html = ob_get_clean();

        return $html;
    }
}
