<?php

namespace CodeConfig\EAW\App\CartManager;

use CodeConfig\EAW\AppSettings;
use CodeConfig\EAW\Utils\Singleton;

defined('ABSPATH') || exit('No direct script access allowed');

class SidebarCartIcon
{
    use Singleton;
    protected $settings;
    protected $use_img;
    protected $is_customize;
    protected $customize_data;
    public function doHooks()
    {

        $this->settings = AppSettings::getInstance();
        add_action('wp_enqueue_scripts', [$this, 'eaw_wp_enqueue_scripts'], 99);
        add_action('eaw_get_sidebar_cart_icon', [$this, 'get_sidebar_cart_icon']);
    }
    public function eaw_wp_enqueue_scripts()
    {
        if (! isset(WC()->cart)) {
            return;
        }
        $this->is_customize = is_customize_preview();
        if (! $this->is_customize && ! $this->assign_page()) {
            return;
        } else {
            global $wp_customize;
            $this->customize_data = $wp_customize;
        }

        $this->use_img = $this->getParams('scIconUseImg');
        wp_enqueue_style('eaw-cart-icons', CCPEAW_ASSETS . '/css/frontend/' . 'cart-icons.min.css', [], CCPEAW_VERSION);
        wp_enqueue_style('eaw-sidebar-cart-icon', CCPEAW_ASSETS . '/css/frontend/' . 'sidebar-cart-icon.css', [], CCPEAW_VERSION);
        if (! $this->is_customize) {
            $css = $this->get_inline_css();
            wp_add_inline_style('eaw-sidebar-cart-icon', $css);
        }
        add_action('wp_footer', [$this, 'frontend_html']);
    }
    public function frontend_html()
    {
        $class           = [
            'eaw-sidebar-cart-icon-wrap',
            'eaw-sidebar-cart-icon-wrap-' . $scIconPosition = $this->getParams('scIconPosition'),
            'eaw-sidebar-cart-icon-wrap-' . $scTriggerType  = $this->getParams('scTriggerType'),
        ];
        $scEmptyEnable = $this->settings->getParams('scEmptyEnable');
        if (! $this->is_customize) {
            $class[] = ! $scEmptyEnable && WC()->cart->is_empty() ? 'eaw-disabled' : '';
        } elseif (! $this->getParams('scEnable') || ! $this->getParams('scIconEnable')) {
            $class[] = 'eaw-disabled';
        }
        $class[] = 'eaw-disabled';
        $class   = trim(implode(' ', $class));
        ?>
		<div class="<?php echo esc_attr($class); ?>"
			data-old_position="" data-position="<?php echo esc_attr($scIconPosition); ?>"
			data-trigger="<?php echo esc_attr($scTriggerType); ?>">
			<?php
                    do_action('eaw_get_sidebar_cart_icon');
        ?>
		</div>
		<?php
    }

    public function get_sidebar_cart_icon()
    {
        if ($this->use_img === true || $this->use_img === '1') {
            return;
        }
    }
    public function get_inline_css()
    {
        $css           = '';
        $frontend      = Frontend::getInstance();
        $scHorizontal  = $this->settings->getParams('scIconHorizontal') ?: 0;
        $css           .= '.eaw-sidebar-cart-icon-wrap-top_left, .eaw-sidebar-cart-icon-wrap-bottom_left{';
        $css           .= 'left: ' . $scHorizontal . 'px ;';
        $css           .= '}';
        $css           .= '.eaw-sidebar-cart-icon-wrap-top_right, .eaw-sidebar-cart-icon-wrap-bottom_right{';
        $css           .= 'right: ' . $scHorizontal . 'px ;';
        $css           .= '}';
        $scVertical   = $this->settings->getParams('scIconVertical') ?: 0;
        $css           .= '.eaw-sidebar-cart-icon-wrap-top_left, .eaw-sidebar-cart-icon-wrap-top_right{';
        $css           .= 'top: ' . $scVertical . 'px ;';
        $css           .= '}';
        $css           .= '.eaw-sidebar-cart-icon-wrap-bottom_right, .eaw-sidebar-cart-icon-wrap-bottom_left{';
        $css           .= 'bottom: ' . $scVertical . 'px ;';
        $css           .= '}';
        if ($this->settings->getParams('scIconBoxShadow')) {
            $css .= '.eaw-sidebar-cart-icon-wrap{
                box-shadow: inset 0 0 2px rgba(0,0,0,0.03), 0 4px 10px rgba(0,0,0,0.17);
            }';
        }
        if ($scIconScale = $this->settings->getParams('scIconScale')) {
            $css .= '.eaw-sidebar-cart-icon-wrap {
                transform: scale(' . $scIconScale . ') ;
            }
            @keyframes eaw-cart-icon-slide_in_left {
                from {
                    transform: translate3d(-100%, 0, 0) scale(' . $scIconScale . ');
                    visibility: hidden;
                }
                to {
                    transform: translate3d(0, 0, 0) scale(' . $scIconScale . ');
                }
            }
            @keyframes eaw-cart-icon-slide_out_left {
                from {
                    transform: translate3d(0, 0, 0) scale(' . $scIconScale . ');
                    visibility: visible;
                    opacity: 1;
                }
                to {
                    transform: translate3d(-100%, 0, 0) scale(' . $scIconScale . ');
                    visibility: hidden;
                    opacity: 0;
                }
            }
            @keyframes eaw-cart-icon-shake_horizontal {
               0% {
		            transform: scale(' . $scIconScale . ');
	            }
	           10%, 20% {
		            transform: scale(' . $scIconScale . ') translateX(-10%);
	           }
	           30%, 50%, 70%, 90% {
		            transform: scale(' . $scIconScale . ') translateX(10%);
	           }
	           40%, 60%, 80% {
		            transform: scale(' . $scIconScale . ') translateX(-10%);
	           }
            	100% {
            		transform: scale(' . $scIconScale . ');
            	}
            }
            @keyframes eaw-cart-icon-shake_vertical {
               0% {
		            transform: scale(' . $scIconScale . ');
	            }
	           10%, 20% {
	                transform: scale(' . ($scIconScale * 0.9) . ') rotate3d(0, 0, 1, -3deg);
	           }
	           30%, 50%, 70%, 90% {
		            transform: scale(' . ($scIconScale * 1.1) . ') rotate3d(0, 0, 1, 3deg);
	           }
	           40%, 60%, 80% {
		            transform: scale(' . ($scIconScale * 1.1) . ') rotate3d(0, 0, 1, -3deg);
	           }
            	100% {
            		transform: scale(' . $scIconScale . ');
            	}
            }';
        }
        if ($scIconHoverScale = $this->settings->getParams('scIconHoverScale')) {
            $css .= '@keyframes eaw-cart-icon-mouseenter {
                from {
                    transform: translate3d(0, 0, 0) scale(' . $scIconScale . ');
                }
                to {
                    transform: translate3d(0, 0, 0) scale(' . $scIconHoverScale . ');
                }
            }
            @keyframes eaw-cart-icon-mouseleave {
                from {
                    transform: translate3d(0, 0, 0) scale(' . $scIconHoverScale . ');
                }
                to {
                    transform: translate3d(0, 0, 0) scale(' . $scIconScale . ');
                }
            }
            @keyframes eaw-cart-icon-slide_out_left {
                from {
                    transform: translate3d(0, 0, 0) scale(' . $scIconHoverScale . ');
                    visibility: visible;
                    opacity: 1;
                }
                to {
                    transform: translate3d(-100%, 0, 0) scale(' . $scIconHoverScale . ');
                    visibility: hidden;
                    opacity: 0;
                }
            }
            @keyframes eaw-cart-icon-slide_out_right {
                from {
                    transform: translate3d(0, 0, 0) scale(' . $scIconHoverScale . ');
                    visibility: visible;
                    opacity: 1;
                }
                to {
                    transform: translate3d(100%, 0, 0) scale(' . $scIconHoverScale . ');
                    visibility: hidden;
                    opacity: 0;
                }
            }';
        }
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart-icon-wrap'],
            ['scIconBorderRadius', 'scIconBgColor'],
            ['border-radius', 'background'],
            ['px', '']
        );
        if ($this->use_img) {
            $css .= '.eaw-sidebar-cart-icon-image{background-image: url(' . $this->settings->getParams('scIconImg') . ');}';
        } else {
            $css .= $frontend::add_inline_style(
                ['.eaw-sidebar-cart-icon-wrap .eaw-sidebar-cart-icon i'],
                ['scIconColor'],
                ['color'],
                ['']
            );
        }
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart-icon-wrap .eaw-sidebar-cart-count-wrap'],
            ['scIconCountBgColor', 'scIconCountColor', 'scIconCountBorderRadius'],
            ['background', 'color', 'border-radius'],
            ['', '', 'px']
        );
        if ($this->settings->getParams('scIconCountType') === 'cart_subtotal') {
            $css .= $frontend::add_inline_style(
                ['.eaw-sidebar-cart-icon-wrap .eaw-sidebar-cart-count-wrap .amount'],
                ['scIconCountColor'],
                ['color'],
                ['']
            );
        }
        $css = str_replace(["\r", "\n", "\t", '\r', '\n', '\t'], ' ', $css);

        return $css;
    }

    private function getParams($name = '')
    {
        if ($this->customize_data && $name && $setting = $this->customize_data->get_setting('ccpeaw_settings[' . $name . ']')) {
            return $this->customize_data->post_value($setting, $this->settings->getParams($name));
        } else {
            return $this->settings->getParams($name);
        }
    }
}
