<?php

namespace CodeConfig\EAW\App\CartManager;

use CodeConfig\EAW\AppSettings;
use CodeConfig\EAW\Utils\Helpers;
use CodeConfig\EAW\Utils\Singleton;

defined('ABSPATH') || exit('No direct script access allowed');

class SidebarCartContent
{
    use Singleton;
    public static $settings;
    public static $sc_checkout;
    public static $cache;
    public $is_customize;
    public $customize_data;
    protected static $instance = null;

    public function doHooks()
    {
        self::$settings    = AppSettings::getInstance();
        self::$sc_checkout = self::$settings->getParams('scCheckOutEnable');

        add_action('wp_enqueue_scripts', [$this, 'enqueueScripts']);

        if (self::$sc_checkout) {
            if (class_exists('CurieRO_City_Select')) {
                add_action('wp_enqueue_scripts', [$this, 'add_filter_is_checkout'], PHP_INT_MAX);
                add_action('curiero_addon_methods_loaded', function () {
                    add_action('wp_enqueue_scripts', [$this, 'remove_filter_is_checkout'], PHP_INT_MAX);
                }, PHP_INT_MAX);
            }
            if (class_exists('Coderockz_Woo_Delivery_Public')) {
                add_action('wp_enqueue_scripts', [$this, 'add_filter_is_checkout'], -1);
                add_action('wp_enqueue_scripts', [$this, 'remove_filter_is_checkout'], 1);
                add_action('wp_enqueue_scripts', [$this, 'add_filter_is_checkout'], 9);
            }
            add_action('template_redirect', [$this, 'init_payment_gateways']);
            add_action('wp_enqueue_scripts', [$this, 'remove_filter_is_checkout'], 11);

            if (class_exists('WC_City_Select')) {
                add_action('wp_enqueue_scripts', [$this, 'add_filter_is_checkout'], 9);
                add_action('wp_enqueue_scripts', [$this, 'remove_filter_is_checkout'], 11);
            }
            if (
                is_plugin_active('flexible-checkout-fields/flexible-checkout-fields.php')
                || is_plugin_active('flexible-checkout-fields-pro/flexible-checkout-fields-pro.php')
                || is_plugin_active('woocommerce-payments/woocommerce-payments.php')
                || is_plugin_active('woocommerce-gateway-stripe/woocommerce-gateway-stripe.php')
            ) {
                add_action('wp_footer', [$this, 'add_filter_is_checkout'], 9);
                add_action('wp_footer', [$this, 'remove_filter_is_checkout'], 11);
            }
            if (is_plugin_active('woo-stripe-payment/stripe-payments.php')) {
                add_action('wp_print_footer_scripts', [$this, 'add_filter_is_checkout'], 5);
                add_action('wp_print_footer_scripts', [$this, 'remove_filter_is_checkout'], 7);
            }
            if (is_plugin_active('pymntpl-paypal-woocommerce/pymntpl-paypal-woocommerce.php')) {
                add_action('wp', [$this, 'add_filter_is_checkout'], 9);
                add_action('wp', [$this, 'remove_filter_is_checkout'], 11);
            }
            if (is_plugin_active('woocommerce-smart-coupons/woocommerce-smart-coupons.php')) {
                add_filter('woocommerce_queued_js', function ($js) {
                    $a  = ", function(){}";
                    $js = str_replace([', wc_sc_apply_coupon_js', ',wc_sc_apply_coupon_js'], [$a, $a], $js);

                    return $js;
                }, 10, 1);
            }
            add_filter('eaw_get_filter_is_checkout', [$this, 'eaw_get_filter_is_checkout'], 10, 1);
            add_filter('woocommerce_paypal_payments_product_supports_payment_request_button', '__return_false');
            add_action('wp_footer', [$this, 'refresh_inject'], 19);
        }
    }

    public function eaw_get_filter_is_checkout($filters)
    {
        if (class_exists('VIWCUF_CHECKOUT_UPSELL_FUNNEL')) {
            $funnel_settings = new \VIWCUF_CHECKOUT_UPSELL_FUNNEL_Data();
            if (! $funnel_settings->getParams('ob_vicaio_enable')) {
                $filters['viwcuf_ob_enable'] = 'eaw_is_not_checkout';
            }
            if (! $funnel_settings->getParams('us_vicaio_enable')) {
                $filters['viwcuf_us_enable'] = 'eaw_is_not_checkout';
            }
        }

        return $filters;
    }

    public function add_filter_is_checkout()
    {
        if (is_admin()) {
            return;
        }

        if (! $this->sidebar_checkout_assign_page()) {
            return;
        }
    }

    public function remove_filter_is_checkout()
    {
        if (! $this->sidebar_checkout_assign_page()) {
            return;
        }
    }

    public function init_payment_gateways()
    {
        if (! $this->sidebar_checkout_assign_page()) {
            return;
        }
        remove_action('wp_enqueue_scripts', 'shoptimizer_minimal_checkout', 10);
        // Ensure gateways and shipping methods are loaded early.
        WC()->payment_gateways();
        WC()->shipping();
    }

    public function enqueueScripts()
    {
        $this->is_customize = self::is_customize_preview();
        if (! $this->is_customize && ! $this->assign_page()) {
            return;
        }
        if (class_exists('\Elementor\Plugin') && \Elementor\Plugin::$instance->preview->is_preview_mode()) {
            return;
        }
        if ($this->is_customize) {
            global $wp_customize;
            $this->customize_data = $wp_customize;
        }

        $scFootMsg         = self::$settings->getParams('scFootMsg');
        $has_product_plus  = strpos($scFootMsg, '{product_plus}');
        wp_enqueue_style('eaw-loading', CCPEAW_ASSETS . '/css/frontend/' . 'loading.min.css', [], CCPEAW_VERSION);

        wp_enqueue_style('eaw-sidebar-cart-content', CCPEAW_ASSETS . '/css/frontend/' . 'sidebar-cart-content.css', [], CCPEAW_VERSION);
        wp_enqueue_script('eaw-sidebar-cart', CCPEAW_ASSETS . '/js/' . 'sidebar-cart.js', ['jquery'], CCPEAW_VERSION);
        wp_enqueue_style('eaw-cart-icons', CCPEAW_ASSETS . '/css/frontend/' . 'cart-icons.min.css', [], CCPEAW_VERSION);
        if (($has_product_plus !== false) || $this->is_customize) {
            wp_enqueue_style('eaw-atc-cart-icons', CCPEAW_ASSETS . '/css/frontend/' . 'cart-icons-atc.min.css', [], CCPEAW_VERSION);
            wp_enqueue_style('eaw-nav-icons', CCPEAW_ASSETS . '/css/frontend/' . 'nav-icons.min.css', [], CCPEAW_VERSION);
            wp_enqueue_style('eaw-flexslider', CCPEAW_ASSETS . '/css/frontend/' . 'sc-flexslider.min.css', [], CCPEAW_VERSION);
            wp_enqueue_script('eaw-flexslider', CCPEAW_ASSETS . '/js/' . 'flexslider.min.js', ['jquery'], CCPEAW_VERSION);
        }
        if ($this->sidebar_checkout_assign_page() || $this->is_customize) {
            wp_enqueue_style('eaw-back-icons', CCPEAW_ASSETS . '/css/frontend/' . 'back-icons.css', [], CCPEAW_VERSION);
            if (
                wp_style_is('woocommerce-general', 'registered') &&
                !in_array(wp_get_theme()->get_stylesheet(), ['flatsome', 'flatsome-child'])
            ) {
                wp_enqueue_style(
                    'eaw-sc-checkout',
                    CCPEAW_ASSETS . '/css/frontend/' . 'sc-checkout.css',
                    ['select2', 'woocommerce-general'],
                    CCPEAW_VERSION
                );
            } else {
                wp_enqueue_style('eaw-sc-checkout', CCPEAW_ASSETS . '/css/frontend/' . 'sc-checkout.css', ['select2'], CCPEAW_VERSION);
            }
            if (!class_exists('CurieRO_City_Select')) {
                wp_enqueue_script('eaw-selectWoo', CCPEAW_ASSETS . '/js/' . 'vi-selectWoo.js', ['jquery'], CCPEAW_VERSION);
            }
            wp_enqueue_script(
                'eaw-sc-checkout',
                CCPEAW_ASSETS . '/js/' . 'sc-checkout.js',
                ['jquery', 'wc-checkout'],
                CCPEAW_VERSION,
                true
            );
            $checkout_args = [
                'nonce'                     => wp_create_nonce('ccpeaw'),
                'invalid_text'              => apply_filters(
                    'eaw-invalid_text',
                    esc_html__('Please insert all required information to checkout.', 'essential-addons-for-woocommerce')
                ),
                'unavailable_checkout_text' => apply_filters(
                    'eaw-unavailable_checkout_text',
                    esc_html__('Checkout is not available whilst your cart is empty.', 'essential-addons-for-woocommerce')
                )
            ];

            wp_localize_script('eaw-sc-checkout', 'eaw_sc_checkout_params', $checkout_args);
            wp_add_inline_style('eaw-sc-checkout', '#ppc-button, .ppc-button-wrapper{display: none ;}');
        }
        if (! $this->is_customize) {
            $args = [
                'wc_ajax_url'                      => \WC_AJAX::get_endpoint("%%endpoint%%"),
                'nonce'                            => wp_create_nonce('ccpeaw'),
                'language'                         => self::get_language(),
                'scContentClassOpen'               => self::$settings->getParams('scContentClassOpen') ?: '',
                'update_cart_when_changing_pd_qty' => self::$settings->getParams('scPdUpdateCart') ?: '',
                'added_to_cart'                    => did_action('woocommerce_add_to_cart') ?: '',
                'auto_close_sidebar'               => self::$settings->getParams('scAutoClose') ?: '',
                'cart_hash_key'                    => apply_filters(
                    'woocommerce_cart_hash_key',
                    'wc_cart_hash_' . md5(get_current_blog_id() . '_' . get_site_url(get_current_blog_id(), '/') . get_template())
                ),
                'fragment_name'                    => apply_filters(
                    'woocommerce_cart_fragment_name',
                    'wc_fragments_' . md5(get_current_blog_id() . '_' . get_site_url(get_current_blog_id(), '/') . get_template())
                ),
            ];
            wp_localize_script('eaw-sidebar-cart', 'eaw_sc_params', $args);
            $css = $this->get_inline_css();
            wp_add_inline_style('eaw-sidebar-cart-content', $css);
            if ($has_product_plus !== false) {
                wp_enqueue_script('eaw-ajax-atc', CCPEAW_ASSETS . '/js/' . 'ajax-add-to-cart.js', ['jquery'], CCPEAW_VERSION);
                $args1 = [
                    'isAjaxAtcEnabled'                    => self::$settings->getParams('enableAjaxATC') ?: '',
                    'wc_ajax_url'                         => \WC_AJAX::get_endpoint("%%endpoint%%"),
                    'nonce'                               => wp_create_nonce('ccpeaw'),
                    'woocommerce_enable_ajax_add_to_cart' => 'yes' === get_option('woocommerce_enable_ajax_add_to_cart') ? 1 : '',
                    'added_to_cart'                       => did_action('woocommerce_add_to_cart') ?: '',
                    'ajax_atc_pd_exclude'                 => self::$settings->getParams('ajax_atc_pd_exclude') ?: [],
                    'i18n_make_a_selection_text'          => apply_filters(
                        'eaw-i18n_make_a_selection_text',
                        esc_html__('Please select some product options before adding this product to your cart.', 'essential-addons-for-woocommerce')
                    ),
                    'i18n_unavailable_text'               => apply_filters(
                        'eaw-i18n_unavailable_text',
                        esc_html__('Sorry, this product is unavailable. Please choose a different combination.', 'essential-addons-for-woocommerce')
                    ),
                    'cart_url'                            => apply_filters('woocommerce_add_to_cart_redirect', wc_get_cart_url(), null),
                    'cart_redirect_after_add'             => get_option('woocommerce_cart_redirect_after_add'),
                ];
                wp_localize_script('eaw-ajax-atc', 'eawAtcVars', $args1);
            }
        }
        add_action('wp_footer', [$this, 'frontend_html'], 9);
    }
    public function frontend_html()
    {
        wc_get_template(
            'sidebar-cart.php',
            ['sidebar_cart' => $this],
            'essential-addons-for-woocommerce' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR . 'sidebar-cart' . DIRECTORY_SEPARATOR,
            CCPEAW_TEMPLATES . 'atc/' . 'sidebar-cart' . DIRECTORY_SEPARATOR
        );
        if ($this->sidebar_checkout_assign_page() && !$this->is_customize && WC()->cart && WC()->cart->is_empty()) {
            if (!isset(self::$cache['sc_checkout_injects'])) {
                self::$cache['sc_checkout_injects'] = [];
            }
            if (!isset(self::$cache['sc_checkout_refreshes'])) {
                self::$cache['sc_checkout_refreshes'] = ['wc-checkout'];
            }
            $inject    = self::$cache['sc_checkout_injects'];
            $refreshes = self::$cache['sc_checkout_refreshes'];
            if (
                class_exists('THWCFE_Public_Checkout')                                                      ||
                is_plugin_active('coderockz-woocommerce-delivery-date-time-pro/coderockz-woo-delivery.php') ||
                is_plugin_active('mollie-payments-for-woocommerce/mollie-payments-for-woocommerce.php')
            ) {
                $refreshes += ['thwcfe-public-checkout-script', 'coderockz-woo-delivery'];
                if (is_plugin_active('mollie-payments-for-woocommerce/mollie-payments-for-woocommerce.php')) {
                    global $wp_scripts;
                    $isBillieEnabled = mollieWooCommerceIsGatewayEnabled('mollie_wc_gateway_billie_settings', 'enabled');
                    if ($isBillieEnabled) {
                        $tmp = (array) ($wp_scripts->registered)['mollie-billie-classic-handles'];
                        if (!empty($tmp['deps'])) {
                            foreach ($tmp['deps'] as $item) {
                                wp_enqueue_script($item);
                            }
                        }
                        $inject['mollie-billie-classic-handles'] = $tmp;
                        wp_dequeue_script('mollie-billie-classic-handles');
                    }
                    $isIn3Enabled = mollieWooCommerceIsGatewayEnabled('mollie_wc_gateway_in3_settings', 'enabled');
                    if ($isIn3Enabled) {
                        $tmp = (array) ($wp_scripts->registered)['mollie-in3-classic-handles'];
                        if (!empty($tmp['deps'])) {
                            foreach ($tmp['deps'] as $item) {
                                wp_enqueue_script($item);
                            }
                        }
                        $inject['mollie-in3-classic-handles'] = $tmp;
                        wp_dequeue_script('mollie-in3-classic-handles');
                    }
                }
                if (is_plugin_active('coderockz-woocommerce-delivery-date-time-pro/coderockz-woo-delivery.php')) {
                    global $wp_scripts;
                    $tmp = (array) ($wp_scripts->registered)['coderockz-woo-delivery'];
                    if (!empty($tmp['deps'])) {
                        foreach ($tmp['deps'] as $item) {
                            wp_enqueue_script($item);
                        }
                    }
                    $inject['coderockz-woo-delivery'] = $tmp;
                    wp_dequeue_script('coderockz-woo-delivery');
                }
            }

            self::$cache['sc_checkout_injects']   = $inject;
            self::$cache['sc_checkout_refreshes'] = $refreshes;
        }
    }
    public function refresh_inject()
    {
        if (!$this->sidebar_checkout_assign_page() || $this->is_customize  || !WC()->cart || !WC()->cart->is_empty()) {
            return;
        }
        if (!isset(self::$cache['sc_checkout_injects'])) {
            self::$cache['sc_checkout_injects'] = [];
        }
        if (!isset(self::$cache['sc_checkout_refreshes'])) {
            self::$cache['sc_checkout_refreshes'] = ['wc-checkout'];
        }
        $inject    = self::$cache['sc_checkout_injects'];
        $refreshes = self::$cache['sc_checkout_refreshes'];
        global $wp_scripts;
        $scripts = (array) ($wp_scripts->registered);
        if (is_plugin_active('woocommerce-gateway-stripe/woocommerce-gateway-stripe.php')) {
            //		    $refreshes[] = 'stripe';
            $need_injects = ['wc-stripe-upe-classic', 'woocommerce_stripe'];
            foreach ($need_injects as $key) {
                if (!empty($scripts[$key])) {
                    $tmp = (array) $scripts[$key];
                    if (! empty($tmp['deps'])) {
                        foreach ($tmp['deps'] as $item) {
                            if (! in_array($item, $inject)) {
                                wp_enqueue_script($item);
                            }
                        }
                    }
                    $inject[$key] = $tmp;
                    wp_dequeue_script($key);
                }
            }
        }
        wp_localize_script('eaw-sc-checkout', 'eaw_sc_checkout_js', [
            'injects'   => !empty($inject) ? $inject : '',
            'refreshes' => !empty($refreshes) ? $refreshes : '',
        ]);
    }
    public function wc_log($content, $source = 'debug', $level = 'info')
    {
        if (!$content) {
            return;
        }
        $log     = wc_get_logger();
        $log->log(
            $level,
            $content,
            [
                'source' => 'wcaio-' . $source,
            ]
        );
    }


    public function get_inline_css()
    {
        $css      = '';
        $frontend = Frontend::getInstance();
        if (self::$settings->enable('ScCheckout')) {
            $css .= $this->get_checkout_inline_css($frontend);
        }
        if ($scHorizontal = self::$settings->getParams('scHorizontal')) {
            $scHorizontal_mobile = $scHorizontal > 20 ? 20 - $scHorizontal : 0;
            $css                  .= '.eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-top_left,
            .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-bottom_left{
                left: ' . $scHorizontal . 'px ;
            }
            .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-top_right,
            .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-bottom_right{
                right: ' . $scHorizontal . 'px ;
            }
            @media screen and (max-width: 768px) {
                .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-top_left .eaw-sidebar-cart-content-wrap,
                .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-bottom_left .eaw-sidebar-cart-content-wrap{
                    left: ' . $scHorizontal_mobile . 'px ;
                }
                .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-top_right .eaw-sidebar-cart-content-wrap,
                .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-bottom_right .eaw-sidebar-cart-content-wrap{
                    right: ' . $scHorizontal_mobile . 'px ;
                }
            }
            ';
        }
        if ($scVertical = self::$settings->getParams('scVertical')) {
            $scVertical_mobile = $scVertical > 20 ? 20 - $scVertical : 0;
            $css                .= '.eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-top_left,
            .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-top_right{
                top: ' . $scVertical . 'px ;
            }
            .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-bottom_right,
            .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-bottom_left{
                bottom: ' . $scVertical . 'px ;
            }
            @media screen and (max-width: 768px) {
                .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-top_left .eaw-sidebar-cart-content-wrap,
                .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-top_right .eaw-sidebar-cart-content-wrap{
                    top: ' . $scVertical_mobile . 'px ;
                }
                .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-bottom_right .eaw-sidebar-cart-content-wrap,
                .eaw-sidebar-cart.eaw-sidebar-cart-1.eaw-sidebar-cart-bottom_left .eaw-sidebar-cart-content-wrap{
                    bottom: ' . $scVertical_mobile . 'px ;
                }
            }';
        }
        if ($scLoadingColor = self::$settings->getParams('scLoadingColor')) {
            $css .= '.eaw-sidebar-cart .eaw-sidebar-cart-loading-dual_ring:after {
                border-color: ' . $scLoadingColor . '  transparent ' . $scLoadingColor . '  transparent;
            }
            .eaw-sidebar-cart .eaw-sidebar-cart-loading-ring div{
                border-color: ' . $scLoadingColor . '  transparent transparent transparent;
            }
            .eaw-sidebar-cart .eaw-sidebar-cart-loading-ripple  div{
                border: 4px solid ' . $scLoadingColor . ' ;
            }
            .eaw-sidebar-cart .eaw-sidebar-cart-loading-default div,
            .eaw-sidebar-cart .eaw-sidebar-cart-loading-animation_face_1 div,
            .eaw-sidebar-cart .eaw-sidebar-cart-loading-animation_face_2 div,
            .eaw-sidebar-cart .eaw-sidebar-cart-loading-roller div:after,
            .eaw-sidebar-cart .eaw-sidebar-cart-loading-loader_balls_1 div,
            .eaw-sidebar-cart .eaw-sidebar-cart-loading-loader_balls_2 div,
            .eaw-sidebar-cart .eaw-sidebar-cart-loading-loader_balls_3 div,
            .eaw-sidebar-cart .eaw-sidebar-cart-loading-spinner div:after{
                background: ' . $scLoadingColor . ' ;
            }';
        }
        if (self::$settings->getParams('scPdImgBoxShadow')) {
            $css .= '.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-img-wrap img{
                box-shadow: 0 4px 10px rgba(0,0,0,0.07);
            }';
        }
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-content-wrap'],
            ['scRadius'],
            ['border-radius'],
            ['px']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-header-wrap'],
            ['scHeaderBgColor', 'scHeaderBorderStyle', 'scHeaderBorderColor'],
            ['background', 'border-style', 'border-color'],
            ['', '', '']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-header-wrap .eaw-sidebar-cart-header-title-wrap'],
            ['scHeaderTitleColor'],
            ['color'],
            ['']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-header-wrap .eaw-sidebar-cart-header-coupon-wrap .eaw-coupon-code'],
            ['scHeaderCouponInputRadius'],
            ['border-radius'],
            ['px']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart .eaw-sidebar-cart-header-wrap .eaw-sidebar-cart-header-coupon-wrap button.eaw-bt-coupon-code',
                '.eaw-sidebar-cart .eaw-sidebar-cart-header-wrap .eaw-sidebar-cart-header-coupon-wrap .eaw-bt-coupon-code.button'
            ],
            ['scHeaderCouponBtnBgColor', 'scHeaderCouponBtnTextColor', 'scHeaderCouponButtonBorderRadius'],
            ['background', 'color', 'border-radius'],
            ['', '', 'px']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart .eaw-sidebar-cart-header-wrap .eaw-sidebar-cart-header-coupon-wrap button.eaw-bt-coupon-code:hover',
                '.eaw-sidebar-cart .eaw-sidebar-cart-header-wrap .eaw-sidebar-cart-header-coupon-wrap .eaw-bt-coupon-code.button:hover'
            ],
            ['scHeaderCouponBtnBgColorHover', 'scHeaderCouponBtnTextColorHover'],
            ['background', 'color'],
            ['', '']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap'],
            ['scFootBgColor', 'scFootBorderType', 'scFootBorderWidth'],
            ['background', 'border-style', 'border-color'],
            ['', '', '']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap .eaw-sidebar-cart-footer-cart_total > div:nth-child(1)'],
            ['scFootCartTotalColor'],
            ['color'],
            ['']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap .eaw-sidebar-cart-footer-cart_total > div:nth-child(2)'],
            ['scFootCartTotalColor1'],
            ['color'],
            ['']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap button.eaw-sidebar-cart-bt-nav',
                '.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap .eaw-sidebar-cart-bt-nav.button'
            ],
            ['scFootButtonBgColor', 'scFootButtonColor', 'scFootButtonBorderRadius'],
            ['background', 'color', 'border-radius'],
            ['', '', 'px']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap button.eaw-sidebar-cart-bt-nav:hover',
                '.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap .eaw-sidebar-cart-bt-nav.button:hover'
            ],
            ['scFootButtonHoverBgColor', 'scFootButtonHoverColor'],
            ['background', 'color'],
            ['', '']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap button.eaw-sidebar-cart-bt-update',
                '.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap .eaw-sidebar-cart-bt-update.button'
            ],
            ['scFootBtUpdateBgColor', 'scFootBtUpdateTextColor', 'scFootBtUpdateBorderRadius'],
            ['background', 'color', 'border-radius'],
            ['', '', 'px']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap button.eaw-sidebar-cart-bt-update:hover',
                '.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap .eaw-sidebar-cart-bt-update.button:hover'
            ],
            ['scFootBtUpdateHoverBgColor', 'scFootBtUpdateHoverColor'],
            ['background', 'color'],
            ['', '']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-footer-wrap .eaw-sidebar-cart-footer-pd-plus-title'],
            ['scFootPdPlusColor'],
            ['color'],
            ['']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-products-wrap'],
            ['scPdBgColor'],
            ['background'],
            ['']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-img-wrap img'],
            ['scPdImgBorderRadius'],
            ['border-radius'],
            ['px']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-info-wrap .eaw-sidebar-cart-pd-name-wrap .eaw-sidebar-cart-pd-name',
                '.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-info-wrap .eaw-sidebar-cart-pd-name-wrap a',
                '.eaw-sidebar-cart-footer-pd-name *'
            ],
            ['scPdNameColor'],
            ['color'],
            ['']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-info-wrap .eaw-sidebar-cart-pd-name-wrap .eaw-sidebar-cart-pd-name:hover, .eaw-sidebar-cart-footer-pd-name *:hover'],
            ['scPdNameHoverColor'],
            ['color'],
            ['']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-info-wrap .eaw-sidebar-cart-pd-price *, .eaw-sidebar-cart-footer-pd-price *'],
            ['scPdPriceColor'],
            ['color'],
            ['!important']
        );
        if ($scPdQtyColor = self::$settings->getParams('scPdQtyColor')) {
            $css .= '.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-desc .eaw-sidebar-cart-pd-quantity{
                 border: 1px solid ' . $scPdQtyColor . ' ;
            }';
            $css .= '.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-desc .eaw_minus{
                 border-right: 1px solid ' . $scPdQtyColor . ' ;
            }';
            $css .= '.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-desc .eaw_plus{
                 border-left: 1px solid ' . $scPdQtyColor . ' ;
            }';
            $css .= '.eaw-sidebar-cart.eaw-sidebar-cart-rtl .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-desc .eaw_minus{
			     border-right: unset;
                 border-left: 1px solid ' . $scPdQtyColor . ' ;
            }';
            $css .= '.eaw-sidebar-cart.eaw-sidebar-cart-rtl .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-desc .eaw_plus{
			     border-left: unset;
                 border-right: 1px solid ' . $scPdQtyColor . ' ;
            }';
        }
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-desc .eaw-sidebar-cart-pd-quantity'],
            ['scPdQtyBorderRadius'],
            ['border-radius'],
            ['px']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-remove-wrap i'],
            ['scPdDeleteIconColor'],
            ['color'],
            ['']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-remove-wrap i:before'],
            ['scPdDeleteIconFontSize'],
            ['font-size'],
            ['px']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-products .eaw-sidebar-cart-pd-remove-wrap i:hover'],
            ['scPdDeleteIconHoverColor'],
            ['color'],
            ['']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart button.eaw-pd_plus-product-bt-atc',
                '.eaw-sidebar-cart .button.eaw-pd_plus-product-bt-atc',
            ],
            ['scFootPdPlusBtAtcBgColor', 'scFootPdPlusBtAtcColor'],
            ['background', 'color'],
            ['', '']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart button.eaw-pd_plus-product-bt-atc:hover',
                '.eaw-sidebar-cart .button.eaw-pd_plus-product-bt-atc:hover',
            ],
            ['scFootPdPlusBtAtcHoverBgColor', 'scFootPdPlusBtAtcHoverTextColor'],
            ['background', 'color'],
            ['', '']
        );
        $css = str_replace(["\r", "\n", '\r', '\n'], ' ', $css);

        return $css;
    }

    public function get_checkout_inline_css($frontend)
    {
        $css = '';
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .eaw-sidebar-cart-content-wrap1.eaw-sidebar-cart-checkout-wrap'],
            ['scCheckOutBgColor'],
            ['background'],
            ['']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart button.eaw-sidebar-cart-bt-checkout-cancel',
                '.eaw-sidebar-cart .button.eaw-sidebar-cart-bt-checkout-cancel'
            ],
            ['scCheckoutBtBtcBgColor', 'scCheckoutBtBtcColor', 'scCheckoutBtBtcBorderRadius'],
            ['background', 'color', 'border-radius'],
            ['!important', '!important', 'px !important']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart button.eaw-sidebar-cart-bt-checkout-cancel:hover',
                '.eaw-sidebar-cart .button.eaw-sidebar-cart-bt-checkout-cancel:hover'
            ],
            ['scCheckoutBtBtcHoverBgColor', 'scCheckoutBtBtcHoverColor'],
            ['background', 'color'],
            ['!important', '!important']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .button.eaw-sidebar-cart-bt-checkout-nav.eaw-sidebar-cart-bt-checkout-next'],
            ['scCheckoutBtNextBgColor', 'scCheckoutBtNextColor', 'scCheckoutBtNextBorderRadius'],
            ['background', 'color', 'border-radius'],
            ['!important', '!important', 'px !important']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart .button.eaw-sidebar-cart-bt-checkout-nav.eaw-sidebar-cart-bt-checkout-next:hover'],
            ['scCheckoutBtNextHoverBgColor', 'scCheckoutBtNextHoverColor'],
            ['background', 'color'],
            ['!important', '!important']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart button.eaw-sidebar-cart-bt-checkout-nav.eaw-sidebar-cart-bt-checkout-back',
                '.eaw-sidebar-cart .button.eaw-sidebar-cart-bt-checkout-nav.eaw-sidebar-cart-bt-checkout-back'
            ],
            ['scCheckoutBtPreBgColor', 'scCheckoutBtPreColor', 'scCheckoutBtPlaceOrderBorderRadius'],
            ['background', 'color', 'border-radius'],
            ['!important', '!important', 'px !important']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart button.eaw-sidebar-cart-bt-checkout-nav.eaw-sidebar-cart-bt-checkout-back:hover',
                '.eaw-sidebar-cart .button.eaw-sidebar-cart-bt-checkout-nav.eaw-sidebar-cart-bt-checkout-back:hover',
            ],
            ['scCheckoutBtPreHoverBgColor', 'scCheckoutBtPlaceOrderHoverTextColor'],
            ['background', 'color'],
            ['!important', '!important']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart button.eaw-sidebar-cart-bt-checkout-place_order',
                '.eaw-sidebar-cart .button.eaw-sidebar-cart-bt-checkout-place_order',
            ],
            ['scCheckoutBtPlaceOrderBgColor', 'scCheckoutBtPlaceOrderTextColor', 'scCheckoutBtPlaceOrderHoverColor'],
            ['background', 'color', 'border-radius'],
            ['!important', '!important', 'px !important']
        );
        $css .= $frontend::add_inline_style(
            [
                '.eaw-sidebar-cart button.eaw-sidebar-cart-bt-checkout-place_order:hover',
                '.eaw-sidebar-cart .button.eaw-sidebar-cart-bt-checkout-place_order:hover',
            ],
            ['scCheckoutBtPlaceOrderHoverBgColor', 'scCheckoutBtPlaceOrderHoverColor'],
            ['background', 'color'],
            ['!important', '!important']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart-wrap .eaw-checkout-nav-step-wrap .eaw-checkout-nav-step'],
            ['scCheckoutNavBarColor'],
            ['background'],
            ['!important']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart-wrap .eaw-checkout-nav-step-wrap .eaw-checkout-nav-step:hover'],
            ['scCheckoutNavBarHoverColor'],
            ['background'],
            ['!important']
        );
        $css .= $frontend::add_inline_style(
            ['.eaw-sidebar-cart-wrap .eaw-checkout-nav-step-wrap .eaw-checkout-nav-step.eaw-checkout-step-current'],
            ['scCheckoutNavBarSelectedColor'],
            ['background'],
            ['!important']
        );

        return $css;
    }

    public static function assign_page()
    {
        if (isset(self::$cache['assign_page'])) {
            return self::$cache['assign_page'];
        }
        if (! self::$settings->getParams('scEnable')) {
            return self::$cache['assign_page'] = false;
        }
        $assign_page = self::$settings->getParams('scAssignPage');
        if ($assign_page) {
            if (stristr($assign_page, "return") === false) {
                $assign_page = "return (" . $assign_page . ");";
            }
            try {
                $logic_show = $assign_page;
            } catch (\Error $e) {

                $logic_show = false;
            } catch (\Exception $e) {

                $logic_show = false;
            }
            if (! $logic_show) {
                return self::$cache['assign_page'] = false;
            }
        }

        return self::$cache['assign_page'] = true;
    }

    public function sidebar_checkout_assign_page()
    {
        if (isset(self::$cache['sidebar_checkout_assign_page'])) {
            return self::$cache['sidebar_checkout_assign_page'];
        }
        if (! self::$sc_checkout || ! $this->assign_page()) {
            return self::$cache['sidebar_checkout_assign_page'] = false;
        }
        if (apply_filters('eaw_sidebar_checkout_hidden', (is_checkout() || is_cart()) && ! is_product())) {
            return self::$cache['sidebar_checkout_assign_page'] = false;
        }

        return self::$cache['sidebar_checkout_assign_page'] = true;
    }

    public static function is_customize_preview()
    {
        if (isset(self::$cache['is_customize_preview'])) {
            return self::$cache['is_customize_preview'];
        }

        return self::$cache['is_customize_preview'] = is_customize_preview();
    }

    public static function get_language()
    {
        if (isset(self::$cache['language'])) {
            return self::$cache['language'];
        }
        $languageInfo            = Helpers::getLanguageInfo();
        self::$cache['language'] = $languageInfo['language'] ?? '';

        return self::$cache['language'];
    }

    public function getParams($name = '', $language = '')
    {
        if (!$this->customize_data) {
            global $wp_customize;
            $this->customize_data = $wp_customize;
        }
        if ($this->customize_data && $name && $setting = $this->customize_data->get_setting("ccpeaw_settings[$name]")) {
            return $this->customize_data->post_value($setting, self::$settings->getParams($name));
        } else {
            return self::$settings->getParams($name, $language);
        }
    }


    public static function get_sidebar_content_pd_html($wc_cart, $scPdPriceStyle = null)
    {
        wc_get_template(
            'sc-product-list-html.php',
            [
                'sidebar_cart'      => self::getInstance(),
                'wc_cart'           => $wc_cart,
                'scPdPriceStyle'    => $scPdPriceStyle,
            ],
            'essential-addons-for-woocommerce' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR . 'sidebar-cart' . DIRECTORY_SEPARATOR,
            CCPEAW_TEMPLATES . 'atc' . DIRECTORY_SEPARATOR . 'sidebar-cart' . DIRECTORY_SEPARATOR
        );
    }

    public static function get_sc_pd_quantity_html($args = [], $echo = false)
    {
        if ($echo) {
            wc_get_template(
                'vicaio-product-quantity-html.php',
                ['args' => $args],
                'essential-addons-for-woocommerce' . DIRECTORY_SEPARATOR,
                CCPEAW_TEMPLATES . 'atc' . DIRECTORY_SEPARATOR
            );
        } else {
            ob_start();
            wc_get_template(
                'vicaio-product-quantity-html.php',
                ['args' => $args],
                'essential-addons-for-woocommerce' . DIRECTORY_SEPARATOR,
                CCPEAW_TEMPLATES . 'atc' . DIRECTORY_SEPARATOR
            );
            $html = ob_get_clean();

            return $html;
        }
    }

    public static function get_sc_pd_price_html($wc_cart, $cart_item, $cart_item_key, $product, $style = 'price')
    {
        if (! $wc_cart || ! $product) {
            return '';
        }
        switch ($style) {
            case 'qty':
                $html = $product->is_sold_individually() ? 1 : ($cart_item['quantity'] ?? 1);
                $html .= ' &#215; ' . apply_filters('woocommerce_cart_item_price', $wc_cart->get_product_price($product), $cart_item, $cart_item_key);
                break;
            case 'subtotal':
                $html = apply_filters('woocommerce_cart_item_subtotal', $wc_cart->get_product_subtotal($product, $cart_item['quantity']), $cart_item, $cart_item_key);
                break;
            default:
                $html = apply_filters('woocommerce_cart_item_price', $wc_cart->get_product_price($product), $cart_item, $cart_item_key);
        }

        return $html;
    }

    public static function get_scFootCoupon_html($coupons)
    {
        if (empty($coupons)) {
            return apply_filters('eaw_footer_coupon_html', '');
        }
        ob_start();
        foreach ($coupons as $code => $coupon) {
            ?>
			<tr class="eaw-coupon eaw-coupon-<?php echo esc_attr($code) ?>">
				<td><?php wc_cart_totals_coupon_label($coupon); ?></td>
				<td><?php wc_cart_totals_coupon_html($coupon); ?> </td>
			</tr>
		<?php
        }
        $html = ob_get_clean();
        $html = '<table cellspacing="0" >' . $html . '</table>';

        return apply_filters('eaw_footer_coupon_html', $html);
    }

    public static function get_scFootMsg_html($text, $language = false)
    {
        if (! $text) {
            return '';
        }
        $shortcodes = [];
        preg_match_all('/' . get_shortcode_regex() . '/', $text, $matches, PREG_SET_ORDER);
        if (! empty($matches)) {
            foreach ($matches as $shortcode) {
                $shortcodes[] = $shortcode[0];
            }
        }
        if (count($shortcodes)) {
            foreach ($shortcodes as $shortcode) {
                $text = str_replace($shortcode, do_shortcode($shortcode), $text);
            }
        }
        $text = str_replace('{product_plus}', self::get_product_plus($language), $text);
        echo wp_kses($text, AppSettings::extendPostAllowedHtml());
    }

    public static function get_product_plus($language = false, $type = false)
    {
        $settings           = self::$settings;
        $language           = $language ? self::get_language() : '';
        $scFootPdPlus       = $type !== false ? $type : $settings->getParams('scFootPdPlus');
        $product_plus_limit = $settings->getParams('scFootPdPlusLimit');
        $out_of_stock       = $settings->getParams('scFootPdPlusOutOfStock');
        $product_plus       = self::get_sidebar_pd_plus($settings, $scFootPdPlus, $product_plus_limit, $out_of_stock);
        if ($language && is_plugin_active('sitepress-multilingual-cms/sitepress.php')) {
            $product_plus = self::get_sidebar_pd_plus_wpml($product_plus, $language);
        }
        if (empty($product_plus) || ! is_array($product_plus)) {
            return '<div class="eaw-sidebar-cart-footer-pd-wrap-wrap eaw-disabled"></div>';
        }
        ob_start();
        ?>
		<div class="eaw-sidebar-cart-footer-pd-wrap-wrap eaw-sidebar-cart-footer-pd-<?php echo esc_attr($scFootPdPlus); ?>">
			<div class="eaw-sidebar-cart-footer-pd-plus-title">
				<?php echo wp_kses_post($settings->getParams('scFootPdPlusTitle', $language)); ?>
			</div>
			<div class="eaw-sidebar-cart-footer-pd-wrap">
				<?php
                foreach ($product_plus as $product_id) {
                    wc_get_template(
                        'sc-product-plus-html.php',
                        ['product_id' => $product_id, 'language' => $language, 'settings' => $settings],
                        'essential-addons-for-woocommerce' . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR . 'sidebar-cart' . DIRECTORY_SEPARATOR,
                        CCPEAW_TEMPLATES . 'atc' . DIRECTORY_SEPARATOR . 'sidebar-cart' . DIRECTORY_SEPARATOR
                    );
                }
        ?>
			</div>
		</div>
		<?php
        $html = ob_get_clean();

        return $html;
    }

    public static function get_sidebar_pd_plus($settings, $type = '', $limit = 5, $out_of_stock = false)
    {
        if (! $settings || ! $type) {
            return false;
        }

        return $product_ids ?? false;
    }

    public static function get_sidebar_pd_plus_wpml($product_plus, $language = '')
    {
        if (! $language || ! is_array($product_plus) || empty($product_plus)) {
            return false;
        }
        $result = [];
        foreach ($product_plus as $product_id) {
            $result[] = apply_filters('wpml_object_id', $product_id, 'product', false, $language);
        }

        return array_unique($result);
    }

    public function get_sidebar_loading($type)
    {
        if (! $type) {
            return;
        }
        $class   = [
            'eaw-sidebar-cart-loading eaw-sidebar-cart-loading-' . $type
        ];
        $class[] = $this->is_customize ? 'eaw-disabled' : '';
        $class   = trim(implode(' ', $class));
        switch ($type) {
            case 'spinner':
            case 'default':
                ?>
				<div class="<?php echo esc_attr($class); ?>">
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
				</div>
			<?php
                        break;
            case 'dual_ring':
                ?>
				<div class="<?php echo esc_attr($class); ?>"></div>
			<?php
                    break;
            case 'animation_face_1':
                ?>
				<div class="<?php echo esc_attr($class); ?>">
					<div></div>
					<div></div>
					<div></div>
				</div><?php
                            break;
            case 'animation_face_2':
            case 'ring':
                ?>
				<div class="<?php echo esc_attr($class); ?>">
					<div></div>
					<div></div>
					<div></div>
					<div></div>
				</div><?php
                break;
            case 'roller':
                ?>
				<div class="<?php echo esc_attr($class); ?>">
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
					<div></div>
				</div>
			<?php
                break;
            case 'loader_balls_1':
                ?>
				<div class="<?php echo esc_attr($class); ?>">
					<div></div>
					<div></div>
					<div></div>
					<div></div>
				</div>
			<?php
                            break;
            case 'loader_balls_2':
            case 'loader_balls_3':
                ?>
				<div class="<?php echo esc_attr($class); ?>">
					<div></div>
					<div></div>
					<div></div>
				</div>
			<?php
                            break;
            case 'ripple':
                ?>
				<div class="<?php echo esc_attr($class); ?>">
					<div></div>
					<div></div>
				</div>
<?php
                            break;
        }
    }

    public static function product_get_bt_atc_html($settings, $language)
    {
        if (! $settings) {
            return '';
        }
        $html            = $settings->getParams('scFootPdPlusBtAtcTitle', $language);
        $cart_icon_class = $settings->getClassIcon($settings->getParams('scFootPdPlusBtAtcCartIcon'), 'cart_icons_atc') ?: '';
        $html            = str_replace('{cart_icon}', '<i class="eaw-pd_plus-bt-atc-cart_icons ' . $cart_icon_class . '"></i>', $html);

        return $html;
    }
}
