<?php
/**
 * StockProfile
 *
 * PHP version 5
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Stocks
 *
 * <h3>Rate limits</h3>                     Free subscriptions are subject to daily limits. To know how much requests you have left look at the following headers in the response.<br />                     1. <strong>x-ratelimit-limit</strong> - The total number of requests that you are allowed to make in a given period (hour/day)<br />                     2. <strong>x-ratelimit-remaining</strong> - The number of remaining requests that you can perform in the current period.<br />                     3. <strong>x-ratelimit-reset</strong> - The number of seconds until the current period resets.<br />                     <br />                     <br />                     You don't have an API key? <a href=\"https://www.equibles.com/api/pricing\" target=\"_blank\">Get one for free here.</a>
 *
 * OpenAPI spec version: v1
 * Contact: contact@equibles.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.34
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EquiblesStocks\Models;

use \ArrayAccess;
use \EquiblesStocks\ObjectSerializer;

/**
 * StockProfile Class Doc Comment
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class StockProfile implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'StockProfile';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'logo' => '\EquiblesStocks\Models\Image',
'address' => 'string',
'cik' => 'string',
'locale' => 'string',
'marketCap' => 'int',
'sharesOutstandingLast' => 'int',
'phoneNumber' => 'string',
'description' => 'string',
'employees' => 'int',
'delisted' => 'bool',
'listDate' => '\DateTime',
'website' => 'string',
'industry' => '\EquiblesStocks\Models\Industry',
'officers' => '\EquiblesStocks\Models\Officer[]',
'ticker' => 'string',
'fullTicker' => 'string',
'assetType' => '\EquiblesStocks\Models\AssetType',
'name' => 'string',
'exchange' => '\EquiblesStocks\Models\Exchange',
'lastPrice' => '\EquiblesStocks\Models\Price'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'logo' => null,
'address' => null,
'cik' => null,
'locale' => null,
'marketCap' => 'int64',
'sharesOutstandingLast' => 'int64',
'phoneNumber' => null,
'description' => null,
'employees' => 'int64',
'delisted' => null,
'listDate' => 'date-time',
'website' => null,
'industry' => null,
'officers' => null,
'ticker' => null,
'fullTicker' => null,
'assetType' => null,
'name' => null,
'exchange' => null,
'lastPrice' => null    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'logo' => 'logo',
'address' => 'address',
'cik' => 'cik',
'locale' => 'locale',
'marketCap' => 'marketCap',
'sharesOutstandingLast' => 'sharesOutstandingLast',
'phoneNumber' => 'phoneNumber',
'description' => 'description',
'employees' => 'employees',
'delisted' => 'delisted',
'listDate' => 'listDate',
'website' => 'website',
'industry' => 'industry',
'officers' => 'officers',
'ticker' => 'ticker',
'fullTicker' => 'fullTicker',
'assetType' => 'assetType',
'name' => 'name',
'exchange' => 'exchange',
'lastPrice' => 'lastPrice'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'logo' => 'setLogo',
'address' => 'setAddress',
'cik' => 'setCik',
'locale' => 'setLocale',
'marketCap' => 'setMarketCap',
'sharesOutstandingLast' => 'setSharesOutstandingLast',
'phoneNumber' => 'setPhoneNumber',
'description' => 'setDescription',
'employees' => 'setEmployees',
'delisted' => 'setDelisted',
'listDate' => 'setListDate',
'website' => 'setWebsite',
'industry' => 'setIndustry',
'officers' => 'setOfficers',
'ticker' => 'setTicker',
'fullTicker' => 'setFullTicker',
'assetType' => 'setAssetType',
'name' => 'setName',
'exchange' => 'setExchange',
'lastPrice' => 'setLastPrice'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'logo' => 'getLogo',
'address' => 'getAddress',
'cik' => 'getCik',
'locale' => 'getLocale',
'marketCap' => 'getMarketCap',
'sharesOutstandingLast' => 'getSharesOutstandingLast',
'phoneNumber' => 'getPhoneNumber',
'description' => 'getDescription',
'employees' => 'getEmployees',
'delisted' => 'getDelisted',
'listDate' => 'getListDate',
'website' => 'getWebsite',
'industry' => 'getIndustry',
'officers' => 'getOfficers',
'ticker' => 'getTicker',
'fullTicker' => 'getFullTicker',
'assetType' => 'getAssetType',
'name' => 'getName',
'exchange' => 'getExchange',
'lastPrice' => 'getLastPrice'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['logo'] = isset($data['logo']) ? $data['logo'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['cik'] = isset($data['cik']) ? $data['cik'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['marketCap'] = isset($data['marketCap']) ? $data['marketCap'] : null;
        $this->container['sharesOutstandingLast'] = isset($data['sharesOutstandingLast']) ? $data['sharesOutstandingLast'] : null;
        $this->container['phoneNumber'] = isset($data['phoneNumber']) ? $data['phoneNumber'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['employees'] = isset($data['employees']) ? $data['employees'] : null;
        $this->container['delisted'] = isset($data['delisted']) ? $data['delisted'] : null;
        $this->container['listDate'] = isset($data['listDate']) ? $data['listDate'] : null;
        $this->container['website'] = isset($data['website']) ? $data['website'] : null;
        $this->container['industry'] = isset($data['industry']) ? $data['industry'] : null;
        $this->container['officers'] = isset($data['officers']) ? $data['officers'] : null;
        $this->container['ticker'] = isset($data['ticker']) ? $data['ticker'] : null;
        $this->container['fullTicker'] = isset($data['fullTicker']) ? $data['fullTicker'] : null;
        $this->container['assetType'] = isset($data['assetType']) ? $data['assetType'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['exchange'] = isset($data['exchange']) ? $data['exchange'] : null;
        $this->container['lastPrice'] = isset($data['lastPrice']) ? $data['lastPrice'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets logo
     *
     * @return \EquiblesStocks\Models\Image
     */
    public function getLogo()
    {
        return $this->container['logo'];
    }

    /**
     * Sets logo
     *
     * @param \EquiblesStocks\Models\Image $logo logo
     *
     * @return $this
     */
    public function setLogo($logo)
    {
        $this->container['logo'] = $logo;

        return $this;
    }

    /**
     * Gets address
     *
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param string $address address
     *
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets cik
     *
     * @return string
     */
    public function getCik()
    {
        return $this->container['cik'];
    }

    /**
     * Sets cik
     *
     * @param string $cik cik
     *
     * @return $this
     */
    public function setCik($cik)
    {
        $this->container['cik'] = $cik;

        return $this;
    }

    /**
     * Gets locale
     *
     * @return string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     *
     * @param string $locale locale
     *
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets marketCap
     *
     * @return int
     */
    public function getMarketCap()
    {
        return $this->container['marketCap'];
    }

    /**
     * Sets marketCap
     *
     * @param int $marketCap marketCap
     *
     * @return $this
     */
    public function setMarketCap($marketCap)
    {
        $this->container['marketCap'] = $marketCap;

        return $this;
    }

    /**
     * Gets sharesOutstandingLast
     *
     * @return int
     */
    public function getSharesOutstandingLast()
    {
        return $this->container['sharesOutstandingLast'];
    }

    /**
     * Sets sharesOutstandingLast
     *
     * @param int $sharesOutstandingLast sharesOutstandingLast
     *
     * @return $this
     */
    public function setSharesOutstandingLast($sharesOutstandingLast)
    {
        $this->container['sharesOutstandingLast'] = $sharesOutstandingLast;

        return $this;
    }

    /**
     * Gets phoneNumber
     *
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->container['phoneNumber'];
    }

    /**
     * Sets phoneNumber
     *
     * @param string $phoneNumber phoneNumber
     *
     * @return $this
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->container['phoneNumber'] = $phoneNumber;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets employees
     *
     * @return int
     */
    public function getEmployees()
    {
        return $this->container['employees'];
    }

    /**
     * Sets employees
     *
     * @param int $employees employees
     *
     * @return $this
     */
    public function setEmployees($employees)
    {
        $this->container['employees'] = $employees;

        return $this;
    }

    /**
     * Gets delisted
     *
     * @return bool
     */
    public function getDelisted()
    {
        return $this->container['delisted'];
    }

    /**
     * Sets delisted
     *
     * @param bool $delisted delisted
     *
     * @return $this
     */
    public function setDelisted($delisted)
    {
        $this->container['delisted'] = $delisted;

        return $this;
    }

    /**
     * Gets listDate
     *
     * @return \DateTime
     */
    public function getListDate()
    {
        return $this->container['listDate'];
    }

    /**
     * Sets listDate
     *
     * @param \DateTime $listDate listDate
     *
     * @return $this
     */
    public function setListDate($listDate)
    {
        $this->container['listDate'] = $listDate;

        return $this;
    }

    /**
     * Gets website
     *
     * @return string
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string $website website
     *
     * @return $this
     */
    public function setWebsite($website)
    {
        $this->container['website'] = $website;

        return $this;
    }

    /**
     * Gets industry
     *
     * @return \EquiblesStocks\Models\Industry
     */
    public function getIndustry()
    {
        return $this->container['industry'];
    }

    /**
     * Sets industry
     *
     * @param \EquiblesStocks\Models\Industry $industry industry
     *
     * @return $this
     */
    public function setIndustry($industry)
    {
        $this->container['industry'] = $industry;

        return $this;
    }

    /**
     * Gets officers
     *
     * @return \EquiblesStocks\Models\Officer[]
     */
    public function getOfficers()
    {
        return $this->container['officers'];
    }

    /**
     * Sets officers
     *
     * @param \EquiblesStocks\Models\Officer[] $officers officers
     *
     * @return $this
     */
    public function setOfficers($officers)
    {
        $this->container['officers'] = $officers;

        return $this;
    }

    /**
     * Gets ticker
     *
     * @return string
     */
    public function getTicker()
    {
        return $this->container['ticker'];
    }

    /**
     * Sets ticker
     *
     * @param string $ticker ticker
     *
     * @return $this
     */
    public function setTicker($ticker)
    {
        $this->container['ticker'] = $ticker;

        return $this;
    }

    /**
     * Gets fullTicker
     *
     * @return string
     */
    public function getFullTicker()
    {
        return $this->container['fullTicker'];
    }

    /**
     * Sets fullTicker
     *
     * @param string $fullTicker fullTicker
     *
     * @return $this
     */
    public function setFullTicker($fullTicker)
    {
        $this->container['fullTicker'] = $fullTicker;

        return $this;
    }

    /**
     * Gets assetType
     *
     * @return \EquiblesStocks\Models\AssetType
     */
    public function getAssetType()
    {
        return $this->container['assetType'];
    }

    /**
     * Sets assetType
     *
     * @param \EquiblesStocks\Models\AssetType $assetType assetType
     *
     * @return $this
     */
    public function setAssetType($assetType)
    {
        $this->container['assetType'] = $assetType;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets exchange
     *
     * @return \EquiblesStocks\Models\Exchange
     */
    public function getExchange()
    {
        return $this->container['exchange'];
    }

    /**
     * Sets exchange
     *
     * @param \EquiblesStocks\Models\Exchange $exchange exchange
     *
     * @return $this
     */
    public function setExchange($exchange)
    {
        $this->container['exchange'] = $exchange;

        return $this;
    }

    /**
     * Gets lastPrice
     *
     * @return \EquiblesStocks\Models\Price
     */
    public function getLastPrice()
    {
        return $this->container['lastPrice'];
    }

    /**
     * Sets lastPrice
     *
     * @param \EquiblesStocks\Models\Price $lastPrice lastPrice
     *
     * @return $this
     */
    public function setLastPrice($lastPrice)
    {
        $this->container['lastPrice'] = $lastPrice;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
