<?php
/**
 * ScreenerRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Stocks
 *
 * <h3>Rate limits</h3>                     Free subscriptions are subject to daily limits. To know how much requests you have left look at the following headers in the response.<br />                     1. <strong>x-ratelimit-limit</strong> - The total number of requests that you are allowed to make in a given period (hour/day)<br />                     2. <strong>x-ratelimit-remaining</strong> - The number of remaining requests that you can perform in the current period.<br />                     3. <strong>x-ratelimit-reset</strong> - The number of seconds until the current period resets.<br />                     <br />                     <br />                     You don't have an API key? <a href=\"https://www.equibles.com/api/pricing\" target=\"_blank\">Get one for free here.</a>
 *
 * OpenAPI spec version: v1
 * Contact: contact@equibles.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.34
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EquiblesStocks\Models;

use \ArrayAccess;
use \EquiblesStocks\ObjectSerializer;

/**
 * ScreenerRequest Class Doc Comment
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ScreenerRequest implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'ScreenerRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'searchQuery' => 'string',
'exchangeIds' => 'int[]',
'sectorIds' => 'int[]',
'industryIds' => 'int[]',
'marketCapMin' => 'double',
'marketCapMax' => 'double',
'betaMin' => 'double',
'betaMax' => 'double',
'forwardDividendMin' => 'double',
'forwardDividendMax' => 'double',
'forwardDividendYieldMin' => 'double',
'forwardDividendYieldMax' => 'double',
'shortRatioMin' => 'double',
'shortRatioMax' => 'double',
'sharesShortPercentageMin' => 'double',
'sharesShortPercentageMax' => 'double',
'sharesShortPreviousMonthPercentageMin' => 'double',
'sharesShortPreviousMonthPercentageMax' => 'double',
'analystRecommendationMin' => '\EquiblesStocks\Models\Recommendation',
'analystRecommendationMax' => '\EquiblesStocks\Models\Recommendation',
'performanceOneDayMin' => 'double',
'performanceOneDayMax' => 'double',
'performanceOneWeekMin' => 'double',
'performanceOneWeekMax' => 'double',
'performanceTwoWeeksMin' => 'double',
'performanceTwoWeeksMax' => 'double',
'performanceOneMonthMin' => 'double',
'performanceOneMonthMax' => 'double',
'performanceThreeMonthsMin' => 'double',
'performanceThreeMonthsMax' => 'double',
'performanceOneYearMin' => 'double',
'performanceOneYearMax' => 'double',
'performanceThreeYearsMin' => 'double',
'performanceThreeYearsMax' => 'double',
'performanceFiveYearsMin' => 'double',
'performanceFiveYearsMax' => 'double',
'performanceTenYearsMin' => 'double',
'performanceTenYearsMax' => 'double',
'performanceTwentyYearsMin' => 'double',
'performanceTwentyYearsMax' => 'double',
'epsGrowthOneYearMin' => 'double',
'epsGrowthOneYearMax' => 'double',
'epsGrowthTwoYearsMin' => 'double',
'epsGrowthTwoYearsMax' => 'double',
'epsGrowthThreeYearsMin' => 'double',
'epsGrowthThreeYearsMax' => 'double',
'epsGrowthFiveYearsMin' => 'double',
'epsGrowthFiveYearsMax' => 'double',
'epsGrowthTenYearsMin' => 'double',
'epsGrowthTenYearsMax' => 'double',
'epsGrowthTwentyYearsMin' => 'double',
'epsGrowthTwentyYearsMax' => 'double',
'peMin' => 'double',
'peMax' => 'double',
'pegMin' => 'double',
'pegMax' => 'double',
'priceFcfMin' => 'double',
'priceFcfMax' => 'double',
'bookValuePerShareMin' => 'double',
'bookValuePerShareMax' => 'double',
'priceBookValuePerShareMin' => 'double',
'priceBookValuePerShareMax' => 'double',
'payoutMin' => 'double',
'payoutMax' => 'double',
'debtToEquityMin' => 'double',
'debtToEquityMax' => 'double',
'grossMarginMin' => 'double',
'grossMarginMax' => 'double',
'operatingMarginMin' => 'double',
'operatingMarginMax' => 'double',
'profitMarginMin' => 'double',
'profitMarginMax' => 'double',
'priceToSalesMin' => 'double',
'priceToSalesMax' => 'double',
'buybacksThreeMonthsMin' => 'double',
'buybacksThreeMonthsMax' => 'double',
'buybacksSixMonthsMin' => 'double',
'buybacksSixMonthsMax' => 'double',
'buybacksOneYearMin' => 'double',
'buybacksOneYearMax' => 'double',
'buybacksTwoYearsMin' => 'double',
'buybacksTwoYearsMax' => 'double',
'buybacksThreeYearsMin' => 'double',
'buybacksThreeYearsMax' => 'double',
'buybacksFiveYearsMin' => 'double',
'buybacksFiveYearsMax' => 'double',
'buybacksTenYearsMin' => 'double',
'buybacksTenYearsMax' => 'double',
'buybacksTwentyYearsMin' => 'double',
'buybacksTwentyYearsMax' => 'double',
'potentialUpside' => 'double'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'searchQuery' => null,
'exchangeIds' => 'int32',
'sectorIds' => 'int32',
'industryIds' => 'int32',
'marketCapMin' => 'double',
'marketCapMax' => 'double',
'betaMin' => 'double',
'betaMax' => 'double',
'forwardDividendMin' => 'double',
'forwardDividendMax' => 'double',
'forwardDividendYieldMin' => 'double',
'forwardDividendYieldMax' => 'double',
'shortRatioMin' => 'double',
'shortRatioMax' => 'double',
'sharesShortPercentageMin' => 'double',
'sharesShortPercentageMax' => 'double',
'sharesShortPreviousMonthPercentageMin' => 'double',
'sharesShortPreviousMonthPercentageMax' => 'double',
'analystRecommendationMin' => null,
'analystRecommendationMax' => null,
'performanceOneDayMin' => 'double',
'performanceOneDayMax' => 'double',
'performanceOneWeekMin' => 'double',
'performanceOneWeekMax' => 'double',
'performanceTwoWeeksMin' => 'double',
'performanceTwoWeeksMax' => 'double',
'performanceOneMonthMin' => 'double',
'performanceOneMonthMax' => 'double',
'performanceThreeMonthsMin' => 'double',
'performanceThreeMonthsMax' => 'double',
'performanceOneYearMin' => 'double',
'performanceOneYearMax' => 'double',
'performanceThreeYearsMin' => 'double',
'performanceThreeYearsMax' => 'double',
'performanceFiveYearsMin' => 'double',
'performanceFiveYearsMax' => 'double',
'performanceTenYearsMin' => 'double',
'performanceTenYearsMax' => 'double',
'performanceTwentyYearsMin' => 'double',
'performanceTwentyYearsMax' => 'double',
'epsGrowthOneYearMin' => 'double',
'epsGrowthOneYearMax' => 'double',
'epsGrowthTwoYearsMin' => 'double',
'epsGrowthTwoYearsMax' => 'double',
'epsGrowthThreeYearsMin' => 'double',
'epsGrowthThreeYearsMax' => 'double',
'epsGrowthFiveYearsMin' => 'double',
'epsGrowthFiveYearsMax' => 'double',
'epsGrowthTenYearsMin' => 'double',
'epsGrowthTenYearsMax' => 'double',
'epsGrowthTwentyYearsMin' => 'double',
'epsGrowthTwentyYearsMax' => 'double',
'peMin' => 'double',
'peMax' => 'double',
'pegMin' => 'double',
'pegMax' => 'double',
'priceFcfMin' => 'double',
'priceFcfMax' => 'double',
'bookValuePerShareMin' => 'double',
'bookValuePerShareMax' => 'double',
'priceBookValuePerShareMin' => 'double',
'priceBookValuePerShareMax' => 'double',
'payoutMin' => 'double',
'payoutMax' => 'double',
'debtToEquityMin' => 'double',
'debtToEquityMax' => 'double',
'grossMarginMin' => 'double',
'grossMarginMax' => 'double',
'operatingMarginMin' => 'double',
'operatingMarginMax' => 'double',
'profitMarginMin' => 'double',
'profitMarginMax' => 'double',
'priceToSalesMin' => 'double',
'priceToSalesMax' => 'double',
'buybacksThreeMonthsMin' => 'double',
'buybacksThreeMonthsMax' => 'double',
'buybacksSixMonthsMin' => 'double',
'buybacksSixMonthsMax' => 'double',
'buybacksOneYearMin' => 'double',
'buybacksOneYearMax' => 'double',
'buybacksTwoYearsMin' => 'double',
'buybacksTwoYearsMax' => 'double',
'buybacksThreeYearsMin' => 'double',
'buybacksThreeYearsMax' => 'double',
'buybacksFiveYearsMin' => 'double',
'buybacksFiveYearsMax' => 'double',
'buybacksTenYearsMin' => 'double',
'buybacksTenYearsMax' => 'double',
'buybacksTwentyYearsMin' => 'double',
'buybacksTwentyYearsMax' => 'double',
'potentialUpside' => 'double'    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'searchQuery' => 'searchQuery',
'exchangeIds' => 'exchangeIds',
'sectorIds' => 'sectorIds',
'industryIds' => 'industryIds',
'marketCapMin' => 'marketCapMin',
'marketCapMax' => 'marketCapMax',
'betaMin' => 'betaMin',
'betaMax' => 'betaMax',
'forwardDividendMin' => 'forwardDividendMin',
'forwardDividendMax' => 'forwardDividendMax',
'forwardDividendYieldMin' => 'forwardDividendYieldMin',
'forwardDividendYieldMax' => 'forwardDividendYieldMax',
'shortRatioMin' => 'shortRatioMin',
'shortRatioMax' => 'shortRatioMax',
'sharesShortPercentageMin' => 'sharesShortPercentageMin',
'sharesShortPercentageMax' => 'sharesShortPercentageMax',
'sharesShortPreviousMonthPercentageMin' => 'sharesShortPreviousMonthPercentageMin',
'sharesShortPreviousMonthPercentageMax' => 'sharesShortPreviousMonthPercentageMax',
'analystRecommendationMin' => 'analystRecommendationMin',
'analystRecommendationMax' => 'analystRecommendationMax',
'performanceOneDayMin' => 'performanceOneDayMin',
'performanceOneDayMax' => 'performanceOneDayMax',
'performanceOneWeekMin' => 'performanceOneWeekMin',
'performanceOneWeekMax' => 'performanceOneWeekMax',
'performanceTwoWeeksMin' => 'performanceTwoWeeksMin',
'performanceTwoWeeksMax' => 'performanceTwoWeeksMax',
'performanceOneMonthMin' => 'performanceOneMonthMin',
'performanceOneMonthMax' => 'performanceOneMonthMax',
'performanceThreeMonthsMin' => 'performanceThreeMonthsMin',
'performanceThreeMonthsMax' => 'performanceThreeMonthsMax',
'performanceOneYearMin' => 'performanceOneYearMin',
'performanceOneYearMax' => 'performanceOneYearMax',
'performanceThreeYearsMin' => 'performanceThreeYearsMin',
'performanceThreeYearsMax' => 'performanceThreeYearsMax',
'performanceFiveYearsMin' => 'performanceFiveYearsMin',
'performanceFiveYearsMax' => 'performanceFiveYearsMax',
'performanceTenYearsMin' => 'performanceTenYearsMin',
'performanceTenYearsMax' => 'performanceTenYearsMax',
'performanceTwentyYearsMin' => 'performanceTwentyYearsMin',
'performanceTwentyYearsMax' => 'performanceTwentyYearsMax',
'epsGrowthOneYearMin' => 'epsGrowthOneYearMin',
'epsGrowthOneYearMax' => 'epsGrowthOneYearMax',
'epsGrowthTwoYearsMin' => 'epsGrowthTwoYearsMin',
'epsGrowthTwoYearsMax' => 'epsGrowthTwoYearsMax',
'epsGrowthThreeYearsMin' => 'epsGrowthThreeYearsMin',
'epsGrowthThreeYearsMax' => 'epsGrowthThreeYearsMax',
'epsGrowthFiveYearsMin' => 'epsGrowthFiveYearsMin',
'epsGrowthFiveYearsMax' => 'epsGrowthFiveYearsMax',
'epsGrowthTenYearsMin' => 'epsGrowthTenYearsMin',
'epsGrowthTenYearsMax' => 'epsGrowthTenYearsMax',
'epsGrowthTwentyYearsMin' => 'epsGrowthTwentyYearsMin',
'epsGrowthTwentyYearsMax' => 'epsGrowthTwentyYearsMax',
'peMin' => 'peMin',
'peMax' => 'peMax',
'pegMin' => 'pegMin',
'pegMax' => 'pegMax',
'priceFcfMin' => 'priceFcfMin',
'priceFcfMax' => 'priceFcfMax',
'bookValuePerShareMin' => 'bookValuePerShareMin',
'bookValuePerShareMax' => 'bookValuePerShareMax',
'priceBookValuePerShareMin' => 'priceBookValuePerShareMin',
'priceBookValuePerShareMax' => 'priceBookValuePerShareMax',
'payoutMin' => 'payoutMin',
'payoutMax' => 'payoutMax',
'debtToEquityMin' => 'debtToEquityMin',
'debtToEquityMax' => 'debtToEquityMax',
'grossMarginMin' => 'grossMarginMin',
'grossMarginMax' => 'grossMarginMax',
'operatingMarginMin' => 'operatingMarginMin',
'operatingMarginMax' => 'operatingMarginMax',
'profitMarginMin' => 'profitMarginMin',
'profitMarginMax' => 'profitMarginMax',
'priceToSalesMin' => 'priceToSalesMin',
'priceToSalesMax' => 'priceToSalesMax',
'buybacksThreeMonthsMin' => 'buybacksThreeMonthsMin',
'buybacksThreeMonthsMax' => 'buybacksThreeMonthsMax',
'buybacksSixMonthsMin' => 'buybacksSixMonthsMin',
'buybacksSixMonthsMax' => 'buybacksSixMonthsMax',
'buybacksOneYearMin' => 'buybacksOneYearMin',
'buybacksOneYearMax' => 'buybacksOneYearMax',
'buybacksTwoYearsMin' => 'buybacksTwoYearsMin',
'buybacksTwoYearsMax' => 'buybacksTwoYearsMax',
'buybacksThreeYearsMin' => 'buybacksThreeYearsMin',
'buybacksThreeYearsMax' => 'buybacksThreeYearsMax',
'buybacksFiveYearsMin' => 'buybacksFiveYearsMin',
'buybacksFiveYearsMax' => 'buybacksFiveYearsMax',
'buybacksTenYearsMin' => 'buybacksTenYearsMin',
'buybacksTenYearsMax' => 'buybacksTenYearsMax',
'buybacksTwentyYearsMin' => 'buybacksTwentyYearsMin',
'buybacksTwentyYearsMax' => 'buybacksTwentyYearsMax',
'potentialUpside' => 'potentialUpside'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'searchQuery' => 'setSearchQuery',
'exchangeIds' => 'setExchangeIds',
'sectorIds' => 'setSectorIds',
'industryIds' => 'setIndustryIds',
'marketCapMin' => 'setMarketCapMin',
'marketCapMax' => 'setMarketCapMax',
'betaMin' => 'setBetaMin',
'betaMax' => 'setBetaMax',
'forwardDividendMin' => 'setForwardDividendMin',
'forwardDividendMax' => 'setForwardDividendMax',
'forwardDividendYieldMin' => 'setForwardDividendYieldMin',
'forwardDividendYieldMax' => 'setForwardDividendYieldMax',
'shortRatioMin' => 'setShortRatioMin',
'shortRatioMax' => 'setShortRatioMax',
'sharesShortPercentageMin' => 'setSharesShortPercentageMin',
'sharesShortPercentageMax' => 'setSharesShortPercentageMax',
'sharesShortPreviousMonthPercentageMin' => 'setSharesShortPreviousMonthPercentageMin',
'sharesShortPreviousMonthPercentageMax' => 'setSharesShortPreviousMonthPercentageMax',
'analystRecommendationMin' => 'setAnalystRecommendationMin',
'analystRecommendationMax' => 'setAnalystRecommendationMax',
'performanceOneDayMin' => 'setPerformanceOneDayMin',
'performanceOneDayMax' => 'setPerformanceOneDayMax',
'performanceOneWeekMin' => 'setPerformanceOneWeekMin',
'performanceOneWeekMax' => 'setPerformanceOneWeekMax',
'performanceTwoWeeksMin' => 'setPerformanceTwoWeeksMin',
'performanceTwoWeeksMax' => 'setPerformanceTwoWeeksMax',
'performanceOneMonthMin' => 'setPerformanceOneMonthMin',
'performanceOneMonthMax' => 'setPerformanceOneMonthMax',
'performanceThreeMonthsMin' => 'setPerformanceThreeMonthsMin',
'performanceThreeMonthsMax' => 'setPerformanceThreeMonthsMax',
'performanceOneYearMin' => 'setPerformanceOneYearMin',
'performanceOneYearMax' => 'setPerformanceOneYearMax',
'performanceThreeYearsMin' => 'setPerformanceThreeYearsMin',
'performanceThreeYearsMax' => 'setPerformanceThreeYearsMax',
'performanceFiveYearsMin' => 'setPerformanceFiveYearsMin',
'performanceFiveYearsMax' => 'setPerformanceFiveYearsMax',
'performanceTenYearsMin' => 'setPerformanceTenYearsMin',
'performanceTenYearsMax' => 'setPerformanceTenYearsMax',
'performanceTwentyYearsMin' => 'setPerformanceTwentyYearsMin',
'performanceTwentyYearsMax' => 'setPerformanceTwentyYearsMax',
'epsGrowthOneYearMin' => 'setEpsGrowthOneYearMin',
'epsGrowthOneYearMax' => 'setEpsGrowthOneYearMax',
'epsGrowthTwoYearsMin' => 'setEpsGrowthTwoYearsMin',
'epsGrowthTwoYearsMax' => 'setEpsGrowthTwoYearsMax',
'epsGrowthThreeYearsMin' => 'setEpsGrowthThreeYearsMin',
'epsGrowthThreeYearsMax' => 'setEpsGrowthThreeYearsMax',
'epsGrowthFiveYearsMin' => 'setEpsGrowthFiveYearsMin',
'epsGrowthFiveYearsMax' => 'setEpsGrowthFiveYearsMax',
'epsGrowthTenYearsMin' => 'setEpsGrowthTenYearsMin',
'epsGrowthTenYearsMax' => 'setEpsGrowthTenYearsMax',
'epsGrowthTwentyYearsMin' => 'setEpsGrowthTwentyYearsMin',
'epsGrowthTwentyYearsMax' => 'setEpsGrowthTwentyYearsMax',
'peMin' => 'setPeMin',
'peMax' => 'setPeMax',
'pegMin' => 'setPegMin',
'pegMax' => 'setPegMax',
'priceFcfMin' => 'setPriceFcfMin',
'priceFcfMax' => 'setPriceFcfMax',
'bookValuePerShareMin' => 'setBookValuePerShareMin',
'bookValuePerShareMax' => 'setBookValuePerShareMax',
'priceBookValuePerShareMin' => 'setPriceBookValuePerShareMin',
'priceBookValuePerShareMax' => 'setPriceBookValuePerShareMax',
'payoutMin' => 'setPayoutMin',
'payoutMax' => 'setPayoutMax',
'debtToEquityMin' => 'setDebtToEquityMin',
'debtToEquityMax' => 'setDebtToEquityMax',
'grossMarginMin' => 'setGrossMarginMin',
'grossMarginMax' => 'setGrossMarginMax',
'operatingMarginMin' => 'setOperatingMarginMin',
'operatingMarginMax' => 'setOperatingMarginMax',
'profitMarginMin' => 'setProfitMarginMin',
'profitMarginMax' => 'setProfitMarginMax',
'priceToSalesMin' => 'setPriceToSalesMin',
'priceToSalesMax' => 'setPriceToSalesMax',
'buybacksThreeMonthsMin' => 'setBuybacksThreeMonthsMin',
'buybacksThreeMonthsMax' => 'setBuybacksThreeMonthsMax',
'buybacksSixMonthsMin' => 'setBuybacksSixMonthsMin',
'buybacksSixMonthsMax' => 'setBuybacksSixMonthsMax',
'buybacksOneYearMin' => 'setBuybacksOneYearMin',
'buybacksOneYearMax' => 'setBuybacksOneYearMax',
'buybacksTwoYearsMin' => 'setBuybacksTwoYearsMin',
'buybacksTwoYearsMax' => 'setBuybacksTwoYearsMax',
'buybacksThreeYearsMin' => 'setBuybacksThreeYearsMin',
'buybacksThreeYearsMax' => 'setBuybacksThreeYearsMax',
'buybacksFiveYearsMin' => 'setBuybacksFiveYearsMin',
'buybacksFiveYearsMax' => 'setBuybacksFiveYearsMax',
'buybacksTenYearsMin' => 'setBuybacksTenYearsMin',
'buybacksTenYearsMax' => 'setBuybacksTenYearsMax',
'buybacksTwentyYearsMin' => 'setBuybacksTwentyYearsMin',
'buybacksTwentyYearsMax' => 'setBuybacksTwentyYearsMax',
'potentialUpside' => 'setPotentialUpside'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'searchQuery' => 'getSearchQuery',
'exchangeIds' => 'getExchangeIds',
'sectorIds' => 'getSectorIds',
'industryIds' => 'getIndustryIds',
'marketCapMin' => 'getMarketCapMin',
'marketCapMax' => 'getMarketCapMax',
'betaMin' => 'getBetaMin',
'betaMax' => 'getBetaMax',
'forwardDividendMin' => 'getForwardDividendMin',
'forwardDividendMax' => 'getForwardDividendMax',
'forwardDividendYieldMin' => 'getForwardDividendYieldMin',
'forwardDividendYieldMax' => 'getForwardDividendYieldMax',
'shortRatioMin' => 'getShortRatioMin',
'shortRatioMax' => 'getShortRatioMax',
'sharesShortPercentageMin' => 'getSharesShortPercentageMin',
'sharesShortPercentageMax' => 'getSharesShortPercentageMax',
'sharesShortPreviousMonthPercentageMin' => 'getSharesShortPreviousMonthPercentageMin',
'sharesShortPreviousMonthPercentageMax' => 'getSharesShortPreviousMonthPercentageMax',
'analystRecommendationMin' => 'getAnalystRecommendationMin',
'analystRecommendationMax' => 'getAnalystRecommendationMax',
'performanceOneDayMin' => 'getPerformanceOneDayMin',
'performanceOneDayMax' => 'getPerformanceOneDayMax',
'performanceOneWeekMin' => 'getPerformanceOneWeekMin',
'performanceOneWeekMax' => 'getPerformanceOneWeekMax',
'performanceTwoWeeksMin' => 'getPerformanceTwoWeeksMin',
'performanceTwoWeeksMax' => 'getPerformanceTwoWeeksMax',
'performanceOneMonthMin' => 'getPerformanceOneMonthMin',
'performanceOneMonthMax' => 'getPerformanceOneMonthMax',
'performanceThreeMonthsMin' => 'getPerformanceThreeMonthsMin',
'performanceThreeMonthsMax' => 'getPerformanceThreeMonthsMax',
'performanceOneYearMin' => 'getPerformanceOneYearMin',
'performanceOneYearMax' => 'getPerformanceOneYearMax',
'performanceThreeYearsMin' => 'getPerformanceThreeYearsMin',
'performanceThreeYearsMax' => 'getPerformanceThreeYearsMax',
'performanceFiveYearsMin' => 'getPerformanceFiveYearsMin',
'performanceFiveYearsMax' => 'getPerformanceFiveYearsMax',
'performanceTenYearsMin' => 'getPerformanceTenYearsMin',
'performanceTenYearsMax' => 'getPerformanceTenYearsMax',
'performanceTwentyYearsMin' => 'getPerformanceTwentyYearsMin',
'performanceTwentyYearsMax' => 'getPerformanceTwentyYearsMax',
'epsGrowthOneYearMin' => 'getEpsGrowthOneYearMin',
'epsGrowthOneYearMax' => 'getEpsGrowthOneYearMax',
'epsGrowthTwoYearsMin' => 'getEpsGrowthTwoYearsMin',
'epsGrowthTwoYearsMax' => 'getEpsGrowthTwoYearsMax',
'epsGrowthThreeYearsMin' => 'getEpsGrowthThreeYearsMin',
'epsGrowthThreeYearsMax' => 'getEpsGrowthThreeYearsMax',
'epsGrowthFiveYearsMin' => 'getEpsGrowthFiveYearsMin',
'epsGrowthFiveYearsMax' => 'getEpsGrowthFiveYearsMax',
'epsGrowthTenYearsMin' => 'getEpsGrowthTenYearsMin',
'epsGrowthTenYearsMax' => 'getEpsGrowthTenYearsMax',
'epsGrowthTwentyYearsMin' => 'getEpsGrowthTwentyYearsMin',
'epsGrowthTwentyYearsMax' => 'getEpsGrowthTwentyYearsMax',
'peMin' => 'getPeMin',
'peMax' => 'getPeMax',
'pegMin' => 'getPegMin',
'pegMax' => 'getPegMax',
'priceFcfMin' => 'getPriceFcfMin',
'priceFcfMax' => 'getPriceFcfMax',
'bookValuePerShareMin' => 'getBookValuePerShareMin',
'bookValuePerShareMax' => 'getBookValuePerShareMax',
'priceBookValuePerShareMin' => 'getPriceBookValuePerShareMin',
'priceBookValuePerShareMax' => 'getPriceBookValuePerShareMax',
'payoutMin' => 'getPayoutMin',
'payoutMax' => 'getPayoutMax',
'debtToEquityMin' => 'getDebtToEquityMin',
'debtToEquityMax' => 'getDebtToEquityMax',
'grossMarginMin' => 'getGrossMarginMin',
'grossMarginMax' => 'getGrossMarginMax',
'operatingMarginMin' => 'getOperatingMarginMin',
'operatingMarginMax' => 'getOperatingMarginMax',
'profitMarginMin' => 'getProfitMarginMin',
'profitMarginMax' => 'getProfitMarginMax',
'priceToSalesMin' => 'getPriceToSalesMin',
'priceToSalesMax' => 'getPriceToSalesMax',
'buybacksThreeMonthsMin' => 'getBuybacksThreeMonthsMin',
'buybacksThreeMonthsMax' => 'getBuybacksThreeMonthsMax',
'buybacksSixMonthsMin' => 'getBuybacksSixMonthsMin',
'buybacksSixMonthsMax' => 'getBuybacksSixMonthsMax',
'buybacksOneYearMin' => 'getBuybacksOneYearMin',
'buybacksOneYearMax' => 'getBuybacksOneYearMax',
'buybacksTwoYearsMin' => 'getBuybacksTwoYearsMin',
'buybacksTwoYearsMax' => 'getBuybacksTwoYearsMax',
'buybacksThreeYearsMin' => 'getBuybacksThreeYearsMin',
'buybacksThreeYearsMax' => 'getBuybacksThreeYearsMax',
'buybacksFiveYearsMin' => 'getBuybacksFiveYearsMin',
'buybacksFiveYearsMax' => 'getBuybacksFiveYearsMax',
'buybacksTenYearsMin' => 'getBuybacksTenYearsMin',
'buybacksTenYearsMax' => 'getBuybacksTenYearsMax',
'buybacksTwentyYearsMin' => 'getBuybacksTwentyYearsMin',
'buybacksTwentyYearsMax' => 'getBuybacksTwentyYearsMax',
'potentialUpside' => 'getPotentialUpside'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['searchQuery'] = isset($data['searchQuery']) ? $data['searchQuery'] : null;
        $this->container['exchangeIds'] = isset($data['exchangeIds']) ? $data['exchangeIds'] : null;
        $this->container['sectorIds'] = isset($data['sectorIds']) ? $data['sectorIds'] : null;
        $this->container['industryIds'] = isset($data['industryIds']) ? $data['industryIds'] : null;
        $this->container['marketCapMin'] = isset($data['marketCapMin']) ? $data['marketCapMin'] : null;
        $this->container['marketCapMax'] = isset($data['marketCapMax']) ? $data['marketCapMax'] : null;
        $this->container['betaMin'] = isset($data['betaMin']) ? $data['betaMin'] : null;
        $this->container['betaMax'] = isset($data['betaMax']) ? $data['betaMax'] : null;
        $this->container['forwardDividendMin'] = isset($data['forwardDividendMin']) ? $data['forwardDividendMin'] : null;
        $this->container['forwardDividendMax'] = isset($data['forwardDividendMax']) ? $data['forwardDividendMax'] : null;
        $this->container['forwardDividendYieldMin'] = isset($data['forwardDividendYieldMin']) ? $data['forwardDividendYieldMin'] : null;
        $this->container['forwardDividendYieldMax'] = isset($data['forwardDividendYieldMax']) ? $data['forwardDividendYieldMax'] : null;
        $this->container['shortRatioMin'] = isset($data['shortRatioMin']) ? $data['shortRatioMin'] : null;
        $this->container['shortRatioMax'] = isset($data['shortRatioMax']) ? $data['shortRatioMax'] : null;
        $this->container['sharesShortPercentageMin'] = isset($data['sharesShortPercentageMin']) ? $data['sharesShortPercentageMin'] : null;
        $this->container['sharesShortPercentageMax'] = isset($data['sharesShortPercentageMax']) ? $data['sharesShortPercentageMax'] : null;
        $this->container['sharesShortPreviousMonthPercentageMin'] = isset($data['sharesShortPreviousMonthPercentageMin']) ? $data['sharesShortPreviousMonthPercentageMin'] : null;
        $this->container['sharesShortPreviousMonthPercentageMax'] = isset($data['sharesShortPreviousMonthPercentageMax']) ? $data['sharesShortPreviousMonthPercentageMax'] : null;
        $this->container['analystRecommendationMin'] = isset($data['analystRecommendationMin']) ? $data['analystRecommendationMin'] : null;
        $this->container['analystRecommendationMax'] = isset($data['analystRecommendationMax']) ? $data['analystRecommendationMax'] : null;
        $this->container['performanceOneDayMin'] = isset($data['performanceOneDayMin']) ? $data['performanceOneDayMin'] : null;
        $this->container['performanceOneDayMax'] = isset($data['performanceOneDayMax']) ? $data['performanceOneDayMax'] : null;
        $this->container['performanceOneWeekMin'] = isset($data['performanceOneWeekMin']) ? $data['performanceOneWeekMin'] : null;
        $this->container['performanceOneWeekMax'] = isset($data['performanceOneWeekMax']) ? $data['performanceOneWeekMax'] : null;
        $this->container['performanceTwoWeeksMin'] = isset($data['performanceTwoWeeksMin']) ? $data['performanceTwoWeeksMin'] : null;
        $this->container['performanceTwoWeeksMax'] = isset($data['performanceTwoWeeksMax']) ? $data['performanceTwoWeeksMax'] : null;
        $this->container['performanceOneMonthMin'] = isset($data['performanceOneMonthMin']) ? $data['performanceOneMonthMin'] : null;
        $this->container['performanceOneMonthMax'] = isset($data['performanceOneMonthMax']) ? $data['performanceOneMonthMax'] : null;
        $this->container['performanceThreeMonthsMin'] = isset($data['performanceThreeMonthsMin']) ? $data['performanceThreeMonthsMin'] : null;
        $this->container['performanceThreeMonthsMax'] = isset($data['performanceThreeMonthsMax']) ? $data['performanceThreeMonthsMax'] : null;
        $this->container['performanceOneYearMin'] = isset($data['performanceOneYearMin']) ? $data['performanceOneYearMin'] : null;
        $this->container['performanceOneYearMax'] = isset($data['performanceOneYearMax']) ? $data['performanceOneYearMax'] : null;
        $this->container['performanceThreeYearsMin'] = isset($data['performanceThreeYearsMin']) ? $data['performanceThreeYearsMin'] : null;
        $this->container['performanceThreeYearsMax'] = isset($data['performanceThreeYearsMax']) ? $data['performanceThreeYearsMax'] : null;
        $this->container['performanceFiveYearsMin'] = isset($data['performanceFiveYearsMin']) ? $data['performanceFiveYearsMin'] : null;
        $this->container['performanceFiveYearsMax'] = isset($data['performanceFiveYearsMax']) ? $data['performanceFiveYearsMax'] : null;
        $this->container['performanceTenYearsMin'] = isset($data['performanceTenYearsMin']) ? $data['performanceTenYearsMin'] : null;
        $this->container['performanceTenYearsMax'] = isset($data['performanceTenYearsMax']) ? $data['performanceTenYearsMax'] : null;
        $this->container['performanceTwentyYearsMin'] = isset($data['performanceTwentyYearsMin']) ? $data['performanceTwentyYearsMin'] : null;
        $this->container['performanceTwentyYearsMax'] = isset($data['performanceTwentyYearsMax']) ? $data['performanceTwentyYearsMax'] : null;
        $this->container['epsGrowthOneYearMin'] = isset($data['epsGrowthOneYearMin']) ? $data['epsGrowthOneYearMin'] : null;
        $this->container['epsGrowthOneYearMax'] = isset($data['epsGrowthOneYearMax']) ? $data['epsGrowthOneYearMax'] : null;
        $this->container['epsGrowthTwoYearsMin'] = isset($data['epsGrowthTwoYearsMin']) ? $data['epsGrowthTwoYearsMin'] : null;
        $this->container['epsGrowthTwoYearsMax'] = isset($data['epsGrowthTwoYearsMax']) ? $data['epsGrowthTwoYearsMax'] : null;
        $this->container['epsGrowthThreeYearsMin'] = isset($data['epsGrowthThreeYearsMin']) ? $data['epsGrowthThreeYearsMin'] : null;
        $this->container['epsGrowthThreeYearsMax'] = isset($data['epsGrowthThreeYearsMax']) ? $data['epsGrowthThreeYearsMax'] : null;
        $this->container['epsGrowthFiveYearsMin'] = isset($data['epsGrowthFiveYearsMin']) ? $data['epsGrowthFiveYearsMin'] : null;
        $this->container['epsGrowthFiveYearsMax'] = isset($data['epsGrowthFiveYearsMax']) ? $data['epsGrowthFiveYearsMax'] : null;
        $this->container['epsGrowthTenYearsMin'] = isset($data['epsGrowthTenYearsMin']) ? $data['epsGrowthTenYearsMin'] : null;
        $this->container['epsGrowthTenYearsMax'] = isset($data['epsGrowthTenYearsMax']) ? $data['epsGrowthTenYearsMax'] : null;
        $this->container['epsGrowthTwentyYearsMin'] = isset($data['epsGrowthTwentyYearsMin']) ? $data['epsGrowthTwentyYearsMin'] : null;
        $this->container['epsGrowthTwentyYearsMax'] = isset($data['epsGrowthTwentyYearsMax']) ? $data['epsGrowthTwentyYearsMax'] : null;
        $this->container['peMin'] = isset($data['peMin']) ? $data['peMin'] : null;
        $this->container['peMax'] = isset($data['peMax']) ? $data['peMax'] : null;
        $this->container['pegMin'] = isset($data['pegMin']) ? $data['pegMin'] : null;
        $this->container['pegMax'] = isset($data['pegMax']) ? $data['pegMax'] : null;
        $this->container['priceFcfMin'] = isset($data['priceFcfMin']) ? $data['priceFcfMin'] : null;
        $this->container['priceFcfMax'] = isset($data['priceFcfMax']) ? $data['priceFcfMax'] : null;
        $this->container['bookValuePerShareMin'] = isset($data['bookValuePerShareMin']) ? $data['bookValuePerShareMin'] : null;
        $this->container['bookValuePerShareMax'] = isset($data['bookValuePerShareMax']) ? $data['bookValuePerShareMax'] : null;
        $this->container['priceBookValuePerShareMin'] = isset($data['priceBookValuePerShareMin']) ? $data['priceBookValuePerShareMin'] : null;
        $this->container['priceBookValuePerShareMax'] = isset($data['priceBookValuePerShareMax']) ? $data['priceBookValuePerShareMax'] : null;
        $this->container['payoutMin'] = isset($data['payoutMin']) ? $data['payoutMin'] : null;
        $this->container['payoutMax'] = isset($data['payoutMax']) ? $data['payoutMax'] : null;
        $this->container['debtToEquityMin'] = isset($data['debtToEquityMin']) ? $data['debtToEquityMin'] : null;
        $this->container['debtToEquityMax'] = isset($data['debtToEquityMax']) ? $data['debtToEquityMax'] : null;
        $this->container['grossMarginMin'] = isset($data['grossMarginMin']) ? $data['grossMarginMin'] : null;
        $this->container['grossMarginMax'] = isset($data['grossMarginMax']) ? $data['grossMarginMax'] : null;
        $this->container['operatingMarginMin'] = isset($data['operatingMarginMin']) ? $data['operatingMarginMin'] : null;
        $this->container['operatingMarginMax'] = isset($data['operatingMarginMax']) ? $data['operatingMarginMax'] : null;
        $this->container['profitMarginMin'] = isset($data['profitMarginMin']) ? $data['profitMarginMin'] : null;
        $this->container['profitMarginMax'] = isset($data['profitMarginMax']) ? $data['profitMarginMax'] : null;
        $this->container['priceToSalesMin'] = isset($data['priceToSalesMin']) ? $data['priceToSalesMin'] : null;
        $this->container['priceToSalesMax'] = isset($data['priceToSalesMax']) ? $data['priceToSalesMax'] : null;
        $this->container['buybacksThreeMonthsMin'] = isset($data['buybacksThreeMonthsMin']) ? $data['buybacksThreeMonthsMin'] : null;
        $this->container['buybacksThreeMonthsMax'] = isset($data['buybacksThreeMonthsMax']) ? $data['buybacksThreeMonthsMax'] : null;
        $this->container['buybacksSixMonthsMin'] = isset($data['buybacksSixMonthsMin']) ? $data['buybacksSixMonthsMin'] : null;
        $this->container['buybacksSixMonthsMax'] = isset($data['buybacksSixMonthsMax']) ? $data['buybacksSixMonthsMax'] : null;
        $this->container['buybacksOneYearMin'] = isset($data['buybacksOneYearMin']) ? $data['buybacksOneYearMin'] : null;
        $this->container['buybacksOneYearMax'] = isset($data['buybacksOneYearMax']) ? $data['buybacksOneYearMax'] : null;
        $this->container['buybacksTwoYearsMin'] = isset($data['buybacksTwoYearsMin']) ? $data['buybacksTwoYearsMin'] : null;
        $this->container['buybacksTwoYearsMax'] = isset($data['buybacksTwoYearsMax']) ? $data['buybacksTwoYearsMax'] : null;
        $this->container['buybacksThreeYearsMin'] = isset($data['buybacksThreeYearsMin']) ? $data['buybacksThreeYearsMin'] : null;
        $this->container['buybacksThreeYearsMax'] = isset($data['buybacksThreeYearsMax']) ? $data['buybacksThreeYearsMax'] : null;
        $this->container['buybacksFiveYearsMin'] = isset($data['buybacksFiveYearsMin']) ? $data['buybacksFiveYearsMin'] : null;
        $this->container['buybacksFiveYearsMax'] = isset($data['buybacksFiveYearsMax']) ? $data['buybacksFiveYearsMax'] : null;
        $this->container['buybacksTenYearsMin'] = isset($data['buybacksTenYearsMin']) ? $data['buybacksTenYearsMin'] : null;
        $this->container['buybacksTenYearsMax'] = isset($data['buybacksTenYearsMax']) ? $data['buybacksTenYearsMax'] : null;
        $this->container['buybacksTwentyYearsMin'] = isset($data['buybacksTwentyYearsMin']) ? $data['buybacksTwentyYearsMin'] : null;
        $this->container['buybacksTwentyYearsMax'] = isset($data['buybacksTwentyYearsMax']) ? $data['buybacksTwentyYearsMax'] : null;
        $this->container['potentialUpside'] = isset($data['potentialUpside']) ? $data['potentialUpside'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets searchQuery
     *
     * @return string
     */
    public function getSearchQuery()
    {
        return $this->container['searchQuery'];
    }

    /**
     * Sets searchQuery
     *
     * @param string $searchQuery A textual search term.
     *
     * @return $this
     */
    public function setSearchQuery($searchQuery)
    {
        $this->container['searchQuery'] = $searchQuery;

        return $this;
    }

    /**
     * Gets exchangeIds
     *
     * @return int[]
     */
    public function getExchangeIds()
    {
        return $this->container['exchangeIds'];
    }

    /**
     * Sets exchangeIds
     *
     * @param int[] $exchangeIds The ids of the exchanges to use.
     *
     * @return $this
     */
    public function setExchangeIds($exchangeIds)
    {
        $this->container['exchangeIds'] = $exchangeIds;

        return $this;
    }

    /**
     * Gets sectorIds
     *
     * @return int[]
     */
    public function getSectorIds()
    {
        return $this->container['sectorIds'];
    }

    /**
     * Sets sectorIds
     *
     * @param int[] $sectorIds The ids of the sectors to use.
     *
     * @return $this
     */
    public function setSectorIds($sectorIds)
    {
        $this->container['sectorIds'] = $sectorIds;

        return $this;
    }

    /**
     * Gets industryIds
     *
     * @return int[]
     */
    public function getIndustryIds()
    {
        return $this->container['industryIds'];
    }

    /**
     * Sets industryIds
     *
     * @param int[] $industryIds The ids of the industries to use.
     *
     * @return $this
     */
    public function setIndustryIds($industryIds)
    {
        $this->container['industryIds'] = $industryIds;

        return $this;
    }

    /**
     * Gets marketCapMin
     *
     * @return double
     */
    public function getMarketCapMin()
    {
        return $this->container['marketCapMin'];
    }

    /**
     * Sets marketCapMin
     *
     * @param double $marketCapMin The minimum market capitalization.
     *
     * @return $this
     */
    public function setMarketCapMin($marketCapMin)
    {
        $this->container['marketCapMin'] = $marketCapMin;

        return $this;
    }

    /**
     * Gets marketCapMax
     *
     * @return double
     */
    public function getMarketCapMax()
    {
        return $this->container['marketCapMax'];
    }

    /**
     * Sets marketCapMax
     *
     * @param double $marketCapMax The maximum market capitalization.
     *
     * @return $this
     */
    public function setMarketCapMax($marketCapMax)
    {
        $this->container['marketCapMax'] = $marketCapMax;

        return $this;
    }

    /**
     * Gets betaMin
     *
     * @return double
     */
    public function getBetaMin()
    {
        return $this->container['betaMin'];
    }

    /**
     * Sets betaMin
     *
     * @param double $betaMin The minimum price beta for a 5 year period calculated monthly.
     *
     * @return $this
     */
    public function setBetaMin($betaMin)
    {
        $this->container['betaMin'] = $betaMin;

        return $this;
    }

    /**
     * Gets betaMax
     *
     * @return double
     */
    public function getBetaMax()
    {
        return $this->container['betaMax'];
    }

    /**
     * Sets betaMax
     *
     * @param double $betaMax The maximum price beta for a 5 year period calculated monthly.
     *
     * @return $this
     */
    public function setBetaMax($betaMax)
    {
        $this->container['betaMax'] = $betaMax;

        return $this;
    }

    /**
     * Gets forwardDividendMin
     *
     * @return double
     */
    public function getForwardDividendMin()
    {
        return $this->container['forwardDividendMin'];
    }

    /**
     * Sets forwardDividendMin
     *
     * @param double $forwardDividendMin The minimum current dividend value.
     *
     * @return $this
     */
    public function setForwardDividendMin($forwardDividendMin)
    {
        $this->container['forwardDividendMin'] = $forwardDividendMin;

        return $this;
    }

    /**
     * Gets forwardDividendMax
     *
     * @return double
     */
    public function getForwardDividendMax()
    {
        return $this->container['forwardDividendMax'];
    }

    /**
     * Sets forwardDividendMax
     *
     * @param double $forwardDividendMax The maximum current dividend value.
     *
     * @return $this
     */
    public function setForwardDividendMax($forwardDividendMax)
    {
        $this->container['forwardDividendMax'] = $forwardDividendMax;

        return $this;
    }

    /**
     * Gets forwardDividendYieldMin
     *
     * @return double
     */
    public function getForwardDividendYieldMin()
    {
        return $this->container['forwardDividendYieldMin'];
    }

    /**
     * Sets forwardDividendYieldMin
     *
     * @param double $forwardDividendYieldMin The minimum current dividend percentage.
     *
     * @return $this
     */
    public function setForwardDividendYieldMin($forwardDividendYieldMin)
    {
        $this->container['forwardDividendYieldMin'] = $forwardDividendYieldMin;

        return $this;
    }

    /**
     * Gets forwardDividendYieldMax
     *
     * @return double
     */
    public function getForwardDividendYieldMax()
    {
        return $this->container['forwardDividendYieldMax'];
    }

    /**
     * Sets forwardDividendYieldMax
     *
     * @param double $forwardDividendYieldMax The maximum current dividend percentage.
     *
     * @return $this
     */
    public function setForwardDividendYieldMax($forwardDividendYieldMax)
    {
        $this->container['forwardDividendYieldMax'] = $forwardDividendYieldMax;

        return $this;
    }

    /**
     * Gets shortRatioMin
     *
     * @return double
     */
    public function getShortRatioMin()
    {
        return $this->container['shortRatioMin'];
    }

    /**
     * Sets shortRatioMin
     *
     * @param double $shortRatioMin The minimum short ratio.
     *
     * @return $this
     */
    public function setShortRatioMin($shortRatioMin)
    {
        $this->container['shortRatioMin'] = $shortRatioMin;

        return $this;
    }

    /**
     * Gets shortRatioMax
     *
     * @return double
     */
    public function getShortRatioMax()
    {
        return $this->container['shortRatioMax'];
    }

    /**
     * Sets shortRatioMax
     *
     * @param double $shortRatioMax The maximum short ratio.
     *
     * @return $this
     */
    public function setShortRatioMax($shortRatioMax)
    {
        $this->container['shortRatioMax'] = $shortRatioMax;

        return $this;
    }

    /**
     * Gets sharesShortPercentageMin
     *
     * @return double
     */
    public function getSharesShortPercentageMin()
    {
        return $this->container['sharesShortPercentageMin'];
    }

    /**
     * Sets sharesShortPercentageMin
     *
     * @param double $sharesShortPercentageMin The minimum percentage of shares short.
     *
     * @return $this
     */
    public function setSharesShortPercentageMin($sharesShortPercentageMin)
    {
        $this->container['sharesShortPercentageMin'] = $sharesShortPercentageMin;

        return $this;
    }

    /**
     * Gets sharesShortPercentageMax
     *
     * @return double
     */
    public function getSharesShortPercentageMax()
    {
        return $this->container['sharesShortPercentageMax'];
    }

    /**
     * Sets sharesShortPercentageMax
     *
     * @param double $sharesShortPercentageMax The maximum percentage of shares short.
     *
     * @return $this
     */
    public function setSharesShortPercentageMax($sharesShortPercentageMax)
    {
        $this->container['sharesShortPercentageMax'] = $sharesShortPercentageMax;

        return $this;
    }

    /**
     * Gets sharesShortPreviousMonthPercentageMin
     *
     * @return double
     */
    public function getSharesShortPreviousMonthPercentageMin()
    {
        return $this->container['sharesShortPreviousMonthPercentageMin'];
    }

    /**
     * Sets sharesShortPreviousMonthPercentageMin
     *
     * @param double $sharesShortPreviousMonthPercentageMin The minimum percentage of shares short on the last month.
     *
     * @return $this
     */
    public function setSharesShortPreviousMonthPercentageMin($sharesShortPreviousMonthPercentageMin)
    {
        $this->container['sharesShortPreviousMonthPercentageMin'] = $sharesShortPreviousMonthPercentageMin;

        return $this;
    }

    /**
     * Gets sharesShortPreviousMonthPercentageMax
     *
     * @return double
     */
    public function getSharesShortPreviousMonthPercentageMax()
    {
        return $this->container['sharesShortPreviousMonthPercentageMax'];
    }

    /**
     * Sets sharesShortPreviousMonthPercentageMax
     *
     * @param double $sharesShortPreviousMonthPercentageMax The maximum percentage of shares short on the last month.
     *
     * @return $this
     */
    public function setSharesShortPreviousMonthPercentageMax($sharesShortPreviousMonthPercentageMax)
    {
        $this->container['sharesShortPreviousMonthPercentageMax'] = $sharesShortPreviousMonthPercentageMax;

        return $this;
    }

    /**
     * Gets analystRecommendationMin
     *
     * @return \EquiblesStocks\Models\Recommendation
     */
    public function getAnalystRecommendationMin()
    {
        return $this->container['analystRecommendationMin'];
    }

    /**
     * Sets analystRecommendationMin
     *
     * @param \EquiblesStocks\Models\Recommendation $analystRecommendationMin analystRecommendationMin
     *
     * @return $this
     */
    public function setAnalystRecommendationMin($analystRecommendationMin)
    {
        $this->container['analystRecommendationMin'] = $analystRecommendationMin;

        return $this;
    }

    /**
     * Gets analystRecommendationMax
     *
     * @return \EquiblesStocks\Models\Recommendation
     */
    public function getAnalystRecommendationMax()
    {
        return $this->container['analystRecommendationMax'];
    }

    /**
     * Sets analystRecommendationMax
     *
     * @param \EquiblesStocks\Models\Recommendation $analystRecommendationMax analystRecommendationMax
     *
     * @return $this
     */
    public function setAnalystRecommendationMax($analystRecommendationMax)
    {
        $this->container['analystRecommendationMax'] = $analystRecommendationMax;

        return $this;
    }

    /**
     * Gets performanceOneDayMin
     *
     * @return double
     */
    public function getPerformanceOneDayMin()
    {
        return $this->container['performanceOneDayMin'];
    }

    /**
     * Sets performanceOneDayMin
     *
     * @param double $performanceOneDayMin The minimum stock price percentage change in the last day.
     *
     * @return $this
     */
    public function setPerformanceOneDayMin($performanceOneDayMin)
    {
        $this->container['performanceOneDayMin'] = $performanceOneDayMin;

        return $this;
    }

    /**
     * Gets performanceOneDayMax
     *
     * @return double
     */
    public function getPerformanceOneDayMax()
    {
        return $this->container['performanceOneDayMax'];
    }

    /**
     * Sets performanceOneDayMax
     *
     * @param double $performanceOneDayMax The maximum stock price percentage change in the last day.
     *
     * @return $this
     */
    public function setPerformanceOneDayMax($performanceOneDayMax)
    {
        $this->container['performanceOneDayMax'] = $performanceOneDayMax;

        return $this;
    }

    /**
     * Gets performanceOneWeekMin
     *
     * @return double
     */
    public function getPerformanceOneWeekMin()
    {
        return $this->container['performanceOneWeekMin'];
    }

    /**
     * Sets performanceOneWeekMin
     *
     * @param double $performanceOneWeekMin The minimum stock price percentage change in the last week.
     *
     * @return $this
     */
    public function setPerformanceOneWeekMin($performanceOneWeekMin)
    {
        $this->container['performanceOneWeekMin'] = $performanceOneWeekMin;

        return $this;
    }

    /**
     * Gets performanceOneWeekMax
     *
     * @return double
     */
    public function getPerformanceOneWeekMax()
    {
        return $this->container['performanceOneWeekMax'];
    }

    /**
     * Sets performanceOneWeekMax
     *
     * @param double $performanceOneWeekMax The maximum stock price percentage change in the last week.
     *
     * @return $this
     */
    public function setPerformanceOneWeekMax($performanceOneWeekMax)
    {
        $this->container['performanceOneWeekMax'] = $performanceOneWeekMax;

        return $this;
    }

    /**
     * Gets performanceTwoWeeksMin
     *
     * @return double
     */
    public function getPerformanceTwoWeeksMin()
    {
        return $this->container['performanceTwoWeeksMin'];
    }

    /**
     * Sets performanceTwoWeeksMin
     *
     * @param double $performanceTwoWeeksMin The minimum stock price percentage change in the last two weeks.
     *
     * @return $this
     */
    public function setPerformanceTwoWeeksMin($performanceTwoWeeksMin)
    {
        $this->container['performanceTwoWeeksMin'] = $performanceTwoWeeksMin;

        return $this;
    }

    /**
     * Gets performanceTwoWeeksMax
     *
     * @return double
     */
    public function getPerformanceTwoWeeksMax()
    {
        return $this->container['performanceTwoWeeksMax'];
    }

    /**
     * Sets performanceTwoWeeksMax
     *
     * @param double $performanceTwoWeeksMax The maximum stock price percentage change in the last two weeks.
     *
     * @return $this
     */
    public function setPerformanceTwoWeeksMax($performanceTwoWeeksMax)
    {
        $this->container['performanceTwoWeeksMax'] = $performanceTwoWeeksMax;

        return $this;
    }

    /**
     * Gets performanceOneMonthMin
     *
     * @return double
     */
    public function getPerformanceOneMonthMin()
    {
        return $this->container['performanceOneMonthMin'];
    }

    /**
     * Sets performanceOneMonthMin
     *
     * @param double $performanceOneMonthMin The minimum stock price percentage change in the last month.
     *
     * @return $this
     */
    public function setPerformanceOneMonthMin($performanceOneMonthMin)
    {
        $this->container['performanceOneMonthMin'] = $performanceOneMonthMin;

        return $this;
    }

    /**
     * Gets performanceOneMonthMax
     *
     * @return double
     */
    public function getPerformanceOneMonthMax()
    {
        return $this->container['performanceOneMonthMax'];
    }

    /**
     * Sets performanceOneMonthMax
     *
     * @param double $performanceOneMonthMax The maximum stock price percentage change in the last month.
     *
     * @return $this
     */
    public function setPerformanceOneMonthMax($performanceOneMonthMax)
    {
        $this->container['performanceOneMonthMax'] = $performanceOneMonthMax;

        return $this;
    }

    /**
     * Gets performanceThreeMonthsMin
     *
     * @return double
     */
    public function getPerformanceThreeMonthsMin()
    {
        return $this->container['performanceThreeMonthsMin'];
    }

    /**
     * Sets performanceThreeMonthsMin
     *
     * @param double $performanceThreeMonthsMin The minimum stock price percentage change in the last three months.
     *
     * @return $this
     */
    public function setPerformanceThreeMonthsMin($performanceThreeMonthsMin)
    {
        $this->container['performanceThreeMonthsMin'] = $performanceThreeMonthsMin;

        return $this;
    }

    /**
     * Gets performanceThreeMonthsMax
     *
     * @return double
     */
    public function getPerformanceThreeMonthsMax()
    {
        return $this->container['performanceThreeMonthsMax'];
    }

    /**
     * Sets performanceThreeMonthsMax
     *
     * @param double $performanceThreeMonthsMax The maximum stock price percentage change in the last three months.
     *
     * @return $this
     */
    public function setPerformanceThreeMonthsMax($performanceThreeMonthsMax)
    {
        $this->container['performanceThreeMonthsMax'] = $performanceThreeMonthsMax;

        return $this;
    }

    /**
     * Gets performanceOneYearMin
     *
     * @return double
     */
    public function getPerformanceOneYearMin()
    {
        return $this->container['performanceOneYearMin'];
    }

    /**
     * Sets performanceOneYearMin
     *
     * @param double $performanceOneYearMin The minimum stock price percentage change in the last year.
     *
     * @return $this
     */
    public function setPerformanceOneYearMin($performanceOneYearMin)
    {
        $this->container['performanceOneYearMin'] = $performanceOneYearMin;

        return $this;
    }

    /**
     * Gets performanceOneYearMax
     *
     * @return double
     */
    public function getPerformanceOneYearMax()
    {
        return $this->container['performanceOneYearMax'];
    }

    /**
     * Sets performanceOneYearMax
     *
     * @param double $performanceOneYearMax The maximum stock price percentage change in the last year.
     *
     * @return $this
     */
    public function setPerformanceOneYearMax($performanceOneYearMax)
    {
        $this->container['performanceOneYearMax'] = $performanceOneYearMax;

        return $this;
    }

    /**
     * Gets performanceThreeYearsMin
     *
     * @return double
     */
    public function getPerformanceThreeYearsMin()
    {
        return $this->container['performanceThreeYearsMin'];
    }

    /**
     * Sets performanceThreeYearsMin
     *
     * @param double $performanceThreeYearsMin The minimum stock price percentage change in the last three years.
     *
     * @return $this
     */
    public function setPerformanceThreeYearsMin($performanceThreeYearsMin)
    {
        $this->container['performanceThreeYearsMin'] = $performanceThreeYearsMin;

        return $this;
    }

    /**
     * Gets performanceThreeYearsMax
     *
     * @return double
     */
    public function getPerformanceThreeYearsMax()
    {
        return $this->container['performanceThreeYearsMax'];
    }

    /**
     * Sets performanceThreeYearsMax
     *
     * @param double $performanceThreeYearsMax The maximum stock price percentage change in the last three years.
     *
     * @return $this
     */
    public function setPerformanceThreeYearsMax($performanceThreeYearsMax)
    {
        $this->container['performanceThreeYearsMax'] = $performanceThreeYearsMax;

        return $this;
    }

    /**
     * Gets performanceFiveYearsMin
     *
     * @return double
     */
    public function getPerformanceFiveYearsMin()
    {
        return $this->container['performanceFiveYearsMin'];
    }

    /**
     * Sets performanceFiveYearsMin
     *
     * @param double $performanceFiveYearsMin The minimum stock price percentage change in the last five years.
     *
     * @return $this
     */
    public function setPerformanceFiveYearsMin($performanceFiveYearsMin)
    {
        $this->container['performanceFiveYearsMin'] = $performanceFiveYearsMin;

        return $this;
    }

    /**
     * Gets performanceFiveYearsMax
     *
     * @return double
     */
    public function getPerformanceFiveYearsMax()
    {
        return $this->container['performanceFiveYearsMax'];
    }

    /**
     * Sets performanceFiveYearsMax
     *
     * @param double $performanceFiveYearsMax The maximum stock price percentage change in the last five years.
     *
     * @return $this
     */
    public function setPerformanceFiveYearsMax($performanceFiveYearsMax)
    {
        $this->container['performanceFiveYearsMax'] = $performanceFiveYearsMax;

        return $this;
    }

    /**
     * Gets performanceTenYearsMin
     *
     * @return double
     */
    public function getPerformanceTenYearsMin()
    {
        return $this->container['performanceTenYearsMin'];
    }

    /**
     * Sets performanceTenYearsMin
     *
     * @param double $performanceTenYearsMin The minimum stock price percentage change in the last ten years.
     *
     * @return $this
     */
    public function setPerformanceTenYearsMin($performanceTenYearsMin)
    {
        $this->container['performanceTenYearsMin'] = $performanceTenYearsMin;

        return $this;
    }

    /**
     * Gets performanceTenYearsMax
     *
     * @return double
     */
    public function getPerformanceTenYearsMax()
    {
        return $this->container['performanceTenYearsMax'];
    }

    /**
     * Sets performanceTenYearsMax
     *
     * @param double $performanceTenYearsMax The maximum stock price percentage change in the last ten years.
     *
     * @return $this
     */
    public function setPerformanceTenYearsMax($performanceTenYearsMax)
    {
        $this->container['performanceTenYearsMax'] = $performanceTenYearsMax;

        return $this;
    }

    /**
     * Gets performanceTwentyYearsMin
     *
     * @return double
     */
    public function getPerformanceTwentyYearsMin()
    {
        return $this->container['performanceTwentyYearsMin'];
    }

    /**
     * Sets performanceTwentyYearsMin
     *
     * @param double $performanceTwentyYearsMin The minimum stock price percentage change in the last twenty years.
     *
     * @return $this
     */
    public function setPerformanceTwentyYearsMin($performanceTwentyYearsMin)
    {
        $this->container['performanceTwentyYearsMin'] = $performanceTwentyYearsMin;

        return $this;
    }

    /**
     * Gets performanceTwentyYearsMax
     *
     * @return double
     */
    public function getPerformanceTwentyYearsMax()
    {
        return $this->container['performanceTwentyYearsMax'];
    }

    /**
     * Sets performanceTwentyYearsMax
     *
     * @param double $performanceTwentyYearsMax The maximum stock price percentage change in the last twenty years.
     *
     * @return $this
     */
    public function setPerformanceTwentyYearsMax($performanceTwentyYearsMax)
    {
        $this->container['performanceTwentyYearsMax'] = $performanceTwentyYearsMax;

        return $this;
    }

    /**
     * Gets epsGrowthOneYearMin
     *
     * @return double
     */
    public function getEpsGrowthOneYearMin()
    {
        return $this->container['epsGrowthOneYearMin'];
    }

    /**
     * Sets epsGrowthOneYearMin
     *
     * @param double $epsGrowthOneYearMin The minimum EPS growth in the last year.
     *
     * @return $this
     */
    public function setEpsGrowthOneYearMin($epsGrowthOneYearMin)
    {
        $this->container['epsGrowthOneYearMin'] = $epsGrowthOneYearMin;

        return $this;
    }

    /**
     * Gets epsGrowthOneYearMax
     *
     * @return double
     */
    public function getEpsGrowthOneYearMax()
    {
        return $this->container['epsGrowthOneYearMax'];
    }

    /**
     * Sets epsGrowthOneYearMax
     *
     * @param double $epsGrowthOneYearMax The maximum EPS growth in the last year.
     *
     * @return $this
     */
    public function setEpsGrowthOneYearMax($epsGrowthOneYearMax)
    {
        $this->container['epsGrowthOneYearMax'] = $epsGrowthOneYearMax;

        return $this;
    }

    /**
     * Gets epsGrowthTwoYearsMin
     *
     * @return double
     */
    public function getEpsGrowthTwoYearsMin()
    {
        return $this->container['epsGrowthTwoYearsMin'];
    }

    /**
     * Sets epsGrowthTwoYearsMin
     *
     * @param double $epsGrowthTwoYearsMin The minimum EPS growth in the last two years. This value is annualized.
     *
     * @return $this
     */
    public function setEpsGrowthTwoYearsMin($epsGrowthTwoYearsMin)
    {
        $this->container['epsGrowthTwoYearsMin'] = $epsGrowthTwoYearsMin;

        return $this;
    }

    /**
     * Gets epsGrowthTwoYearsMax
     *
     * @return double
     */
    public function getEpsGrowthTwoYearsMax()
    {
        return $this->container['epsGrowthTwoYearsMax'];
    }

    /**
     * Sets epsGrowthTwoYearsMax
     *
     * @param double $epsGrowthTwoYearsMax The maximum EPS growth in the last two years. This value is annualized.
     *
     * @return $this
     */
    public function setEpsGrowthTwoYearsMax($epsGrowthTwoYearsMax)
    {
        $this->container['epsGrowthTwoYearsMax'] = $epsGrowthTwoYearsMax;

        return $this;
    }

    /**
     * Gets epsGrowthThreeYearsMin
     *
     * @return double
     */
    public function getEpsGrowthThreeYearsMin()
    {
        return $this->container['epsGrowthThreeYearsMin'];
    }

    /**
     * Sets epsGrowthThreeYearsMin
     *
     * @param double $epsGrowthThreeYearsMin The minimum EPS growth in the last three years. This value is annualized.
     *
     * @return $this
     */
    public function setEpsGrowthThreeYearsMin($epsGrowthThreeYearsMin)
    {
        $this->container['epsGrowthThreeYearsMin'] = $epsGrowthThreeYearsMin;

        return $this;
    }

    /**
     * Gets epsGrowthThreeYearsMax
     *
     * @return double
     */
    public function getEpsGrowthThreeYearsMax()
    {
        return $this->container['epsGrowthThreeYearsMax'];
    }

    /**
     * Sets epsGrowthThreeYearsMax
     *
     * @param double $epsGrowthThreeYearsMax The maximum EPS growth in the last three years. This value is annualized.
     *
     * @return $this
     */
    public function setEpsGrowthThreeYearsMax($epsGrowthThreeYearsMax)
    {
        $this->container['epsGrowthThreeYearsMax'] = $epsGrowthThreeYearsMax;

        return $this;
    }

    /**
     * Gets epsGrowthFiveYearsMin
     *
     * @return double
     */
    public function getEpsGrowthFiveYearsMin()
    {
        return $this->container['epsGrowthFiveYearsMin'];
    }

    /**
     * Sets epsGrowthFiveYearsMin
     *
     * @param double $epsGrowthFiveYearsMin The minimum EPS growth in the last five years. This value is annualized.
     *
     * @return $this
     */
    public function setEpsGrowthFiveYearsMin($epsGrowthFiveYearsMin)
    {
        $this->container['epsGrowthFiveYearsMin'] = $epsGrowthFiveYearsMin;

        return $this;
    }

    /**
     * Gets epsGrowthFiveYearsMax
     *
     * @return double
     */
    public function getEpsGrowthFiveYearsMax()
    {
        return $this->container['epsGrowthFiveYearsMax'];
    }

    /**
     * Sets epsGrowthFiveYearsMax
     *
     * @param double $epsGrowthFiveYearsMax The maximum EPS growth in the last five years. This value is annualized.
     *
     * @return $this
     */
    public function setEpsGrowthFiveYearsMax($epsGrowthFiveYearsMax)
    {
        $this->container['epsGrowthFiveYearsMax'] = $epsGrowthFiveYearsMax;

        return $this;
    }

    /**
     * Gets epsGrowthTenYearsMin
     *
     * @return double
     */
    public function getEpsGrowthTenYearsMin()
    {
        return $this->container['epsGrowthTenYearsMin'];
    }

    /**
     * Sets epsGrowthTenYearsMin
     *
     * @param double $epsGrowthTenYearsMin The minimum EPS growth in the last ten years. This value is annualized.
     *
     * @return $this
     */
    public function setEpsGrowthTenYearsMin($epsGrowthTenYearsMin)
    {
        $this->container['epsGrowthTenYearsMin'] = $epsGrowthTenYearsMin;

        return $this;
    }

    /**
     * Gets epsGrowthTenYearsMax
     *
     * @return double
     */
    public function getEpsGrowthTenYearsMax()
    {
        return $this->container['epsGrowthTenYearsMax'];
    }

    /**
     * Sets epsGrowthTenYearsMax
     *
     * @param double $epsGrowthTenYearsMax The maximum EPS growth in the last ten years. This value is annualized.
     *
     * @return $this
     */
    public function setEpsGrowthTenYearsMax($epsGrowthTenYearsMax)
    {
        $this->container['epsGrowthTenYearsMax'] = $epsGrowthTenYearsMax;

        return $this;
    }

    /**
     * Gets epsGrowthTwentyYearsMin
     *
     * @return double
     */
    public function getEpsGrowthTwentyYearsMin()
    {
        return $this->container['epsGrowthTwentyYearsMin'];
    }

    /**
     * Sets epsGrowthTwentyYearsMin
     *
     * @param double $epsGrowthTwentyYearsMin The minimum EPS growth in the last twenty years. This value is annualized.
     *
     * @return $this
     */
    public function setEpsGrowthTwentyYearsMin($epsGrowthTwentyYearsMin)
    {
        $this->container['epsGrowthTwentyYearsMin'] = $epsGrowthTwentyYearsMin;

        return $this;
    }

    /**
     * Gets epsGrowthTwentyYearsMax
     *
     * @return double
     */
    public function getEpsGrowthTwentyYearsMax()
    {
        return $this->container['epsGrowthTwentyYearsMax'];
    }

    /**
     * Sets epsGrowthTwentyYearsMax
     *
     * @param double $epsGrowthTwentyYearsMax The maximum EPS growth in the last twenty years. This value is annualized.
     *
     * @return $this
     */
    public function setEpsGrowthTwentyYearsMax($epsGrowthTwentyYearsMax)
    {
        $this->container['epsGrowthTwentyYearsMax'] = $epsGrowthTwentyYearsMax;

        return $this;
    }

    /**
     * Gets peMin
     *
     * @return double
     */
    public function getPeMin()
    {
        return $this->container['peMin'];
    }

    /**
     * Sets peMin
     *
     * @param double $peMin The minimum price to earnings value.
     *
     * @return $this
     */
    public function setPeMin($peMin)
    {
        $this->container['peMin'] = $peMin;

        return $this;
    }

    /**
     * Gets peMax
     *
     * @return double
     */
    public function getPeMax()
    {
        return $this->container['peMax'];
    }

    /**
     * Sets peMax
     *
     * @param double $peMax The maximum price to earnings value.
     *
     * @return $this
     */
    public function setPeMax($peMax)
    {
        $this->container['peMax'] = $peMax;

        return $this;
    }

    /**
     * Gets pegMin
     *
     * @return double
     */
    public function getPegMin()
    {
        return $this->container['pegMin'];
    }

    /**
     * Sets pegMin
     *
     * @param double $pegMin The minimum price to earnings to growth value.
     *
     * @return $this
     */
    public function setPegMin($pegMin)
    {
        $this->container['pegMin'] = $pegMin;

        return $this;
    }

    /**
     * Gets pegMax
     *
     * @return double
     */
    public function getPegMax()
    {
        return $this->container['pegMax'];
    }

    /**
     * Sets pegMax
     *
     * @param double $pegMax The maximum price to earnings to growth value.
     *
     * @return $this
     */
    public function setPegMax($pegMax)
    {
        $this->container['pegMax'] = $pegMax;

        return $this;
    }

    /**
     * Gets priceFcfMin
     *
     * @return double
     */
    public function getPriceFcfMin()
    {
        return $this->container['priceFcfMin'];
    }

    /**
     * Sets priceFcfMin
     *
     * @param double $priceFcfMin The minimum price to free cash flow value.
     *
     * @return $this
     */
    public function setPriceFcfMin($priceFcfMin)
    {
        $this->container['priceFcfMin'] = $priceFcfMin;

        return $this;
    }

    /**
     * Gets priceFcfMax
     *
     * @return double
     */
    public function getPriceFcfMax()
    {
        return $this->container['priceFcfMax'];
    }

    /**
     * Sets priceFcfMax
     *
     * @param double $priceFcfMax The maximum price to free cash flow value.
     *
     * @return $this
     */
    public function setPriceFcfMax($priceFcfMax)
    {
        $this->container['priceFcfMax'] = $priceFcfMax;

        return $this;
    }

    /**
     * Gets bookValuePerShareMin
     *
     * @return double
     */
    public function getBookValuePerShareMin()
    {
        return $this->container['bookValuePerShareMin'];
    }

    /**
     * Sets bookValuePerShareMin
     *
     * @param double $bookValuePerShareMin The minimum book value per share.
     *
     * @return $this
     */
    public function setBookValuePerShareMin($bookValuePerShareMin)
    {
        $this->container['bookValuePerShareMin'] = $bookValuePerShareMin;

        return $this;
    }

    /**
     * Gets bookValuePerShareMax
     *
     * @return double
     */
    public function getBookValuePerShareMax()
    {
        return $this->container['bookValuePerShareMax'];
    }

    /**
     * Sets bookValuePerShareMax
     *
     * @param double $bookValuePerShareMax The maximum book value per share.
     *
     * @return $this
     */
    public function setBookValuePerShareMax($bookValuePerShareMax)
    {
        $this->container['bookValuePerShareMax'] = $bookValuePerShareMax;

        return $this;
    }

    /**
     * Gets priceBookValuePerShareMin
     *
     * @return double
     */
    public function getPriceBookValuePerShareMin()
    {
        return $this->container['priceBookValuePerShareMin'];
    }

    /**
     * Sets priceBookValuePerShareMin
     *
     * @param double $priceBookValuePerShareMin The minimum price to book value.
     *
     * @return $this
     */
    public function setPriceBookValuePerShareMin($priceBookValuePerShareMin)
    {
        $this->container['priceBookValuePerShareMin'] = $priceBookValuePerShareMin;

        return $this;
    }

    /**
     * Gets priceBookValuePerShareMax
     *
     * @return double
     */
    public function getPriceBookValuePerShareMax()
    {
        return $this->container['priceBookValuePerShareMax'];
    }

    /**
     * Sets priceBookValuePerShareMax
     *
     * @param double $priceBookValuePerShareMax The maximum price to book value.
     *
     * @return $this
     */
    public function setPriceBookValuePerShareMax($priceBookValuePerShareMax)
    {
        $this->container['priceBookValuePerShareMax'] = $priceBookValuePerShareMax;

        return $this;
    }

    /**
     * Gets payoutMin
     *
     * @return double
     */
    public function getPayoutMin()
    {
        return $this->container['payoutMin'];
    }

    /**
     * Sets payoutMin
     *
     * @param double $payoutMin The minimum payout ratio (as percentage).
     *
     * @return $this
     */
    public function setPayoutMin($payoutMin)
    {
        $this->container['payoutMin'] = $payoutMin;

        return $this;
    }

    /**
     * Gets payoutMax
     *
     * @return double
     */
    public function getPayoutMax()
    {
        return $this->container['payoutMax'];
    }

    /**
     * Sets payoutMax
     *
     * @param double $payoutMax The maximum payout ratio (as percentage).
     *
     * @return $this
     */
    public function setPayoutMax($payoutMax)
    {
        $this->container['payoutMax'] = $payoutMax;

        return $this;
    }

    /**
     * Gets debtToEquityMin
     *
     * @return double
     */
    public function getDebtToEquityMin()
    {
        return $this->container['debtToEquityMin'];
    }

    /**
     * Sets debtToEquityMin
     *
     * @param double $debtToEquityMin The minimum debt to equity ratio (as percentage).
     *
     * @return $this
     */
    public function setDebtToEquityMin($debtToEquityMin)
    {
        $this->container['debtToEquityMin'] = $debtToEquityMin;

        return $this;
    }

    /**
     * Gets debtToEquityMax
     *
     * @return double
     */
    public function getDebtToEquityMax()
    {
        return $this->container['debtToEquityMax'];
    }

    /**
     * Sets debtToEquityMax
     *
     * @param double $debtToEquityMax The maximum debt to equity ratio (as percentage).
     *
     * @return $this
     */
    public function setDebtToEquityMax($debtToEquityMax)
    {
        $this->container['debtToEquityMax'] = $debtToEquityMax;

        return $this;
    }

    /**
     * Gets grossMarginMin
     *
     * @return double
     */
    public function getGrossMarginMin()
    {
        return $this->container['grossMarginMin'];
    }

    /**
     * Sets grossMarginMin
     *
     * @param double $grossMarginMin The minimum gross margin (as percentage).
     *
     * @return $this
     */
    public function setGrossMarginMin($grossMarginMin)
    {
        $this->container['grossMarginMin'] = $grossMarginMin;

        return $this;
    }

    /**
     * Gets grossMarginMax
     *
     * @return double
     */
    public function getGrossMarginMax()
    {
        return $this->container['grossMarginMax'];
    }

    /**
     * Sets grossMarginMax
     *
     * @param double $grossMarginMax The maximum gross margin (as percentage).
     *
     * @return $this
     */
    public function setGrossMarginMax($grossMarginMax)
    {
        $this->container['grossMarginMax'] = $grossMarginMax;

        return $this;
    }

    /**
     * Gets operatingMarginMin
     *
     * @return double
     */
    public function getOperatingMarginMin()
    {
        return $this->container['operatingMarginMin'];
    }

    /**
     * Sets operatingMarginMin
     *
     * @param double $operatingMarginMin The minimum operating margin (as percentage).
     *
     * @return $this
     */
    public function setOperatingMarginMin($operatingMarginMin)
    {
        $this->container['operatingMarginMin'] = $operatingMarginMin;

        return $this;
    }

    /**
     * Gets operatingMarginMax
     *
     * @return double
     */
    public function getOperatingMarginMax()
    {
        return $this->container['operatingMarginMax'];
    }

    /**
     * Sets operatingMarginMax
     *
     * @param double $operatingMarginMax The maximum operating margin (as percentage).
     *
     * @return $this
     */
    public function setOperatingMarginMax($operatingMarginMax)
    {
        $this->container['operatingMarginMax'] = $operatingMarginMax;

        return $this;
    }

    /**
     * Gets profitMarginMin
     *
     * @return double
     */
    public function getProfitMarginMin()
    {
        return $this->container['profitMarginMin'];
    }

    /**
     * Sets profitMarginMin
     *
     * @param double $profitMarginMin The minimum profit margin (as percentage).
     *
     * @return $this
     */
    public function setProfitMarginMin($profitMarginMin)
    {
        $this->container['profitMarginMin'] = $profitMarginMin;

        return $this;
    }

    /**
     * Gets profitMarginMax
     *
     * @return double
     */
    public function getProfitMarginMax()
    {
        return $this->container['profitMarginMax'];
    }

    /**
     * Sets profitMarginMax
     *
     * @param double $profitMarginMax The maximum profit margin (as percentage).
     *
     * @return $this
     */
    public function setProfitMarginMax($profitMarginMax)
    {
        $this->container['profitMarginMax'] = $profitMarginMax;

        return $this;
    }

    /**
     * Gets priceToSalesMin
     *
     * @return double
     */
    public function getPriceToSalesMin()
    {
        return $this->container['priceToSalesMin'];
    }

    /**
     * Sets priceToSalesMin
     *
     * @param double $priceToSalesMin The minimum price to sales ratio.
     *
     * @return $this
     */
    public function setPriceToSalesMin($priceToSalesMin)
    {
        $this->container['priceToSalesMin'] = $priceToSalesMin;

        return $this;
    }

    /**
     * Gets priceToSalesMax
     *
     * @return double
     */
    public function getPriceToSalesMax()
    {
        return $this->container['priceToSalesMax'];
    }

    /**
     * Sets priceToSalesMax
     *
     * @param double $priceToSalesMax The maximum price to sales ratio.
     *
     * @return $this
     */
    public function setPriceToSalesMax($priceToSalesMax)
    {
        $this->container['priceToSalesMax'] = $priceToSalesMax;

        return $this;
    }

    /**
     * Gets buybacksThreeMonthsMin
     *
     * @return double
     */
    public function getBuybacksThreeMonthsMin()
    {
        return $this->container['buybacksThreeMonthsMin'];
    }

    /**
     * Sets buybacksThreeMonthsMin
     *
     * @param double $buybacksThreeMonthsMin The minimum percentage of shares bought back in the last 3 months. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksThreeMonthsMin($buybacksThreeMonthsMin)
    {
        $this->container['buybacksThreeMonthsMin'] = $buybacksThreeMonthsMin;

        return $this;
    }

    /**
     * Gets buybacksThreeMonthsMax
     *
     * @return double
     */
    public function getBuybacksThreeMonthsMax()
    {
        return $this->container['buybacksThreeMonthsMax'];
    }

    /**
     * Sets buybacksThreeMonthsMax
     *
     * @param double $buybacksThreeMonthsMax The maximum percentage of shares bought back in the last 3 months. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksThreeMonthsMax($buybacksThreeMonthsMax)
    {
        $this->container['buybacksThreeMonthsMax'] = $buybacksThreeMonthsMax;

        return $this;
    }

    /**
     * Gets buybacksSixMonthsMin
     *
     * @return double
     */
    public function getBuybacksSixMonthsMin()
    {
        return $this->container['buybacksSixMonthsMin'];
    }

    /**
     * Sets buybacksSixMonthsMin
     *
     * @param double $buybacksSixMonthsMin The minimum percentage of shares bought back in the last 6 months. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksSixMonthsMin($buybacksSixMonthsMin)
    {
        $this->container['buybacksSixMonthsMin'] = $buybacksSixMonthsMin;

        return $this;
    }

    /**
     * Gets buybacksSixMonthsMax
     *
     * @return double
     */
    public function getBuybacksSixMonthsMax()
    {
        return $this->container['buybacksSixMonthsMax'];
    }

    /**
     * Sets buybacksSixMonthsMax
     *
     * @param double $buybacksSixMonthsMax buybacksSixMonthsMax
     *
     * @return $this
     */
    public function setBuybacksSixMonthsMax($buybacksSixMonthsMax)
    {
        $this->container['buybacksSixMonthsMax'] = $buybacksSixMonthsMax;

        return $this;
    }

    /**
     * Gets buybacksOneYearMin
     *
     * @return double
     */
    public function getBuybacksOneYearMin()
    {
        return $this->container['buybacksOneYearMin'];
    }

    /**
     * Sets buybacksOneYearMin
     *
     * @param double $buybacksOneYearMin The minimum percentage of shares bought back in the last year. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksOneYearMin($buybacksOneYearMin)
    {
        $this->container['buybacksOneYearMin'] = $buybacksOneYearMin;

        return $this;
    }

    /**
     * Gets buybacksOneYearMax
     *
     * @return double
     */
    public function getBuybacksOneYearMax()
    {
        return $this->container['buybacksOneYearMax'];
    }

    /**
     * Sets buybacksOneYearMax
     *
     * @param double $buybacksOneYearMax The maximum percentage of shares bought back in the last year. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksOneYearMax($buybacksOneYearMax)
    {
        $this->container['buybacksOneYearMax'] = $buybacksOneYearMax;

        return $this;
    }

    /**
     * Gets buybacksTwoYearsMin
     *
     * @return double
     */
    public function getBuybacksTwoYearsMin()
    {
        return $this->container['buybacksTwoYearsMin'];
    }

    /**
     * Sets buybacksTwoYearsMin
     *
     * @param double $buybacksTwoYearsMin The minimum percentage of shares bought back in the last 2 years. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksTwoYearsMin($buybacksTwoYearsMin)
    {
        $this->container['buybacksTwoYearsMin'] = $buybacksTwoYearsMin;

        return $this;
    }

    /**
     * Gets buybacksTwoYearsMax
     *
     * @return double
     */
    public function getBuybacksTwoYearsMax()
    {
        return $this->container['buybacksTwoYearsMax'];
    }

    /**
     * Sets buybacksTwoYearsMax
     *
     * @param double $buybacksTwoYearsMax The maximum percentage of shares bought back in the last 2 years. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksTwoYearsMax($buybacksTwoYearsMax)
    {
        $this->container['buybacksTwoYearsMax'] = $buybacksTwoYearsMax;

        return $this;
    }

    /**
     * Gets buybacksThreeYearsMin
     *
     * @return double
     */
    public function getBuybacksThreeYearsMin()
    {
        return $this->container['buybacksThreeYearsMin'];
    }

    /**
     * Sets buybacksThreeYearsMin
     *
     * @param double $buybacksThreeYearsMin The minimum percentage of shares bought back in the last 3 years. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksThreeYearsMin($buybacksThreeYearsMin)
    {
        $this->container['buybacksThreeYearsMin'] = $buybacksThreeYearsMin;

        return $this;
    }

    /**
     * Gets buybacksThreeYearsMax
     *
     * @return double
     */
    public function getBuybacksThreeYearsMax()
    {
        return $this->container['buybacksThreeYearsMax'];
    }

    /**
     * Sets buybacksThreeYearsMax
     *
     * @param double $buybacksThreeYearsMax The maximum percentage of shares bought back in the last 3 years. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksThreeYearsMax($buybacksThreeYearsMax)
    {
        $this->container['buybacksThreeYearsMax'] = $buybacksThreeYearsMax;

        return $this;
    }

    /**
     * Gets buybacksFiveYearsMin
     *
     * @return double
     */
    public function getBuybacksFiveYearsMin()
    {
        return $this->container['buybacksFiveYearsMin'];
    }

    /**
     * Sets buybacksFiveYearsMin
     *
     * @param double $buybacksFiveYearsMin The minimum percentage of shares bought back in the last 5 years. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksFiveYearsMin($buybacksFiveYearsMin)
    {
        $this->container['buybacksFiveYearsMin'] = $buybacksFiveYearsMin;

        return $this;
    }

    /**
     * Gets buybacksFiveYearsMax
     *
     * @return double
     */
    public function getBuybacksFiveYearsMax()
    {
        return $this->container['buybacksFiveYearsMax'];
    }

    /**
     * Sets buybacksFiveYearsMax
     *
     * @param double $buybacksFiveYearsMax The maximum percentage of shares bought back in the last 5 years. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksFiveYearsMax($buybacksFiveYearsMax)
    {
        $this->container['buybacksFiveYearsMax'] = $buybacksFiveYearsMax;

        return $this;
    }

    /**
     * Gets buybacksTenYearsMin
     *
     * @return double
     */
    public function getBuybacksTenYearsMin()
    {
        return $this->container['buybacksTenYearsMin'];
    }

    /**
     * Sets buybacksTenYearsMin
     *
     * @param double $buybacksTenYearsMin The minimum percentage of shares bought back in the last 10 years. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksTenYearsMin($buybacksTenYearsMin)
    {
        $this->container['buybacksTenYearsMin'] = $buybacksTenYearsMin;

        return $this;
    }

    /**
     * Gets buybacksTenYearsMax
     *
     * @return double
     */
    public function getBuybacksTenYearsMax()
    {
        return $this->container['buybacksTenYearsMax'];
    }

    /**
     * Sets buybacksTenYearsMax
     *
     * @param double $buybacksTenYearsMax The maximum percentage of shares bought back in the last 10 years. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksTenYearsMax($buybacksTenYearsMax)
    {
        $this->container['buybacksTenYearsMax'] = $buybacksTenYearsMax;

        return $this;
    }

    /**
     * Gets buybacksTwentyYearsMin
     *
     * @return double
     */
    public function getBuybacksTwentyYearsMin()
    {
        return $this->container['buybacksTwentyYearsMin'];
    }

    /**
     * Sets buybacksTwentyYearsMin
     *
     * @param double $buybacksTwentyYearsMin The minimum percentage of shares bought back in the last 20 years. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksTwentyYearsMin($buybacksTwentyYearsMin)
    {
        $this->container['buybacksTwentyYearsMin'] = $buybacksTwentyYearsMin;

        return $this;
    }

    /**
     * Gets buybacksTwentyYearsMax
     *
     * @return double
     */
    public function getBuybacksTwentyYearsMax()
    {
        return $this->container['buybacksTwentyYearsMax'];
    }

    /**
     * Sets buybacksTwentyYearsMax
     *
     * @param double $buybacksTwentyYearsMax The maximum percentage of shares bought back in the last 20 years. Negative values represent dilution of shares.
     *
     * @return $this
     */
    public function setBuybacksTwentyYearsMax($buybacksTwentyYearsMax)
    {
        $this->container['buybacksTwentyYearsMax'] = $buybacksTwentyYearsMax;

        return $this;
    }

    /**
     * Gets potentialUpside
     *
     * @return double
     */
    public function getPotentialUpside()
    {
        return $this->container['potentialUpside'];
    }

    /**
     * Sets potentialUpside
     *
     * @param double $potentialUpside The upside potential according to the analysts' target price consensus (as percentage). I.e. If the stock price is $100 and the analysts' target price consensus is $150 then the potential upside is 50%.
     *
     * @return $this
     */
    public function setPotentialUpside($potentialUpside)
    {
        $this->container['potentialUpside'] = $potentialUpside;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
