<?php
/**
 * News
 *
 * PHP version 5
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Stocks
 *
 * <h3>Rate limits</h3>                     Free subscriptions are subject to daily limits. To know how much requests you have left look at the following headers in the response.<br />                     1. <strong>x-ratelimit-limit</strong> - The total number of requests that you are allowed to make in a given period (hour/day)<br />                     2. <strong>x-ratelimit-remaining</strong> - The number of remaining requests that you can perform in the current period.<br />                     3. <strong>x-ratelimit-reset</strong> - The number of seconds until the current period resets.<br />                     <br />                     <br />                     You don't have an API key? <a href=\"https://www.equibles.com/api/pricing\" target=\"_blank\">Get one for free here.</a>
 *
 * OpenAPI spec version: v1
 * Contact: contact@equibles.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.34
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EquiblesStocks\Models;

use \ArrayAccess;
use \EquiblesStocks\ObjectSerializer;

/**
 * News Class Doc Comment
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class News implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'News';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'title' => 'string',
'ampUrl' => 'string',
'articleUrl' => 'string',
'author' => 'string',
'description' => 'string',
'imageUrl' => 'string',
'keywords' => 'string[]',
'financialAssets' => 'string[]',
'publishedTime' => '\DateTime',
'publisherName' => 'string'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'title' => null,
'ampUrl' => null,
'articleUrl' => null,
'author' => null,
'description' => null,
'imageUrl' => null,
'keywords' => null,
'financialAssets' => null,
'publishedTime' => 'date-time',
'publisherName' => null    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'title' => 'title',
'ampUrl' => 'ampUrl',
'articleUrl' => 'articleUrl',
'author' => 'author',
'description' => 'description',
'imageUrl' => 'imageUrl',
'keywords' => 'keywords',
'financialAssets' => 'financialAssets',
'publishedTime' => 'publishedTime',
'publisherName' => 'publisherName'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'title' => 'setTitle',
'ampUrl' => 'setAmpUrl',
'articleUrl' => 'setArticleUrl',
'author' => 'setAuthor',
'description' => 'setDescription',
'imageUrl' => 'setImageUrl',
'keywords' => 'setKeywords',
'financialAssets' => 'setFinancialAssets',
'publishedTime' => 'setPublishedTime',
'publisherName' => 'setPublisherName'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'title' => 'getTitle',
'ampUrl' => 'getAmpUrl',
'articleUrl' => 'getArticleUrl',
'author' => 'getAuthor',
'description' => 'getDescription',
'imageUrl' => 'getImageUrl',
'keywords' => 'getKeywords',
'financialAssets' => 'getFinancialAssets',
'publishedTime' => 'getPublishedTime',
'publisherName' => 'getPublisherName'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['ampUrl'] = isset($data['ampUrl']) ? $data['ampUrl'] : null;
        $this->container['articleUrl'] = isset($data['articleUrl']) ? $data['articleUrl'] : null;
        $this->container['author'] = isset($data['author']) ? $data['author'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['imageUrl'] = isset($data['imageUrl']) ? $data['imageUrl'] : null;
        $this->container['keywords'] = isset($data['keywords']) ? $data['keywords'] : null;
        $this->container['financialAssets'] = isset($data['financialAssets']) ? $data['financialAssets'] : null;
        $this->container['publishedTime'] = isset($data['publishedTime']) ? $data['publishedTime'] : null;
        $this->container['publisherName'] = isset($data['publisherName']) ? $data['publisherName'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param string $title title
     *
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets ampUrl
     *
     * @return string
     */
    public function getAmpUrl()
    {
        return $this->container['ampUrl'];
    }

    /**
     * Sets ampUrl
     *
     * @param string $ampUrl ampUrl
     *
     * @return $this
     */
    public function setAmpUrl($ampUrl)
    {
        $this->container['ampUrl'] = $ampUrl;

        return $this;
    }

    /**
     * Gets articleUrl
     *
     * @return string
     */
    public function getArticleUrl()
    {
        return $this->container['articleUrl'];
    }

    /**
     * Sets articleUrl
     *
     * @param string $articleUrl articleUrl
     *
     * @return $this
     */
    public function setArticleUrl($articleUrl)
    {
        $this->container['articleUrl'] = $articleUrl;

        return $this;
    }

    /**
     * Gets author
     *
     * @return string
     */
    public function getAuthor()
    {
        return $this->container['author'];
    }

    /**
     * Sets author
     *
     * @param string $author author
     *
     * @return $this
     */
    public function setAuthor($author)
    {
        $this->container['author'] = $author;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets imageUrl
     *
     * @return string
     */
    public function getImageUrl()
    {
        return $this->container['imageUrl'];
    }

    /**
     * Sets imageUrl
     *
     * @param string $imageUrl imageUrl
     *
     * @return $this
     */
    public function setImageUrl($imageUrl)
    {
        $this->container['imageUrl'] = $imageUrl;

        return $this;
    }

    /**
     * Gets keywords
     *
     * @return string[]
     */
    public function getKeywords()
    {
        return $this->container['keywords'];
    }

    /**
     * Sets keywords
     *
     * @param string[] $keywords keywords
     *
     * @return $this
     */
    public function setKeywords($keywords)
    {
        $this->container['keywords'] = $keywords;

        return $this;
    }

    /**
     * Gets financialAssets
     *
     * @return string[]
     */
    public function getFinancialAssets()
    {
        return $this->container['financialAssets'];
    }

    /**
     * Sets financialAssets
     *
     * @param string[] $financialAssets financialAssets
     *
     * @return $this
     */
    public function setFinancialAssets($financialAssets)
    {
        $this->container['financialAssets'] = $financialAssets;

        return $this;
    }

    /**
     * Gets publishedTime
     *
     * @return \DateTime
     */
    public function getPublishedTime()
    {
        return $this->container['publishedTime'];
    }

    /**
     * Sets publishedTime
     *
     * @param \DateTime $publishedTime publishedTime
     *
     * @return $this
     */
    public function setPublishedTime($publishedTime)
    {
        $this->container['publishedTime'] = $publishedTime;

        return $this;
    }

    /**
     * Gets publisherName
     *
     * @return string
     */
    public function getPublisherName()
    {
        return $this->container['publisherName'];
    }

    /**
     * Sets publisherName
     *
     * @param string $publisherName publisherName
     *
     * @return $this
     */
    public function setPublisherName($publisherName)
    {
        $this->container['publisherName'] = $publisherName;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
