<?php
/**
 * FinancialReport
 *
 * PHP version 5
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Stocks
 *
 * <h3>Rate limits</h3>                     Free subscriptions are subject to daily limits. To know how much requests you have left look at the following headers in the response.<br />                     1. <strong>x-ratelimit-limit</strong> - The total number of requests that you are allowed to make in a given period (hour/day)<br />                     2. <strong>x-ratelimit-remaining</strong> - The number of remaining requests that you can perform in the current period.<br />                     3. <strong>x-ratelimit-reset</strong> - The number of seconds until the current period resets.<br />                     <br />                     <br />                     You don't have an API key? <a href=\"https://www.equibles.com/api/pricing\" target=\"_blank\">Get one for free here.</a>
 *
 * OpenAPI spec version: v1
 * Contact: contact@equibles.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.34
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EquiblesStocks\Models;

use \ArrayAccess;
use \EquiblesStocks\ObjectSerializer;

/**
 * FinancialReport Class Doc Comment
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class FinancialReport implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'FinancialReport';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'balanceSheet' => '\EquiblesStocks\Models\BalanceSheet',
'cashFlowStatement' => '\EquiblesStocks\Models\CashFlowStatement',
'incomeStatement' => '\EquiblesStocks\Models\IncomeStatement',
'startDate' => '\DateTime',
'endDate' => '\DateTime',
'fiscalPeriod' => '\EquiblesStocks\Models\FiscalPeriod',
'year' => 'int'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'balanceSheet' => null,
'cashFlowStatement' => null,
'incomeStatement' => null,
'startDate' => 'date-time',
'endDate' => 'date-time',
'fiscalPeriod' => null,
'year' => 'int32'    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'balanceSheet' => 'balanceSheet',
'cashFlowStatement' => 'cashFlowStatement',
'incomeStatement' => 'incomeStatement',
'startDate' => 'startDate',
'endDate' => 'endDate',
'fiscalPeriod' => 'fiscalPeriod',
'year' => 'year'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'balanceSheet' => 'setBalanceSheet',
'cashFlowStatement' => 'setCashFlowStatement',
'incomeStatement' => 'setIncomeStatement',
'startDate' => 'setStartDate',
'endDate' => 'setEndDate',
'fiscalPeriod' => 'setFiscalPeriod',
'year' => 'setYear'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'balanceSheet' => 'getBalanceSheet',
'cashFlowStatement' => 'getCashFlowStatement',
'incomeStatement' => 'getIncomeStatement',
'startDate' => 'getStartDate',
'endDate' => 'getEndDate',
'fiscalPeriod' => 'getFiscalPeriod',
'year' => 'getYear'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['balanceSheet'] = isset($data['balanceSheet']) ? $data['balanceSheet'] : null;
        $this->container['cashFlowStatement'] = isset($data['cashFlowStatement']) ? $data['cashFlowStatement'] : null;
        $this->container['incomeStatement'] = isset($data['incomeStatement']) ? $data['incomeStatement'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['endDate'] = isset($data['endDate']) ? $data['endDate'] : null;
        $this->container['fiscalPeriod'] = isset($data['fiscalPeriod']) ? $data['fiscalPeriod'] : null;
        $this->container['year'] = isset($data['year']) ? $data['year'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets balanceSheet
     *
     * @return \EquiblesStocks\Models\BalanceSheet
     */
    public function getBalanceSheet()
    {
        return $this->container['balanceSheet'];
    }

    /**
     * Sets balanceSheet
     *
     * @param \EquiblesStocks\Models\BalanceSheet $balanceSheet balanceSheet
     *
     * @return $this
     */
    public function setBalanceSheet($balanceSheet)
    {
        $this->container['balanceSheet'] = $balanceSheet;

        return $this;
    }

    /**
     * Gets cashFlowStatement
     *
     * @return \EquiblesStocks\Models\CashFlowStatement
     */
    public function getCashFlowStatement()
    {
        return $this->container['cashFlowStatement'];
    }

    /**
     * Sets cashFlowStatement
     *
     * @param \EquiblesStocks\Models\CashFlowStatement $cashFlowStatement cashFlowStatement
     *
     * @return $this
     */
    public function setCashFlowStatement($cashFlowStatement)
    {
        $this->container['cashFlowStatement'] = $cashFlowStatement;

        return $this;
    }

    /**
     * Gets incomeStatement
     *
     * @return \EquiblesStocks\Models\IncomeStatement
     */
    public function getIncomeStatement()
    {
        return $this->container['incomeStatement'];
    }

    /**
     * Sets incomeStatement
     *
     * @param \EquiblesStocks\Models\IncomeStatement $incomeStatement incomeStatement
     *
     * @return $this
     */
    public function setIncomeStatement($incomeStatement)
    {
        $this->container['incomeStatement'] = $incomeStatement;

        return $this;
    }

    /**
     * Gets startDate
     *
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     *
     * @param \DateTime $startDate startDate
     *
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate
     *
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     *
     * @param \DateTime $endDate endDate
     *
     * @return $this
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets fiscalPeriod
     *
     * @return \EquiblesStocks\Models\FiscalPeriod
     */
    public function getFiscalPeriod()
    {
        return $this->container['fiscalPeriod'];
    }

    /**
     * Sets fiscalPeriod
     *
     * @param \EquiblesStocks\Models\FiscalPeriod $fiscalPeriod fiscalPeriod
     *
     * @return $this
     */
    public function setFiscalPeriod($fiscalPeriod)
    {
        $this->container['fiscalPeriod'] = $fiscalPeriod;

        return $this;
    }

    /**
     * Gets year
     *
     * @return int
     */
    public function getYear()
    {
        return $this->container['year'];
    }

    /**
     * Sets year
     *
     * @param int $year year
     *
     * @return $this
     */
    public function setYear($year)
    {
        $this->container['year'] = $year;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
