<?php
/**
 * BalanceSheet
 *
 * PHP version 5
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Stocks
 *
 * <h3>Rate limits</h3>                     Free subscriptions are subject to daily limits. To know how much requests you have left look at the following headers in the response.<br />                     1. <strong>x-ratelimit-limit</strong> - The total number of requests that you are allowed to make in a given period (hour/day)<br />                     2. <strong>x-ratelimit-remaining</strong> - The number of remaining requests that you can perform in the current period.<br />                     3. <strong>x-ratelimit-reset</strong> - The number of seconds until the current period resets.<br />                     <br />                     <br />                     You don't have an API key? <a href=\"https://www.equibles.com/api/pricing\" target=\"_blank\">Get one for free here.</a>
 *
 * OpenAPI spec version: v1
 * Contact: contact@equibles.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.34
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EquiblesStocks\Models;

use \ArrayAccess;
use \EquiblesStocks\ObjectSerializer;

/**
 * BalanceSheet Class Doc Comment
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class BalanceSheet implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'BalanceSheet';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'assets' => 'int',
'tangibleAssets' => 'int',
'currentAssets' => 'int',
'cashAndCashEquivalents' => 'int',
'cashAndShortTermInvestments' => 'int',
'inventory' => 'int',
'currentNetReceivables' => 'int',
'nonCurrentAssets' => 'int',
'propertyPlantEquipment' => 'int',
'accumulatedDepreciationAmortization' => 'int',
'intangibleAssets' => 'int',
'intangibleAssetsExcludingGoodwill' => 'int',
'goodwill' => 'int',
'investments' => 'int',
'longTermInvestments' => 'int',
'shortTermInvestments' => 'int',
'otherCurrentAssets' => 'int',
'otherNonCurrentAssets' => 'int',
'liabilities' => 'int',
'currentLiabilities' => 'int',
'currentAccountsPayable' => 'int',
'deferredRevenue' => 'int',
'currentDebt' => 'int',
'shortTermDebt' => 'int',
'nonCurrentLiabilities' => 'int',
'capitalLeaseObligations' => 'int',
'longTermDebt' => 'int',
'currentLongTermDebt' => 'int',
'longTermDebtNonCurrent' => 'int',
'shortLongTermDebtTotal' => 'int',
'otherCurrentLiabilities' => 'int',
'otherNonCurrentLiabilities' => 'int',
'equity' => 'int',
'treasuryStock' => 'int',
'retainedEarnings' => 'int',
'commonStock' => 'int',
'sharesOutstanding' => 'int',
'accumulatedOtherComprehensiveIncome' => 'int',
'workingCapital' => 'int'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'assets' => 'int64',
'tangibleAssets' => 'int64',
'currentAssets' => 'int64',
'cashAndCashEquivalents' => 'int64',
'cashAndShortTermInvestments' => 'int64',
'inventory' => 'int64',
'currentNetReceivables' => 'int64',
'nonCurrentAssets' => 'int64',
'propertyPlantEquipment' => 'int64',
'accumulatedDepreciationAmortization' => 'int64',
'intangibleAssets' => 'int64',
'intangibleAssetsExcludingGoodwill' => 'int64',
'goodwill' => 'int64',
'investments' => 'int64',
'longTermInvestments' => 'int64',
'shortTermInvestments' => 'int64',
'otherCurrentAssets' => 'int64',
'otherNonCurrentAssets' => 'int64',
'liabilities' => 'int64',
'currentLiabilities' => 'int64',
'currentAccountsPayable' => 'int64',
'deferredRevenue' => 'int64',
'currentDebt' => 'int64',
'shortTermDebt' => 'int64',
'nonCurrentLiabilities' => 'int64',
'capitalLeaseObligations' => 'int64',
'longTermDebt' => 'int64',
'currentLongTermDebt' => 'int64',
'longTermDebtNonCurrent' => 'int64',
'shortLongTermDebtTotal' => 'int64',
'otherCurrentLiabilities' => 'int64',
'otherNonCurrentLiabilities' => 'int64',
'equity' => 'int64',
'treasuryStock' => 'int64',
'retainedEarnings' => 'int64',
'commonStock' => 'int64',
'sharesOutstanding' => 'int64',
'accumulatedOtherComprehensiveIncome' => 'int64',
'workingCapital' => 'int64'    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'assets' => 'assets',
'tangibleAssets' => 'tangibleAssets',
'currentAssets' => 'currentAssets',
'cashAndCashEquivalents' => 'cashAndCashEquivalents',
'cashAndShortTermInvestments' => 'cashAndShortTermInvestments',
'inventory' => 'inventory',
'currentNetReceivables' => 'currentNetReceivables',
'nonCurrentAssets' => 'nonCurrentAssets',
'propertyPlantEquipment' => 'propertyPlantEquipment',
'accumulatedDepreciationAmortization' => 'accumulatedDepreciationAmortization',
'intangibleAssets' => 'intangibleAssets',
'intangibleAssetsExcludingGoodwill' => 'intangibleAssetsExcludingGoodwill',
'goodwill' => 'goodwill',
'investments' => 'investments',
'longTermInvestments' => 'longTermInvestments',
'shortTermInvestments' => 'shortTermInvestments',
'otherCurrentAssets' => 'otherCurrentAssets',
'otherNonCurrentAssets' => 'otherNonCurrentAssets',
'liabilities' => 'liabilities',
'currentLiabilities' => 'currentLiabilities',
'currentAccountsPayable' => 'currentAccountsPayable',
'deferredRevenue' => 'deferredRevenue',
'currentDebt' => 'currentDebt',
'shortTermDebt' => 'shortTermDebt',
'nonCurrentLiabilities' => 'nonCurrentLiabilities',
'capitalLeaseObligations' => 'capitalLeaseObligations',
'longTermDebt' => 'longTermDebt',
'currentLongTermDebt' => 'currentLongTermDebt',
'longTermDebtNonCurrent' => 'longTermDebtNonCurrent',
'shortLongTermDebtTotal' => 'shortLongTermDebtTotal',
'otherCurrentLiabilities' => 'otherCurrentLiabilities',
'otherNonCurrentLiabilities' => 'otherNonCurrentLiabilities',
'equity' => 'equity',
'treasuryStock' => 'treasuryStock',
'retainedEarnings' => 'retainedEarnings',
'commonStock' => 'commonStock',
'sharesOutstanding' => 'sharesOutstanding',
'accumulatedOtherComprehensiveIncome' => 'accumulatedOtherComprehensiveIncome',
'workingCapital' => 'workingCapital'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'assets' => 'setAssets',
'tangibleAssets' => 'setTangibleAssets',
'currentAssets' => 'setCurrentAssets',
'cashAndCashEquivalents' => 'setCashAndCashEquivalents',
'cashAndShortTermInvestments' => 'setCashAndShortTermInvestments',
'inventory' => 'setInventory',
'currentNetReceivables' => 'setCurrentNetReceivables',
'nonCurrentAssets' => 'setNonCurrentAssets',
'propertyPlantEquipment' => 'setPropertyPlantEquipment',
'accumulatedDepreciationAmortization' => 'setAccumulatedDepreciationAmortization',
'intangibleAssets' => 'setIntangibleAssets',
'intangibleAssetsExcludingGoodwill' => 'setIntangibleAssetsExcludingGoodwill',
'goodwill' => 'setGoodwill',
'investments' => 'setInvestments',
'longTermInvestments' => 'setLongTermInvestments',
'shortTermInvestments' => 'setShortTermInvestments',
'otherCurrentAssets' => 'setOtherCurrentAssets',
'otherNonCurrentAssets' => 'setOtherNonCurrentAssets',
'liabilities' => 'setLiabilities',
'currentLiabilities' => 'setCurrentLiabilities',
'currentAccountsPayable' => 'setCurrentAccountsPayable',
'deferredRevenue' => 'setDeferredRevenue',
'currentDebt' => 'setCurrentDebt',
'shortTermDebt' => 'setShortTermDebt',
'nonCurrentLiabilities' => 'setNonCurrentLiabilities',
'capitalLeaseObligations' => 'setCapitalLeaseObligations',
'longTermDebt' => 'setLongTermDebt',
'currentLongTermDebt' => 'setCurrentLongTermDebt',
'longTermDebtNonCurrent' => 'setLongTermDebtNonCurrent',
'shortLongTermDebtTotal' => 'setShortLongTermDebtTotal',
'otherCurrentLiabilities' => 'setOtherCurrentLiabilities',
'otherNonCurrentLiabilities' => 'setOtherNonCurrentLiabilities',
'equity' => 'setEquity',
'treasuryStock' => 'setTreasuryStock',
'retainedEarnings' => 'setRetainedEarnings',
'commonStock' => 'setCommonStock',
'sharesOutstanding' => 'setSharesOutstanding',
'accumulatedOtherComprehensiveIncome' => 'setAccumulatedOtherComprehensiveIncome',
'workingCapital' => 'setWorkingCapital'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'assets' => 'getAssets',
'tangibleAssets' => 'getTangibleAssets',
'currentAssets' => 'getCurrentAssets',
'cashAndCashEquivalents' => 'getCashAndCashEquivalents',
'cashAndShortTermInvestments' => 'getCashAndShortTermInvestments',
'inventory' => 'getInventory',
'currentNetReceivables' => 'getCurrentNetReceivables',
'nonCurrentAssets' => 'getNonCurrentAssets',
'propertyPlantEquipment' => 'getPropertyPlantEquipment',
'accumulatedDepreciationAmortization' => 'getAccumulatedDepreciationAmortization',
'intangibleAssets' => 'getIntangibleAssets',
'intangibleAssetsExcludingGoodwill' => 'getIntangibleAssetsExcludingGoodwill',
'goodwill' => 'getGoodwill',
'investments' => 'getInvestments',
'longTermInvestments' => 'getLongTermInvestments',
'shortTermInvestments' => 'getShortTermInvestments',
'otherCurrentAssets' => 'getOtherCurrentAssets',
'otherNonCurrentAssets' => 'getOtherNonCurrentAssets',
'liabilities' => 'getLiabilities',
'currentLiabilities' => 'getCurrentLiabilities',
'currentAccountsPayable' => 'getCurrentAccountsPayable',
'deferredRevenue' => 'getDeferredRevenue',
'currentDebt' => 'getCurrentDebt',
'shortTermDebt' => 'getShortTermDebt',
'nonCurrentLiabilities' => 'getNonCurrentLiabilities',
'capitalLeaseObligations' => 'getCapitalLeaseObligations',
'longTermDebt' => 'getLongTermDebt',
'currentLongTermDebt' => 'getCurrentLongTermDebt',
'longTermDebtNonCurrent' => 'getLongTermDebtNonCurrent',
'shortLongTermDebtTotal' => 'getShortLongTermDebtTotal',
'otherCurrentLiabilities' => 'getOtherCurrentLiabilities',
'otherNonCurrentLiabilities' => 'getOtherNonCurrentLiabilities',
'equity' => 'getEquity',
'treasuryStock' => 'getTreasuryStock',
'retainedEarnings' => 'getRetainedEarnings',
'commonStock' => 'getCommonStock',
'sharesOutstanding' => 'getSharesOutstanding',
'accumulatedOtherComprehensiveIncome' => 'getAccumulatedOtherComprehensiveIncome',
'workingCapital' => 'getWorkingCapital'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['assets'] = isset($data['assets']) ? $data['assets'] : null;
        $this->container['tangibleAssets'] = isset($data['tangibleAssets']) ? $data['tangibleAssets'] : null;
        $this->container['currentAssets'] = isset($data['currentAssets']) ? $data['currentAssets'] : null;
        $this->container['cashAndCashEquivalents'] = isset($data['cashAndCashEquivalents']) ? $data['cashAndCashEquivalents'] : null;
        $this->container['cashAndShortTermInvestments'] = isset($data['cashAndShortTermInvestments']) ? $data['cashAndShortTermInvestments'] : null;
        $this->container['inventory'] = isset($data['inventory']) ? $data['inventory'] : null;
        $this->container['currentNetReceivables'] = isset($data['currentNetReceivables']) ? $data['currentNetReceivables'] : null;
        $this->container['nonCurrentAssets'] = isset($data['nonCurrentAssets']) ? $data['nonCurrentAssets'] : null;
        $this->container['propertyPlantEquipment'] = isset($data['propertyPlantEquipment']) ? $data['propertyPlantEquipment'] : null;
        $this->container['accumulatedDepreciationAmortization'] = isset($data['accumulatedDepreciationAmortization']) ? $data['accumulatedDepreciationAmortization'] : null;
        $this->container['intangibleAssets'] = isset($data['intangibleAssets']) ? $data['intangibleAssets'] : null;
        $this->container['intangibleAssetsExcludingGoodwill'] = isset($data['intangibleAssetsExcludingGoodwill']) ? $data['intangibleAssetsExcludingGoodwill'] : null;
        $this->container['goodwill'] = isset($data['goodwill']) ? $data['goodwill'] : null;
        $this->container['investments'] = isset($data['investments']) ? $data['investments'] : null;
        $this->container['longTermInvestments'] = isset($data['longTermInvestments']) ? $data['longTermInvestments'] : null;
        $this->container['shortTermInvestments'] = isset($data['shortTermInvestments']) ? $data['shortTermInvestments'] : null;
        $this->container['otherCurrentAssets'] = isset($data['otherCurrentAssets']) ? $data['otherCurrentAssets'] : null;
        $this->container['otherNonCurrentAssets'] = isset($data['otherNonCurrentAssets']) ? $data['otherNonCurrentAssets'] : null;
        $this->container['liabilities'] = isset($data['liabilities']) ? $data['liabilities'] : null;
        $this->container['currentLiabilities'] = isset($data['currentLiabilities']) ? $data['currentLiabilities'] : null;
        $this->container['currentAccountsPayable'] = isset($data['currentAccountsPayable']) ? $data['currentAccountsPayable'] : null;
        $this->container['deferredRevenue'] = isset($data['deferredRevenue']) ? $data['deferredRevenue'] : null;
        $this->container['currentDebt'] = isset($data['currentDebt']) ? $data['currentDebt'] : null;
        $this->container['shortTermDebt'] = isset($data['shortTermDebt']) ? $data['shortTermDebt'] : null;
        $this->container['nonCurrentLiabilities'] = isset($data['nonCurrentLiabilities']) ? $data['nonCurrentLiabilities'] : null;
        $this->container['capitalLeaseObligations'] = isset($data['capitalLeaseObligations']) ? $data['capitalLeaseObligations'] : null;
        $this->container['longTermDebt'] = isset($data['longTermDebt']) ? $data['longTermDebt'] : null;
        $this->container['currentLongTermDebt'] = isset($data['currentLongTermDebt']) ? $data['currentLongTermDebt'] : null;
        $this->container['longTermDebtNonCurrent'] = isset($data['longTermDebtNonCurrent']) ? $data['longTermDebtNonCurrent'] : null;
        $this->container['shortLongTermDebtTotal'] = isset($data['shortLongTermDebtTotal']) ? $data['shortLongTermDebtTotal'] : null;
        $this->container['otherCurrentLiabilities'] = isset($data['otherCurrentLiabilities']) ? $data['otherCurrentLiabilities'] : null;
        $this->container['otherNonCurrentLiabilities'] = isset($data['otherNonCurrentLiabilities']) ? $data['otherNonCurrentLiabilities'] : null;
        $this->container['equity'] = isset($data['equity']) ? $data['equity'] : null;
        $this->container['treasuryStock'] = isset($data['treasuryStock']) ? $data['treasuryStock'] : null;
        $this->container['retainedEarnings'] = isset($data['retainedEarnings']) ? $data['retainedEarnings'] : null;
        $this->container['commonStock'] = isset($data['commonStock']) ? $data['commonStock'] : null;
        $this->container['sharesOutstanding'] = isset($data['sharesOutstanding']) ? $data['sharesOutstanding'] : null;
        $this->container['accumulatedOtherComprehensiveIncome'] = isset($data['accumulatedOtherComprehensiveIncome']) ? $data['accumulatedOtherComprehensiveIncome'] : null;
        $this->container['workingCapital'] = isset($data['workingCapital']) ? $data['workingCapital'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets assets
     *
     * @return int
     */
    public function getAssets()
    {
        return $this->container['assets'];
    }

    /**
     * Sets assets
     *
     * @param int $assets assets
     *
     * @return $this
     */
    public function setAssets($assets)
    {
        $this->container['assets'] = $assets;

        return $this;
    }

    /**
     * Gets tangibleAssets
     *
     * @return int
     */
    public function getTangibleAssets()
    {
        return $this->container['tangibleAssets'];
    }

    /**
     * Sets tangibleAssets
     *
     * @param int $tangibleAssets tangibleAssets
     *
     * @return $this
     */
    public function setTangibleAssets($tangibleAssets)
    {
        $this->container['tangibleAssets'] = $tangibleAssets;

        return $this;
    }

    /**
     * Gets currentAssets
     *
     * @return int
     */
    public function getCurrentAssets()
    {
        return $this->container['currentAssets'];
    }

    /**
     * Sets currentAssets
     *
     * @param int $currentAssets currentAssets
     *
     * @return $this
     */
    public function setCurrentAssets($currentAssets)
    {
        $this->container['currentAssets'] = $currentAssets;

        return $this;
    }

    /**
     * Gets cashAndCashEquivalents
     *
     * @return int
     */
    public function getCashAndCashEquivalents()
    {
        return $this->container['cashAndCashEquivalents'];
    }

    /**
     * Sets cashAndCashEquivalents
     *
     * @param int $cashAndCashEquivalents cashAndCashEquivalents
     *
     * @return $this
     */
    public function setCashAndCashEquivalents($cashAndCashEquivalents)
    {
        $this->container['cashAndCashEquivalents'] = $cashAndCashEquivalents;

        return $this;
    }

    /**
     * Gets cashAndShortTermInvestments
     *
     * @return int
     */
    public function getCashAndShortTermInvestments()
    {
        return $this->container['cashAndShortTermInvestments'];
    }

    /**
     * Sets cashAndShortTermInvestments
     *
     * @param int $cashAndShortTermInvestments cashAndShortTermInvestments
     *
     * @return $this
     */
    public function setCashAndShortTermInvestments($cashAndShortTermInvestments)
    {
        $this->container['cashAndShortTermInvestments'] = $cashAndShortTermInvestments;

        return $this;
    }

    /**
     * Gets inventory
     *
     * @return int
     */
    public function getInventory()
    {
        return $this->container['inventory'];
    }

    /**
     * Sets inventory
     *
     * @param int $inventory inventory
     *
     * @return $this
     */
    public function setInventory($inventory)
    {
        $this->container['inventory'] = $inventory;

        return $this;
    }

    /**
     * Gets currentNetReceivables
     *
     * @return int
     */
    public function getCurrentNetReceivables()
    {
        return $this->container['currentNetReceivables'];
    }

    /**
     * Sets currentNetReceivables
     *
     * @param int $currentNetReceivables currentNetReceivables
     *
     * @return $this
     */
    public function setCurrentNetReceivables($currentNetReceivables)
    {
        $this->container['currentNetReceivables'] = $currentNetReceivables;

        return $this;
    }

    /**
     * Gets nonCurrentAssets
     *
     * @return int
     */
    public function getNonCurrentAssets()
    {
        return $this->container['nonCurrentAssets'];
    }

    /**
     * Sets nonCurrentAssets
     *
     * @param int $nonCurrentAssets nonCurrentAssets
     *
     * @return $this
     */
    public function setNonCurrentAssets($nonCurrentAssets)
    {
        $this->container['nonCurrentAssets'] = $nonCurrentAssets;

        return $this;
    }

    /**
     * Gets propertyPlantEquipment
     *
     * @return int
     */
    public function getPropertyPlantEquipment()
    {
        return $this->container['propertyPlantEquipment'];
    }

    /**
     * Sets propertyPlantEquipment
     *
     * @param int $propertyPlantEquipment propertyPlantEquipment
     *
     * @return $this
     */
    public function setPropertyPlantEquipment($propertyPlantEquipment)
    {
        $this->container['propertyPlantEquipment'] = $propertyPlantEquipment;

        return $this;
    }

    /**
     * Gets accumulatedDepreciationAmortization
     *
     * @return int
     */
    public function getAccumulatedDepreciationAmortization()
    {
        return $this->container['accumulatedDepreciationAmortization'];
    }

    /**
     * Sets accumulatedDepreciationAmortization
     *
     * @param int $accumulatedDepreciationAmortization accumulatedDepreciationAmortization
     *
     * @return $this
     */
    public function setAccumulatedDepreciationAmortization($accumulatedDepreciationAmortization)
    {
        $this->container['accumulatedDepreciationAmortization'] = $accumulatedDepreciationAmortization;

        return $this;
    }

    /**
     * Gets intangibleAssets
     *
     * @return int
     */
    public function getIntangibleAssets()
    {
        return $this->container['intangibleAssets'];
    }

    /**
     * Sets intangibleAssets
     *
     * @param int $intangibleAssets intangibleAssets
     *
     * @return $this
     */
    public function setIntangibleAssets($intangibleAssets)
    {
        $this->container['intangibleAssets'] = $intangibleAssets;

        return $this;
    }

    /**
     * Gets intangibleAssetsExcludingGoodwill
     *
     * @return int
     */
    public function getIntangibleAssetsExcludingGoodwill()
    {
        return $this->container['intangibleAssetsExcludingGoodwill'];
    }

    /**
     * Sets intangibleAssetsExcludingGoodwill
     *
     * @param int $intangibleAssetsExcludingGoodwill intangibleAssetsExcludingGoodwill
     *
     * @return $this
     */
    public function setIntangibleAssetsExcludingGoodwill($intangibleAssetsExcludingGoodwill)
    {
        $this->container['intangibleAssetsExcludingGoodwill'] = $intangibleAssetsExcludingGoodwill;

        return $this;
    }

    /**
     * Gets goodwill
     *
     * @return int
     */
    public function getGoodwill()
    {
        return $this->container['goodwill'];
    }

    /**
     * Sets goodwill
     *
     * @param int $goodwill goodwill
     *
     * @return $this
     */
    public function setGoodwill($goodwill)
    {
        $this->container['goodwill'] = $goodwill;

        return $this;
    }

    /**
     * Gets investments
     *
     * @return int
     */
    public function getInvestments()
    {
        return $this->container['investments'];
    }

    /**
     * Sets investments
     *
     * @param int $investments investments
     *
     * @return $this
     */
    public function setInvestments($investments)
    {
        $this->container['investments'] = $investments;

        return $this;
    }

    /**
     * Gets longTermInvestments
     *
     * @return int
     */
    public function getLongTermInvestments()
    {
        return $this->container['longTermInvestments'];
    }

    /**
     * Sets longTermInvestments
     *
     * @param int $longTermInvestments longTermInvestments
     *
     * @return $this
     */
    public function setLongTermInvestments($longTermInvestments)
    {
        $this->container['longTermInvestments'] = $longTermInvestments;

        return $this;
    }

    /**
     * Gets shortTermInvestments
     *
     * @return int
     */
    public function getShortTermInvestments()
    {
        return $this->container['shortTermInvestments'];
    }

    /**
     * Sets shortTermInvestments
     *
     * @param int $shortTermInvestments shortTermInvestments
     *
     * @return $this
     */
    public function setShortTermInvestments($shortTermInvestments)
    {
        $this->container['shortTermInvestments'] = $shortTermInvestments;

        return $this;
    }

    /**
     * Gets otherCurrentAssets
     *
     * @return int
     */
    public function getOtherCurrentAssets()
    {
        return $this->container['otherCurrentAssets'];
    }

    /**
     * Sets otherCurrentAssets
     *
     * @param int $otherCurrentAssets otherCurrentAssets
     *
     * @return $this
     */
    public function setOtherCurrentAssets($otherCurrentAssets)
    {
        $this->container['otherCurrentAssets'] = $otherCurrentAssets;

        return $this;
    }

    /**
     * Gets otherNonCurrentAssets
     *
     * @return int
     */
    public function getOtherNonCurrentAssets()
    {
        return $this->container['otherNonCurrentAssets'];
    }

    /**
     * Sets otherNonCurrentAssets
     *
     * @param int $otherNonCurrentAssets otherNonCurrentAssets
     *
     * @return $this
     */
    public function setOtherNonCurrentAssets($otherNonCurrentAssets)
    {
        $this->container['otherNonCurrentAssets'] = $otherNonCurrentAssets;

        return $this;
    }

    /**
     * Gets liabilities
     *
     * @return int
     */
    public function getLiabilities()
    {
        return $this->container['liabilities'];
    }

    /**
     * Sets liabilities
     *
     * @param int $liabilities liabilities
     *
     * @return $this
     */
    public function setLiabilities($liabilities)
    {
        $this->container['liabilities'] = $liabilities;

        return $this;
    }

    /**
     * Gets currentLiabilities
     *
     * @return int
     */
    public function getCurrentLiabilities()
    {
        return $this->container['currentLiabilities'];
    }

    /**
     * Sets currentLiabilities
     *
     * @param int $currentLiabilities currentLiabilities
     *
     * @return $this
     */
    public function setCurrentLiabilities($currentLiabilities)
    {
        $this->container['currentLiabilities'] = $currentLiabilities;

        return $this;
    }

    /**
     * Gets currentAccountsPayable
     *
     * @return int
     */
    public function getCurrentAccountsPayable()
    {
        return $this->container['currentAccountsPayable'];
    }

    /**
     * Sets currentAccountsPayable
     *
     * @param int $currentAccountsPayable currentAccountsPayable
     *
     * @return $this
     */
    public function setCurrentAccountsPayable($currentAccountsPayable)
    {
        $this->container['currentAccountsPayable'] = $currentAccountsPayable;

        return $this;
    }

    /**
     * Gets deferredRevenue
     *
     * @return int
     */
    public function getDeferredRevenue()
    {
        return $this->container['deferredRevenue'];
    }

    /**
     * Sets deferredRevenue
     *
     * @param int $deferredRevenue deferredRevenue
     *
     * @return $this
     */
    public function setDeferredRevenue($deferredRevenue)
    {
        $this->container['deferredRevenue'] = $deferredRevenue;

        return $this;
    }

    /**
     * Gets currentDebt
     *
     * @return int
     */
    public function getCurrentDebt()
    {
        return $this->container['currentDebt'];
    }

    /**
     * Sets currentDebt
     *
     * @param int $currentDebt currentDebt
     *
     * @return $this
     */
    public function setCurrentDebt($currentDebt)
    {
        $this->container['currentDebt'] = $currentDebt;

        return $this;
    }

    /**
     * Gets shortTermDebt
     *
     * @return int
     */
    public function getShortTermDebt()
    {
        return $this->container['shortTermDebt'];
    }

    /**
     * Sets shortTermDebt
     *
     * @param int $shortTermDebt shortTermDebt
     *
     * @return $this
     */
    public function setShortTermDebt($shortTermDebt)
    {
        $this->container['shortTermDebt'] = $shortTermDebt;

        return $this;
    }

    /**
     * Gets nonCurrentLiabilities
     *
     * @return int
     */
    public function getNonCurrentLiabilities()
    {
        return $this->container['nonCurrentLiabilities'];
    }

    /**
     * Sets nonCurrentLiabilities
     *
     * @param int $nonCurrentLiabilities nonCurrentLiabilities
     *
     * @return $this
     */
    public function setNonCurrentLiabilities($nonCurrentLiabilities)
    {
        $this->container['nonCurrentLiabilities'] = $nonCurrentLiabilities;

        return $this;
    }

    /**
     * Gets capitalLeaseObligations
     *
     * @return int
     */
    public function getCapitalLeaseObligations()
    {
        return $this->container['capitalLeaseObligations'];
    }

    /**
     * Sets capitalLeaseObligations
     *
     * @param int $capitalLeaseObligations capitalLeaseObligations
     *
     * @return $this
     */
    public function setCapitalLeaseObligations($capitalLeaseObligations)
    {
        $this->container['capitalLeaseObligations'] = $capitalLeaseObligations;

        return $this;
    }

    /**
     * Gets longTermDebt
     *
     * @return int
     */
    public function getLongTermDebt()
    {
        return $this->container['longTermDebt'];
    }

    /**
     * Sets longTermDebt
     *
     * @param int $longTermDebt longTermDebt
     *
     * @return $this
     */
    public function setLongTermDebt($longTermDebt)
    {
        $this->container['longTermDebt'] = $longTermDebt;

        return $this;
    }

    /**
     * Gets currentLongTermDebt
     *
     * @return int
     */
    public function getCurrentLongTermDebt()
    {
        return $this->container['currentLongTermDebt'];
    }

    /**
     * Sets currentLongTermDebt
     *
     * @param int $currentLongTermDebt currentLongTermDebt
     *
     * @return $this
     */
    public function setCurrentLongTermDebt($currentLongTermDebt)
    {
        $this->container['currentLongTermDebt'] = $currentLongTermDebt;

        return $this;
    }

    /**
     * Gets longTermDebtNonCurrent
     *
     * @return int
     */
    public function getLongTermDebtNonCurrent()
    {
        return $this->container['longTermDebtNonCurrent'];
    }

    /**
     * Sets longTermDebtNonCurrent
     *
     * @param int $longTermDebtNonCurrent longTermDebtNonCurrent
     *
     * @return $this
     */
    public function setLongTermDebtNonCurrent($longTermDebtNonCurrent)
    {
        $this->container['longTermDebtNonCurrent'] = $longTermDebtNonCurrent;

        return $this;
    }

    /**
     * Gets shortLongTermDebtTotal
     *
     * @return int
     */
    public function getShortLongTermDebtTotal()
    {
        return $this->container['shortLongTermDebtTotal'];
    }

    /**
     * Sets shortLongTermDebtTotal
     *
     * @param int $shortLongTermDebtTotal shortLongTermDebtTotal
     *
     * @return $this
     */
    public function setShortLongTermDebtTotal($shortLongTermDebtTotal)
    {
        $this->container['shortLongTermDebtTotal'] = $shortLongTermDebtTotal;

        return $this;
    }

    /**
     * Gets otherCurrentLiabilities
     *
     * @return int
     */
    public function getOtherCurrentLiabilities()
    {
        return $this->container['otherCurrentLiabilities'];
    }

    /**
     * Sets otherCurrentLiabilities
     *
     * @param int $otherCurrentLiabilities otherCurrentLiabilities
     *
     * @return $this
     */
    public function setOtherCurrentLiabilities($otherCurrentLiabilities)
    {
        $this->container['otherCurrentLiabilities'] = $otherCurrentLiabilities;

        return $this;
    }

    /**
     * Gets otherNonCurrentLiabilities
     *
     * @return int
     */
    public function getOtherNonCurrentLiabilities()
    {
        return $this->container['otherNonCurrentLiabilities'];
    }

    /**
     * Sets otherNonCurrentLiabilities
     *
     * @param int $otherNonCurrentLiabilities otherNonCurrentLiabilities
     *
     * @return $this
     */
    public function setOtherNonCurrentLiabilities($otherNonCurrentLiabilities)
    {
        $this->container['otherNonCurrentLiabilities'] = $otherNonCurrentLiabilities;

        return $this;
    }

    /**
     * Gets equity
     *
     * @return int
     */
    public function getEquity()
    {
        return $this->container['equity'];
    }

    /**
     * Sets equity
     *
     * @param int $equity equity
     *
     * @return $this
     */
    public function setEquity($equity)
    {
        $this->container['equity'] = $equity;

        return $this;
    }

    /**
     * Gets treasuryStock
     *
     * @return int
     */
    public function getTreasuryStock()
    {
        return $this->container['treasuryStock'];
    }

    /**
     * Sets treasuryStock
     *
     * @param int $treasuryStock treasuryStock
     *
     * @return $this
     */
    public function setTreasuryStock($treasuryStock)
    {
        $this->container['treasuryStock'] = $treasuryStock;

        return $this;
    }

    /**
     * Gets retainedEarnings
     *
     * @return int
     */
    public function getRetainedEarnings()
    {
        return $this->container['retainedEarnings'];
    }

    /**
     * Sets retainedEarnings
     *
     * @param int $retainedEarnings retainedEarnings
     *
     * @return $this
     */
    public function setRetainedEarnings($retainedEarnings)
    {
        $this->container['retainedEarnings'] = $retainedEarnings;

        return $this;
    }

    /**
     * Gets commonStock
     *
     * @return int
     */
    public function getCommonStock()
    {
        return $this->container['commonStock'];
    }

    /**
     * Sets commonStock
     *
     * @param int $commonStock commonStock
     *
     * @return $this
     */
    public function setCommonStock($commonStock)
    {
        $this->container['commonStock'] = $commonStock;

        return $this;
    }

    /**
     * Gets sharesOutstanding
     *
     * @return int
     */
    public function getSharesOutstanding()
    {
        return $this->container['sharesOutstanding'];
    }

    /**
     * Sets sharesOutstanding
     *
     * @param int $sharesOutstanding sharesOutstanding
     *
     * @return $this
     */
    public function setSharesOutstanding($sharesOutstanding)
    {
        $this->container['sharesOutstanding'] = $sharesOutstanding;

        return $this;
    }

    /**
     * Gets accumulatedOtherComprehensiveIncome
     *
     * @return int
     */
    public function getAccumulatedOtherComprehensiveIncome()
    {
        return $this->container['accumulatedOtherComprehensiveIncome'];
    }

    /**
     * Sets accumulatedOtherComprehensiveIncome
     *
     * @param int $accumulatedOtherComprehensiveIncome accumulatedOtherComprehensiveIncome
     *
     * @return $this
     */
    public function setAccumulatedOtherComprehensiveIncome($accumulatedOtherComprehensiveIncome)
    {
        $this->container['accumulatedOtherComprehensiveIncome'] = $accumulatedOtherComprehensiveIncome;

        return $this;
    }

    /**
     * Gets workingCapital
     *
     * @return int
     */
    public function getWorkingCapital()
    {
        return $this->container['workingCapital'];
    }

    /**
     * Sets workingCapital
     *
     * @param int $workingCapital workingCapital
     *
     * @return $this
     */
    public function setWorkingCapital($workingCapital)
    {
        $this->container['workingCapital'] = $workingCapital;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
