<?php
/**
 * TransactionsApi
 * PHP version 5
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Stocks
 *
 * <h3>Rate limits</h3>                     Free subscriptions are subject to daily limits. To know how much requests you have left look at the following headers in the response.<br />                     1. <strong>x-ratelimit-limit</strong> - The total number of requests that you are allowed to make in a given period (hour/day)<br />                     2. <strong>x-ratelimit-remaining</strong> - The number of remaining requests that you can perform in the current period.<br />                     3. <strong>x-ratelimit-reset</strong> - The number of seconds until the current period resets.<br />                     <br />                     <br />                     You don't have an API key? <a href=\"https://www.equibles.com/api/pricing\" target=\"_blank\">Get one for free here.</a>
 *
 * OpenAPI spec version: v1
 * Contact: contact@equibles.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.34
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EquiblesStocks\Clients;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use EquiblesStocks\ApiException;
use EquiblesStocks\Configuration;
use EquiblesStocks\HeaderSelector;
use EquiblesStocks\ObjectSerializer;

/**
 * TransactionsApi Class Doc Comment
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TransactionsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation insiders
     *
     * Insider Transactions
     *
     * @param  string $apiKey apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\TransactionsResponse
     */
    public function insiders($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        list($response) = $this->insidersWithHttpInfo($apiKey, $fullTicker, $page, $pageSize);
        return $response;
    }

    /**
     * Operation insidersWithHttpInfo
     *
     * Insider Transactions
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\TransactionsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function insidersWithHttpInfo($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        $returnType = '\EquiblesStocks\Models\TransactionsResponse';
        $request = $this->insidersRequest($apiKey, $fullTicker, $page, $pageSize);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\TransactionsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation insidersAsync
     *
     * Insider Transactions
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function insidersAsync($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        return $this->insidersAsyncWithHttpInfo($apiKey, $fullTicker, $page, $pageSize)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation insidersAsyncWithHttpInfo
     *
     * Insider Transactions
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function insidersAsyncWithHttpInfo($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        $returnType = '\EquiblesStocks\Models\TransactionsResponse';
        $request = $this->insidersRequest($apiKey, $fullTicker, $page, $pageSize);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'insiders'
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function insidersRequest($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling insiders'
            );
        }
        // verify the required parameter 'fullTicker' is set
        if ($fullTicker === null || (is_array($fullTicker) && count($fullTicker) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fullTicker when calling insiders'
            );
        }

        $resourcePath = '/stocks/transactions/insiders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($fullTicker !== null) {
            $queryParams['fullTicker'] = ObjectSerializer::toQueryValue($fullTicker, null);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page, 'int32');
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toQueryValue($pageSize, 'int32');
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation institutional
     *
     * Institutional Transactions
     *
     * @param  string $apiKey apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\TransactionsResponse
     */
    public function institutional($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        list($response) = $this->institutionalWithHttpInfo($apiKey, $fullTicker, $page, $pageSize);
        return $response;
    }

    /**
     * Operation institutionalWithHttpInfo
     *
     * Institutional Transactions
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\TransactionsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function institutionalWithHttpInfo($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        $returnType = '\EquiblesStocks\Models\TransactionsResponse';
        $request = $this->institutionalRequest($apiKey, $fullTicker, $page, $pageSize);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\TransactionsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation institutionalAsync
     *
     * Institutional Transactions
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function institutionalAsync($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        return $this->institutionalAsyncWithHttpInfo($apiKey, $fullTicker, $page, $pageSize)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation institutionalAsyncWithHttpInfo
     *
     * Institutional Transactions
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function institutionalAsyncWithHttpInfo($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        $returnType = '\EquiblesStocks\Models\TransactionsResponse';
        $request = $this->institutionalRequest($apiKey, $fullTicker, $page, $pageSize);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'institutional'
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function institutionalRequest($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling institutional'
            );
        }
        // verify the required parameter 'fullTicker' is set
        if ($fullTicker === null || (is_array($fullTicker) && count($fullTicker) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fullTicker when calling institutional'
            );
        }

        $resourcePath = '/stocks/transactions/institutional';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($fullTicker !== null) {
            $queryParams['fullTicker'] = ObjectSerializer::toQueryValue($fullTicker, null);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page, 'int32');
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toQueryValue($pageSize, 'int32');
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
