<?php
/**
 * StocksApi
 * PHP version 5
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Stocks
 *
 * <h3>Rate limits</h3>                     Free subscriptions are subject to daily limits. To know how much requests you have left look at the following headers in the response.<br />                     1. <strong>x-ratelimit-limit</strong> - The total number of requests that you are allowed to make in a given period (hour/day)<br />                     2. <strong>x-ratelimit-remaining</strong> - The number of remaining requests that you can perform in the current period.<br />                     3. <strong>x-ratelimit-reset</strong> - The number of seconds until the current period resets.<br />                     <br />                     <br />                     You don't have an API key? <a href=\"https://www.equibles.com/api/pricing\" target=\"_blank\">Get one for free here.</a>
 *
 * OpenAPI spec version: v1
 * Contact: contact@equibles.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.34
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EquiblesStocks\Clients;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use EquiblesStocks\ApiException;
use EquiblesStocks\Configuration;
use EquiblesStocks\HeaderSelector;
use EquiblesStocks\ObjectSerializer;

/**
 * StocksApi Class Doc Comment
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class StocksApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation callList
     *
     * List Stocks
     *
     * @param  string $apiKey apiKey (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\StockProfilesResponse
     */
    public function callList($apiKey, $page = '1', $pageSize = '100')
    {
        list($response) = $this->callListWithHttpInfo($apiKey, $page, $pageSize);
        return $response;
    }

    /**
     * Operation callListWithHttpInfo
     *
     * List Stocks
     *
     * @param  string $apiKey (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\StockProfilesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function callListWithHttpInfo($apiKey, $page = '1', $pageSize = '100')
    {
        $returnType = '\EquiblesStocks\Models\StockProfilesResponse';
        $request = $this->callListRequest($apiKey, $page, $pageSize);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\StockProfilesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation callListAsync
     *
     * List Stocks
     *
     * @param  string $apiKey (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function callListAsync($apiKey, $page = '1', $pageSize = '100')
    {
        return $this->callListAsyncWithHttpInfo($apiKey, $page, $pageSize)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation callListAsyncWithHttpInfo
     *
     * List Stocks
     *
     * @param  string $apiKey (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function callListAsyncWithHttpInfo($apiKey, $page = '1', $pageSize = '100')
    {
        $returnType = '\EquiblesStocks\Models\StockProfilesResponse';
        $request = $this->callListRequest($apiKey, $page, $pageSize);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'callList'
     *
     * @param  string $apiKey (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function callListRequest($apiKey, $page = '1', $pageSize = '100')
    {
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling callList'
            );
        }

        $resourcePath = '/stocks/list';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page, 'int32');
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toQueryValue($pageSize, 'int32');
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation officers
     *
     * Officers
     *
     * @param  string $apiKey apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\OfficersResponse
     */
    public function officers($apiKey, $fullTicker)
    {
        list($response) = $this->officersWithHttpInfo($apiKey, $fullTicker);
        return $response;
    }

    /**
     * Operation officersWithHttpInfo
     *
     * Officers
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\OfficersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function officersWithHttpInfo($apiKey, $fullTicker)
    {
        $returnType = '\EquiblesStocks\Models\OfficersResponse';
        $request = $this->officersRequest($apiKey, $fullTicker);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\OfficersResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation officersAsync
     *
     * Officers
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function officersAsync($apiKey, $fullTicker)
    {
        return $this->officersAsyncWithHttpInfo($apiKey, $fullTicker)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation officersAsyncWithHttpInfo
     *
     * Officers
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function officersAsyncWithHttpInfo($apiKey, $fullTicker)
    {
        $returnType = '\EquiblesStocks\Models\OfficersResponse';
        $request = $this->officersRequest($apiKey, $fullTicker);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'officers'
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function officersRequest($apiKey, $fullTicker)
    {
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling officers'
            );
        }
        // verify the required parameter 'fullTicker' is set
        if ($fullTicker === null || (is_array($fullTicker) && count($fullTicker) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fullTicker when calling officers'
            );
        }

        $resourcePath = '/stocks/officers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($fullTicker !== null) {
            $queryParams['fullTicker'] = ObjectSerializer::toQueryValue($fullTicker, null);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation profile
     *
     * Profile
     *
     * @param  string $apiKey apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\StockProfileResponse
     */
    public function profile($apiKey, $fullTicker)
    {
        list($response) = $this->profileWithHttpInfo($apiKey, $fullTicker);
        return $response;
    }

    /**
     * Operation profileWithHttpInfo
     *
     * Profile
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\StockProfileResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function profileWithHttpInfo($apiKey, $fullTicker)
    {
        $returnType = '\EquiblesStocks\Models\StockProfileResponse';
        $request = $this->profileRequest($apiKey, $fullTicker);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\StockProfileResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation profileAsync
     *
     * Profile
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function profileAsync($apiKey, $fullTicker)
    {
        return $this->profileAsyncWithHttpInfo($apiKey, $fullTicker)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation profileAsyncWithHttpInfo
     *
     * Profile
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function profileAsyncWithHttpInfo($apiKey, $fullTicker)
    {
        $returnType = '\EquiblesStocks\Models\StockProfileResponse';
        $request = $this->profileRequest($apiKey, $fullTicker);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'profile'
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function profileRequest($apiKey, $fullTicker)
    {
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling profile'
            );
        }
        // verify the required parameter 'fullTicker' is set
        if ($fullTicker === null || (is_array($fullTicker) && count($fullTicker) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fullTicker when calling profile'
            );
        }

        $resourcePath = '/stocks/profile';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($fullTicker !== null) {
            $queryParams['fullTicker'] = ObjectSerializer::toQueryValue($fullTicker, null);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation screener
     *
     * Screener
     *
     * @param  \EquiblesStocks\Models\ScreenerRequest $body The criteria used to filter the search results. You only need to fill the fields that you want to use on the search. (required)
     * @param  string $apiKey apiKey (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\StockProfilesResponse
     */
    public function screener($body, $apiKey, $page = '1', $pageSize = '100')
    {
        list($response) = $this->screenerWithHttpInfo($body, $apiKey, $page, $pageSize);
        return $response;
    }

    /**
     * Operation screenerWithHttpInfo
     *
     * Screener
     *
     * @param  \EquiblesStocks\Models\ScreenerRequest $body The criteria used to filter the search results. You only need to fill the fields that you want to use on the search. (required)
     * @param  string $apiKey (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\StockProfilesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function screenerWithHttpInfo($body, $apiKey, $page = '1', $pageSize = '100')
    {
        $returnType = '\EquiblesStocks\Models\StockProfilesResponse';
        $request = $this->screenerRequest($body, $apiKey, $page, $pageSize);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\StockProfilesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation screenerAsync
     *
     * Screener
     *
     * @param  \EquiblesStocks\Models\ScreenerRequest $body The criteria used to filter the search results. You only need to fill the fields that you want to use on the search. (required)
     * @param  string $apiKey (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function screenerAsync($body, $apiKey, $page = '1', $pageSize = '100')
    {
        return $this->screenerAsyncWithHttpInfo($body, $apiKey, $page, $pageSize)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation screenerAsyncWithHttpInfo
     *
     * Screener
     *
     * @param  \EquiblesStocks\Models\ScreenerRequest $body The criteria used to filter the search results. You only need to fill the fields that you want to use on the search. (required)
     * @param  string $apiKey (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function screenerAsyncWithHttpInfo($body, $apiKey, $page = '1', $pageSize = '100')
    {
        $returnType = '\EquiblesStocks\Models\StockProfilesResponse';
        $request = $this->screenerRequest($body, $apiKey, $page, $pageSize);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'screener'
     *
     * @param  \EquiblesStocks\Models\ScreenerRequest $body The criteria used to filter the search results. You only need to fill the fields that you want to use on the search. (required)
     * @param  string $apiKey (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function screenerRequest($body, $apiKey, $page = '1', $pageSize = '100')
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling screener'
            );
        }
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling screener'
            );
        }

        $resourcePath = '/stocks/screener';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page, 'int32');
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toQueryValue($pageSize, 'int32');
        }


        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation search
     *
     * Search
     *
     * @param  string $apiKey apiKey (required)
     * @param  string $text The text to search for. (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\StockProfilesResponse
     */
    public function search($apiKey, $text, $page = '1', $pageSize = '100')
    {
        list($response) = $this->searchWithHttpInfo($apiKey, $text, $page, $pageSize);
        return $response;
    }

    /**
     * Operation searchWithHttpInfo
     *
     * Search
     *
     * @param  string $apiKey (required)
     * @param  string $text The text to search for. (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\StockProfilesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchWithHttpInfo($apiKey, $text, $page = '1', $pageSize = '100')
    {
        $returnType = '\EquiblesStocks\Models\StockProfilesResponse';
        $request = $this->searchRequest($apiKey, $text, $page, $pageSize);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\StockProfilesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation searchAsync
     *
     * Search
     *
     * @param  string $apiKey (required)
     * @param  string $text The text to search for. (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchAsync($apiKey, $text, $page = '1', $pageSize = '100')
    {
        return $this->searchAsyncWithHttpInfo($apiKey, $text, $page, $pageSize)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchAsyncWithHttpInfo
     *
     * Search
     *
     * @param  string $apiKey (required)
     * @param  string $text The text to search for. (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchAsyncWithHttpInfo($apiKey, $text, $page = '1', $pageSize = '100')
    {
        $returnType = '\EquiblesStocks\Models\StockProfilesResponse';
        $request = $this->searchRequest($apiKey, $text, $page, $pageSize);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'search'
     *
     * @param  string $apiKey (required)
     * @param  string $text The text to search for. (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 100. (optional, default to 100)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function searchRequest($apiKey, $text, $page = '1', $pageSize = '100')
    {
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling search'
            );
        }
        // verify the required parameter 'text' is set
        if ($text === null || (is_array($text) && count($text) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $text when calling search'
            );
        }

        $resourcePath = '/stocks/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($text !== null) {
            $queryParams['text'] = ObjectSerializer::toQueryValue($text, null);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page, 'int32');
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toQueryValue($pageSize, 'int32');
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation splits
     *
     * Splits
     *
     * @param  string $apiKey apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\SplitsResponse
     */
    public function splits($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        list($response) = $this->splitsWithHttpInfo($apiKey, $fullTicker, $page, $pageSize);
        return $response;
    }

    /**
     * Operation splitsWithHttpInfo
     *
     * Splits
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\SplitsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function splitsWithHttpInfo($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        $returnType = '\EquiblesStocks\Models\SplitsResponse';
        $request = $this->splitsRequest($apiKey, $fullTicker, $page, $pageSize);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\SplitsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation splitsAsync
     *
     * Splits
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function splitsAsync($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        return $this->splitsAsyncWithHttpInfo($apiKey, $fullTicker, $page, $pageSize)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation splitsAsyncWithHttpInfo
     *
     * Splits
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function splitsAsyncWithHttpInfo($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        $returnType = '\EquiblesStocks\Models\SplitsResponse';
        $request = $this->splitsRequest($apiKey, $fullTicker, $page, $pageSize);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'splits'
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 1000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function splitsRequest($apiKey, $fullTicker, $page = '1', $pageSize = '1000')
    {
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling splits'
            );
        }
        // verify the required parameter 'fullTicker' is set
        if ($fullTicker === null || (is_array($fullTicker) && count($fullTicker) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fullTicker when calling splits'
            );
        }

        $resourcePath = '/stocks/splits';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($fullTicker !== null) {
            $queryParams['fullTicker'] = ObjectSerializer::toQueryValue($fullTicker, null);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page, 'int32');
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toQueryValue($pageSize, 'int32');
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
