<?php
/**
 * PricesApi
 * PHP version 5
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Stocks
 *
 * <h3>Rate limits</h3>                     Free subscriptions are subject to daily limits. To know how much requests you have left look at the following headers in the response.<br />                     1. <strong>x-ratelimit-limit</strong> - The total number of requests that you are allowed to make in a given period (hour/day)<br />                     2. <strong>x-ratelimit-remaining</strong> - The number of remaining requests that you can perform in the current period.<br />                     3. <strong>x-ratelimit-reset</strong> - The number of seconds until the current period resets.<br />                     <br />                     <br />                     You don't have an API key? <a href=\"https://www.equibles.com/api/pricing\" target=\"_blank\">Get one for free here.</a>
 *
 * OpenAPI spec version: v1
 * Contact: contact@equibles.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.34
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace EquiblesStocks\Clients;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use EquiblesStocks\ApiException;
use EquiblesStocks\Configuration;
use EquiblesStocks\HeaderSelector;
use EquiblesStocks\ObjectSerializer;

/**
 * PricesApi Class Doc Comment
 *
 * @category Class
 * @package  EquiblesStocks
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class PricesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation endOfDay
     *
     * End Of Day Prices
     *
     * @param  string $apiKey apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  \DateTime $startTime The start time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \DateTime $endTime The end time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \EquiblesStocks\Models\Sort $sort The method of sorting the results. The sorting is based on the time axis. (optional)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 50000. (optional, default to 1000)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\PricesResponse
     */
    public function endOfDay($apiKey, $fullTicker, $startTime = null, $endTime = null, $sort = null, $page = '1', $pageSize = '1000')
    {
        list($response) = $this->endOfDayWithHttpInfo($apiKey, $fullTicker, $startTime, $endTime, $sort, $page, $pageSize);
        return $response;
    }

    /**
     * Operation endOfDayWithHttpInfo
     *
     * End Of Day Prices
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  \DateTime $startTime The start time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \DateTime $endTime The end time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \EquiblesStocks\Models\Sort $sort The method of sorting the results. The sorting is based on the time axis. (optional)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 50000. (optional, default to 1000)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\PricesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function endOfDayWithHttpInfo($apiKey, $fullTicker, $startTime = null, $endTime = null, $sort = null, $page = '1', $pageSize = '1000')
    {
        $returnType = '\EquiblesStocks\Models\PricesResponse';
        $request = $this->endOfDayRequest($apiKey, $fullTicker, $startTime, $endTime, $sort, $page, $pageSize);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\PricesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation endOfDayAsync
     *
     * End Of Day Prices
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  \DateTime $startTime The start time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \DateTime $endTime The end time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \EquiblesStocks\Models\Sort $sort The method of sorting the results. The sorting is based on the time axis. (optional)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 50000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function endOfDayAsync($apiKey, $fullTicker, $startTime = null, $endTime = null, $sort = null, $page = '1', $pageSize = '1000')
    {
        return $this->endOfDayAsyncWithHttpInfo($apiKey, $fullTicker, $startTime, $endTime, $sort, $page, $pageSize)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation endOfDayAsyncWithHttpInfo
     *
     * End Of Day Prices
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  \DateTime $startTime The start time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \DateTime $endTime The end time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \EquiblesStocks\Models\Sort $sort The method of sorting the results. The sorting is based on the time axis. (optional)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 50000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function endOfDayAsyncWithHttpInfo($apiKey, $fullTicker, $startTime = null, $endTime = null, $sort = null, $page = '1', $pageSize = '1000')
    {
        $returnType = '\EquiblesStocks\Models\PricesResponse';
        $request = $this->endOfDayRequest($apiKey, $fullTicker, $startTime, $endTime, $sort, $page, $pageSize);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'endOfDay'
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  \DateTime $startTime The start time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \DateTime $endTime The end time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \EquiblesStocks\Models\Sort $sort The method of sorting the results. The sorting is based on the time axis. (optional)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 50000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function endOfDayRequest($apiKey, $fullTicker, $startTime = null, $endTime = null, $sort = null, $page = '1', $pageSize = '1000')
    {
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling endOfDay'
            );
        }
        // verify the required parameter 'fullTicker' is set
        if ($fullTicker === null || (is_array($fullTicker) && count($fullTicker) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fullTicker when calling endOfDay'
            );
        }

        $resourcePath = '/stocks/prices/endofday';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($fullTicker !== null) {
            $queryParams['fullTicker'] = ObjectSerializer::toQueryValue($fullTicker, null);
        }
        // query params
        if ($startTime !== null) {
            $queryParams['startTime'] = ObjectSerializer::toQueryValue($startTime, 'date-time');
        }
        // query params
        if ($endTime !== null) {
            $queryParams['endTime'] = ObjectSerializer::toQueryValue($endTime, 'date-time');
        }
        // query params
        if ($sort !== null) {
            $queryParams['sort'] = ObjectSerializer::toQueryValue($sort, null);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page, 'int32');
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toQueryValue($pageSize, 'int32');
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation intraday
     *
     * Intraday Prices
     *
     * @param  string $apiKey apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  \DateTime $startTime The start time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \DateTime $endTime The end time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \EquiblesStocks\Models\Sort $sort The method of sorting the results. The sorting is based on the time axis. (optional)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 50000. (optional, default to 1000)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\PricesResponse
     */
    public function intraday($apiKey, $fullTicker, $startTime = null, $endTime = null, $sort = null, $page = '1', $pageSize = '1000')
    {
        list($response) = $this->intradayWithHttpInfo($apiKey, $fullTicker, $startTime, $endTime, $sort, $page, $pageSize);
        return $response;
    }

    /**
     * Operation intradayWithHttpInfo
     *
     * Intraday Prices
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  \DateTime $startTime The start time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \DateTime $endTime The end time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \EquiblesStocks\Models\Sort $sort The method of sorting the results. The sorting is based on the time axis. (optional)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 50000. (optional, default to 1000)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\PricesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function intradayWithHttpInfo($apiKey, $fullTicker, $startTime = null, $endTime = null, $sort = null, $page = '1', $pageSize = '1000')
    {
        $returnType = '\EquiblesStocks\Models\PricesResponse';
        $request = $this->intradayRequest($apiKey, $fullTicker, $startTime, $endTime, $sort, $page, $pageSize);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\PricesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation intradayAsync
     *
     * Intraday Prices
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  \DateTime $startTime The start time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \DateTime $endTime The end time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \EquiblesStocks\Models\Sort $sort The method of sorting the results. The sorting is based on the time axis. (optional)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 50000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function intradayAsync($apiKey, $fullTicker, $startTime = null, $endTime = null, $sort = null, $page = '1', $pageSize = '1000')
    {
        return $this->intradayAsyncWithHttpInfo($apiKey, $fullTicker, $startTime, $endTime, $sort, $page, $pageSize)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation intradayAsyncWithHttpInfo
     *
     * Intraday Prices
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  \DateTime $startTime The start time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \DateTime $endTime The end time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \EquiblesStocks\Models\Sort $sort The method of sorting the results. The sorting is based on the time axis. (optional)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 50000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function intradayAsyncWithHttpInfo($apiKey, $fullTicker, $startTime = null, $endTime = null, $sort = null, $page = '1', $pageSize = '1000')
    {
        $returnType = '\EquiblesStocks\Models\PricesResponse';
        $request = $this->intradayRequest($apiKey, $fullTicker, $startTime, $endTime, $sort, $page, $pageSize);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'intraday'
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     * @param  \DateTime $startTime The start time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \DateTime $endTime The end time of the window. UTC time formatted according to ISO 8601 (i.e: 2022-02-01T13:45:17) (optional)
     * @param  \EquiblesStocks\Models\Sort $sort The method of sorting the results. The sorting is based on the time axis. (optional)
     * @param  int $page The number of the page to request. (optional, default to 1)
     * @param  int $pageSize The number of elements in each page. Max value: 50000. (optional, default to 1000)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function intradayRequest($apiKey, $fullTicker, $startTime = null, $endTime = null, $sort = null, $page = '1', $pageSize = '1000')
    {
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling intraday'
            );
        }
        // verify the required parameter 'fullTicker' is set
        if ($fullTicker === null || (is_array($fullTicker) && count($fullTicker) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fullTicker when calling intraday'
            );
        }

        $resourcePath = '/stocks/prices/intraday';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($fullTicker !== null) {
            $queryParams['fullTicker'] = ObjectSerializer::toQueryValue($fullTicker, null);
        }
        // query params
        if ($startTime !== null) {
            $queryParams['startTime'] = ObjectSerializer::toQueryValue($startTime, 'date-time');
        }
        // query params
        if ($endTime !== null) {
            $queryParams['endTime'] = ObjectSerializer::toQueryValue($endTime, 'date-time');
        }
        // query params
        if ($sort !== null) {
            $queryParams['sort'] = ObjectSerializer::toQueryValue($sort, null);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = ObjectSerializer::toQueryValue($page, 'int32');
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toQueryValue($pageSize, 'int32');
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation summary
     *
     * Latest trading day summary
     *
     * @param  string $apiKey apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EquiblesStocks\Models\PriceSummaryResponse
     */
    public function summary($apiKey, $fullTicker)
    {
        list($response) = $this->summaryWithHttpInfo($apiKey, $fullTicker);
        return $response;
    }

    /**
     * Operation summaryWithHttpInfo
     *
     * Latest trading day summary
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \EquiblesStocks\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EquiblesStocks\Models\PriceSummaryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function summaryWithHttpInfo($apiKey, $fullTicker)
    {
        $returnType = '\EquiblesStocks\Models\PriceSummaryResponse';
        $request = $this->summaryRequest($apiKey, $fullTicker);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\PriceSummaryResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EquiblesStocks\Models\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation summaryAsync
     *
     * Latest trading day summary
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function summaryAsync($apiKey, $fullTicker)
    {
        return $this->summaryAsyncWithHttpInfo($apiKey, $fullTicker)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation summaryAsyncWithHttpInfo
     *
     * Latest trading day summary
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function summaryAsyncWithHttpInfo($apiKey, $fullTicker)
    {
        $returnType = '\EquiblesStocks\Models\PriceSummaryResponse';
        $request = $this->summaryRequest($apiKey, $fullTicker);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'summary'
     *
     * @param  string $apiKey (required)
     * @param  string $fullTicker The fully qualified ticker of the stock. Example: AAPL.XNAS (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function summaryRequest($apiKey, $fullTicker)
    {
        // verify the required parameter 'apiKey' is set
        if ($apiKey === null || (is_array($apiKey) && count($apiKey) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $apiKey when calling summary'
            );
        }
        // verify the required parameter 'fullTicker' is set
        if ($fullTicker === null || (is_array($fullTicker) && count($fullTicker) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $fullTicker when calling summary'
            );
        }

        $resourcePath = '/stocks/prices/summary';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($apiKey !== null) {
            $queryParams['apiKey'] = ObjectSerializer::toQueryValue($apiKey, null);
        }
        // query params
        if ($fullTicker !== null) {
            $queryParams['fullTicker'] = ObjectSerializer::toQueryValue($fullTicker, null);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('apiKey');
        if ($apiKey !== null) {
            $queryParams['apiKey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
