<?php

/**
 * Simple template engine.
 *
 * Copyright © 2023 Vitaly Buzin. All rights reserved.
 * See LICENSE.txt for license details.
 */
declare( strict_types=1 );

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Epnab_Viewer {
	/**
	 * @var array
	 */
	protected $data = [];

	/**
	 * @param string $key
	 *
	 * @return array | boolean
	 */
	public function getData( $key ) {
	return $this->data[ $key ] ?? false;
	}

	/**
	 * @param string $key
	 * @param $value
	 *
	 * @return void
	 */
	public function setData( $key, $value ) {
		$this->data[ $key ][] = $value;
	}

	/**
	 * @param null $key
	 *
	 * @return bool
	 */
	public function hasData( $key = null ) {
		if ( $key ) {
			return isset( $this->data[ $key ] );
		}

		return count( $this->data ) > 0;
	}

	/**
	 * @param string $template
	 *
	 * @return false|string
	 */
	public function render( $template ) {
		if ( ! is_file( $template ) ) {
			throw new RuntimeException( 'Template not found: ' . esc_html( $template ) );
		}

		// define a closure with a scope for the variable extraction
		$result = function ( $file, array $data = array() ) {
			ob_start();
			try {
				$params = $this->data;
				include $file;
			} catch ( Exception $e ) {
				ob_end_clean();
				throw $e;
			}

			return ob_get_clean();
		};

		// call the closure
		return $result( $template, $this->data );
	}

	/**
	 * @param $template
	 *
	 * @return void
	 */
	public function view( $template ) {
		if ( ! is_file( $template ) ) {
			throw new RuntimeException( 'Template not found: ' . esc_html( $template ) );
		}
		try {
			$params = $this->data;
			include $template;
		} catch ( Exception $e ) {
			ob_end_clean();
			throw $e;
		}
	}
}
