<?php

/**
 * File browser.
 *
 * Copyright © 2023 Vitaly Buzin. All rights reserved.
 * See LICENSE.txt for license details.
 */
declare( strict_types=1 );

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Epnab_FileIterator extends FilterIterator {
	/**
	 * @var mixed|null
	 */
	private $filter;

	/**
	 * @param $iterator
	 * @param $extensions
	 */
	public function __construct( $iterator, $extensions = null ) {
		parent::__construct( $iterator );
		$this->filter = $extensions;
	}

	/**
	 * @return bool
	 */
	public function accept() {
		$current = $this->current();

		return $current->isFile() && ! $current->isLink() &&
		       ( ! is_array( $this->filter ) || in_array( $current->getExtension(), $this->filter ) );
	}
}
