<?php

/**
 * Admin settings menu page.
 *
 * Copyright © 2023 Vitaly Buzin. All rights reserved.
 * See LICENSE.txt for license details.
 */
declare( strict_types=1 );

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

require_once EPNAB_DIR_CLASSES . 'Epnab_Viewer.php';

class Epnab_Admin {
	private static bool $initiated = false;

	public static function init(): void {
		if ( ! self::$initiated ) {
			self::init_hooks();
		}
	}

	public static function init_hooks(): void {
		add_action( 'admin_init', array( 'Epnab_Admin', 'admin_init' ) );
		add_action( 'admin_menu', array( 'Epnab_Admin', 'admin_menu' ) );
		add_action( 'admin_enqueue_scripts', array( 'Epnab_Admin', 'admin_scripts' ) );
	}

	public static function admin_init(): void {
		// Register a new setting.
		$args = [
			'type' => 'string',
			'sanitize_callback' => 'sanitize_text_field',
		];
		register_setting( 'epnab', 'epnab_license_key', $args );
		register_setting( 'epnab', 'epnab_ebay_campaign_id', $args );
		register_setting( 'epnab', 'epnab_keywords_title', $args );
		register_setting( 'epnab', 'epnab_keywords_tags', $args );
		register_setting( 'epnab', 'epnab_keywords_content', $args );
		register_setting( 'epnab', 'epnab_keywords_custom', $args );
		register_setting( 'epnab', 'epnab_keywords', $args );
		register_setting( 'epnab', 'epnab_keywords_strategy', $args );
		register_setting( 'epnab', 'epnab_keywords_count', $args );
		register_setting( 'epnab', 'epnab_stopwords', $args );
		register_setting( 'epnab', 'epnab_min_price', $args );
		register_setting( 'epnab', 'epnab_max_price', $args );
		register_setting( 'epnab', 'epnab_condition_new', $args );
		register_setting( 'epnab', 'epnab_condition_used', $args );
		register_setting( 'epnab', 'epnab_type_auction', $args );
		register_setting( 'epnab', 'epnab_type_classified', $args );
		register_setting( 'epnab', 'epnab_type_fixed', $args );
		register_setting( 'epnab', 'epnab_type_store', $args );
		register_setting( 'epnab', 'epnab_free_shipping', $args );
		register_setting( 'epnab', 'epnab_sort_order', $args );
		register_setting( 'epnab', 'epnab_page_size', $args );
		register_setting( 'epnab', 'epnab_template', $args );
		register_setting( 'epnab', 'epnab_carousel', $args );
		register_setting( 'epnab', 'epnab_position', $args );
		register_setting( 'epnab', 'epnab_button_color', $args );
		register_setting( 'epnab', 'epnab_button_hover_color', $args );
		register_setting( 'epnab', 'epnab_button_text_color', $args );
		register_setting( 'epnab', 'epnab_button_text_hover_color', $args );
		register_setting( 'epnab', 'epnab_button_border_radius', $args );
	}

	/**
	 * Add the options menu item to the sidebar settings panel.
	 */
	public static function admin_menu(): void {
		// Add the options page to the settings menu.
		add_options_page( "eBay Partner Network Affiliate Banner", "ePN Affiliate Banner", "manage_options",
			'epnab-settings',
			array( "Epnab_Admin", "options" ) );
		add_option( 'epnab_license_key' );
		add_option( 'epnab_ebay_campaign_id' );
		add_option( 'epnab_keywords_title', '1' );
		add_option( 'epnab_keywords_tags', '1' );
		add_option( 'epnab_keywords_content', '1' );
		add_option( 'epnab_keywords_custom', '1' );
		add_option( 'epnab_keywords', 'apple,oppo,lg,zte,samsung,xiaomi' );
		add_option( 'epnab_keywords_strategy', 'random' );
		add_option( 'epnab_keywords_count', '3' );
		add_option( 'epnab_stopwords' );
		add_option( 'epnab_min_price' );
		add_option( 'epnab_max_price' );
		add_option( 'epnab_condition_new', '1' );
		add_option( 'epnab_condition_used' );
		add_option( 'epnab_type_auction', '1' );
		add_option( 'epnab_type_classified' );
		add_option( 'epnab_type_fixed', '1' );
		add_option( 'epnab_type_store', '1' );
		add_option( 'epnab_free_shipping' );
		add_option( 'epnab_sort_order', 'random' );
		add_option( 'epnab_page_size', '20' );
		add_option( 'epnab_template', 'center.phtml' );
		add_option( 'epnab_carousel' );
		add_option( 'epnab_position', 'before' );
		add_option( 'epnab_button_color' );
		add_option( 'epnab_button_hover_color' );
		add_option( 'epnab_button_text_color' );
		add_option( 'epnab_button_text_hover_color' );
		add_option( 'epnab_button_border_radius', '20' );
	}

	/**
	 * @param $hook_suffix
	 *
	 * @return void
	 */
	public static function admin_scripts( $hook_suffix ): void {
		wp_register_style( 'epnab-admin', plugin_dir_url( __FILE__ ) . EPNAB_PATH_CSS . 'admin.css', [], EPNAB_VERSION );
		wp_enqueue_style( 'epnab-admin' );
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'epnab_color_picker',
			plugins_url( EPNAB_PATH_JS . 'color-picker.js', __DIR__ ),
			array( 'wp-color-picker' ),
			EPNAB_VERSION,
			true );
		wp_enqueue_script( 'epnab_stopwords',
			plugins_url( EPNAB_PATH_JS . 'stopwords.js', __DIR__ ),
			array(),
			EPNAB_VERSION,
			true );
	}

	/**
	 * @return void
	 * @throws Exception
	 */
	public static function options(): void {
		// Check user capabilities.
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		$viewer = new Epnab_Viewer();
		$viewer->view( EPNAB_DIR_VIEWS . 'options.phtml' );
	}
}
