<?php
/**
 * Plugin Name: ePayments Gateway for WooCommerce
 * Description: A payment gateway plugin for WooCommerce that integrates with ePayments
 * Version: 1.0.0
 * Author: Kenny Chen
 * Text Domain: epayments-gateway-for-woocommerce
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * Requires Plugins: woocommerce
 * WC requires at least: 3.0
 * WC tested up to: 8.0
 * License: GPL v2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

defined('ABSPATH') || exit;

// Make sure WooCommerce is active
if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    return;
}

/**
 * Initialize the gateway class
 */
function epayments_gateway_wc_init() {
    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }
    require_once plugin_dir_path(__FILE__) . 'includes/class-wc-gateway-epayments.php';
}
add_action('plugins_loaded', 'epayments_gateway_wc_init');

/**
 * Add the gateway to WooCommerce
 */
function epayments_gateway_wc_add_gateway($methods) {
    $methods[] = 'Epayments_Gateway_WC_Payment';
    return $methods;
}
add_filter('woocommerce_payment_gateways', 'epayments_gateway_wc_add_gateway');