/**
 * Engineo Admin JavaScript
 * 
 * @package Engineo
 */

jQuery(document).ready(function($) {
    'use strict';
    
    // AJAX functionality for admin pages
    // This file is ready for future AJAX implementations
    
    // Example AJAX call structure:
    /*
    function performAjaxAction(data) {
        $.ajax({
            url: engineo_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'engineo_ajax_action',
                nonce: engineo_ajax.nonce,
                ...data
            },
            success: function(response) {
                // Handle success
            },
            error: function(xhr, status, error) {
                // Handle error
            }
        });
    }
    */
    
    // Character counter for meta descriptions
    $('textarea[name="engineo_meta_description"]').on('input', function() {
        var length = $(this).val().length;
        var maxLength = 160;
        var remaining = maxLength - length;
        
        // Update character count if element exists
        var counter = $(this).siblings('.char-count');
        if (counter.length === 0) {
            counter = $('<span class="char-count" style="color: #666; font-size: 12px;"></span>');
            $(this).after(counter);
        }
        
        counter.text(remaining + ' characters remaining');
        
        if (remaining < 0) {
            counter.css('color', '#d63638');
        } else if (remaining < 20) {
            counter.css('color', '#dba617');
        } else {
            counter.css('color', '#00a32a');
        }
    });
    
    // Character counter for meta titles
    $('input[name="engineo_meta_title"]').on('input', function() {
        var length = $(this).val().length;
        var maxLength = 60;
        var remaining = maxLength - length;
        
        // Update character count if element exists
        var counter = $(this).siblings('.char-count');
        if (counter.length === 0) {
            counter = $('<span class="char-count" style="color: #666; font-size: 12px;"></span>');
            $(this).after(counter);
        }
        
        counter.text(remaining + ' characters remaining');
        
        if (remaining < 0) {
            counter.css('color', '#d63638');
        } else if (remaining < 10) {
            counter.css('color', '#dba617');
        } else {
            counter.css('color', '#00a32a');
        }
    });
    
    // Auto-generate meta description from excerpt
    $('.engineo-meta-editor').on('click', '.generate-meta-desc', function(e) {
        e.preventDefault();
        
        var postId = $(this).data('post-id');
        if (!postId) return;
        
        // This would make an AJAX call to generate meta description
        // For now, just show a placeholder
        alert('Meta description generation feature coming soon!');
    });
    
    // Preview functionality for meta tags
    $('.engineo-meta-editor').on('input', 'input[name="engineo_meta_title"], textarea[name="engineo_meta_description"]', function() {
        updateMetaPreview();
    });
    
    function updateMetaPreview() {
        var title = $('input[name="engineo_meta_title"]').val() || $('h1').text() || 'Page Title';
        var description = $('textarea[name="engineo_meta_description"]').val() || 'Page description...';
        var url = window.location.href;
        
        // Update preview if it exists
        var preview = $('.meta-preview');
        if (preview.length === 0) {
            preview = $('<div class="meta-preview" style="border: 1px solid #ddd; padding: 10px; margin-top: 10px; background: #f9f9f9;"></div>');
            $('.engineo-meta-editor').append(preview);
        }
        
        preview.html(
            '<h4>Search Engine Preview:</h4>' +
            '<div style="color: #1a0dab; font-size: 18px; line-height: 1.3; margin-bottom: 3px;">' + title + '</div>' +
            '<div style="color: #006621; font-size: 14px; line-height: 1.3; margin-bottom: 3px;">' + url + '</div>' +
            '<div style="color: #545454; font-size: 13px; line-height: 1.4;">' + description + '</div>'
        );
    }
    
    // Initialize preview on page load
    updateMetaPreview();
});
