<?php
/**
 * Custom REST Apis for EngageBay
 *
 * @link       https://engagebay.com
 * @since      1.0.0
 *
 * @package    EngageBayLearnDash
 * @subpackage EngageBayLearnDash/services
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'You are not allowed to access this file directly.' );
}

class EngageBay_LearnDash_Rest_Api {

	public function learndash_engagebay_register_routes() {
		register_rest_route(
			'learndash-engagebay',
			'/get-nonce',
			array(
				'methods'             => 'GET',
				'callback'            => array( $this, 'engagebay_learndash_get_nonce' ),
				'permission_callback' => '__return_true',
			)
		);

		register_rest_route(
			'learndash-engagebay',
			'/deactivate',
			array(
				'methods'             => 'POST',
				'callback'            => array( $this, 'engagebay_learndash_deactivate_plugin' ),
				'permission_callback' => array( $this, 'engagebay_learndash_verify_permission' ),
			)
		);
	}

	public function engagebay_learndash_get_nonce() {
		$nonce = wp_create_nonce( 'ld_engagebay_uninstall' );

		return new WP_REST_Response(
			array(
				'nonce' => $nonce,
			),
			200
		);
	}

	public function engagebay_learndash_deactivate_plugin( $request ) {
		// Delete plugin options
		delete_option( 'learndash_engaegbay_installed' );
		delete_option( 'learndash_settings_engagebay' );
		delete_option( 'learndash_engagebay_preferences' );

		// Deactivate the plugin
		require_once ABSPATH . 'wp-admin/includes/plugin.php';

		$plugin_path = plugin_basename( dirname( __DIR__ ) . '/engagebay-learndash.php' );
		if ( is_plugin_active( $plugin_path ) ) {
			deactivate_plugins( $plugin_path );
		}

		return new WP_REST_Response(
			array(
				'success' => true,
				'message' => __( 'Plugin successfully uninstalled and removed all the settings data.', 'engagebay-add-on-for-learndash' ),
			),
			200
		);
	}

	public function engagebay_learndash_verify_permission( $request ) {
		// Optional: Check for nonce or API key
		$nonce = $request->get_param( '_wpnonce' );

		if ( ! wp_verify_nonce( $nonce, 'ld_engagebay_uninstall' ) ) {
			return new WP_Error( 'rest_forbidden', __( 'You do not have permission to perform this action.', 'engagebay-add-on-for-learndash' ), array( 'status' => 403 ) );
		}

		return true;
	}
}
