<?php
/**
 * EngageBay LearnDash Metabox Section.
 *
 * @since 1.0.0
 * @package EngageBayLearnDash/includes/settings
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ( class_exists( 'LearnDash_Settings_Section' ) ) && ( ! class_exists( 'EngageBay_LearnDash_Metabox_Section' ) ) ) {

	/**
	 * Class EngageBay Metabox Section
	 *
	 * @since 1.0.0
	 */
	class EngageBay_LearnDash_Metabox_Section extends LearnDash_Settings_Section {

		/**
		 * Public constructor for class
		 *
		 * @param array $args Array of class args.
		 *
		 * @since 2.6.0
		 *
		 */
		public function __construct( $args = array() ) {

			$this->settings_page_id = 'learndash_lms_engagebay';

			// This is the 'option_name' key used in the wp_options table.
			$this->setting_option_key = 'engagebaylinks';

			// Section label/header.
			$this->settings_section_label = esc_html__( 'EngageBay', 'engagebay-add-on-for-learndash' );

			$this->metabox_context  = 'side';
			$this->metabox_priority = 'low';

			$this->load_options = false;

			parent::__construct();

			// We override the parent value set for $this->metabox_key because we want the div ID to match the details WordPress
			// value so it will be hidden.
			$this->metabox_key = 'engagebaylinks';
		}

		/**
		 * Primary function to show the metabox output
		 *
		 * @since 2.6.0
		 */
		public function show_meta_box() {

			?>
            <div>
                <p>Watch our quick tour</p>
                <iframe width="100%" height="200" src="https://www.youtube.com/embed/PZROe8peDsY?rel=0&showinfo=0"
                        title="Introduction to EngageBay | All-in-One CRM - Marketing, Sales &amp; Support Software" frameborder="0" allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>

                <ul style="list-style-type: none">
                    <li><a href="https://www.engagebay.com/marketing/email-marketing" target="_blank">Email Marketing</a></li>
                    <li><a href="https://www.engagebay.com/marketing/marketing-automation-software" target="_blank">Marketing Automation</a></li>
                    <li><a href="https://www.engagebay.com/ai-chatbot" target="_blank">AI Chatbot</a></li>
                    <li><a href="https://www.engagebay.com/marketing/web-forms" target="_blank">Web Forms</a></li>
                    <li><a href="https://www.engagebay.com/service/tickets" target="_blank">Help Desk</a></li>
                </ul>
            </div>
			<?php
		}

		/**
		 * Load settings fields
		 *
		 * This is a requires function.
		 */
		public function load_settings_fields() {
		}
	}
}
add_action(
	'learndash_settings_sections_init',
	function () {
		EngageBay_LearnDash_Metabox_Section::add_section_instance();
	},
	20,
	1
);
