<?php
/**
 * User events
 *
 * @link       https://engagebay.com
 * @since      1.0.0
 *
 * @package    EngageBayLearnDash
 * @subpackage EngageBayLearnDash/includes/events
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'You are not allowed to access this file directly.' );
}

class EngageBay_LearnDash_User {
	public function on_user_registration( $user_id ) {
		$user = get_userdata( $user_id );
		$data = [
			'user_id'    => $user_id,
			'email'      => $user->user_email,
			'first_name' => $user->first_name,
			'last_name'  => $user->last_name
		];

		EngageBay_LearnDash_Api::trigger_event( EngageBay_LearnDash_Preferences_Section::USER_CREATED, $data );
	}

	public function on_user_updated( $user_id, $old_data ) {
		$data = [
			'user_id'       => $user_id,
			'previous_email' => $old_data->user_email
		];

		EngageBay_LearnDash_Api::trigger_event( EngageBay_LearnDash_Preferences_Section::USER_UPDATED, $data );
	}
}