<?php
/**
 * Quiz events
 *
 * @link       https://engagebay.com
 * @since      1.0.0
 *
 * @package    EngageBayLearnDash
 * @subpackage EngageBayLearnDash/includes/events
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'You are not allowed to access this file directly.' );
}

class EngageBay_LearnDash_Quiz {
	public function on_quiz_completed( $quiz_data, $user ) {

		$course          = $quiz_data['course'];
		$lesson          = $quiz_data['lesson'];
		$topic           = $quiz_data['topic'];
		$quiz            = get_post( $quiz_data['quiz'] );
		$course_progress = learndash_user_get_course_progress( $user->id, $course->ID );

		if ( ! $quiz || $quiz->post_type !== 'sfwd-quiz' ) {
			return;
		}

		$data = [
			'user'   => [
				'name'  => $user->display_name,
				'email' => $user->user_email,
				'roles' => $user->roles
			],
			'course' => [
				'id'    => $course->ID,
				'title' => $course->post_title,
				'url'   => get_permalink( $course->ID )
			],
			'lesson' => [
				'id'    => $lesson->ID,
				'title' => $lesson->post_title,
				'url'   => get_permalink( $lesson->ID )
			],
			'topic'  => $topic !== 0 && isset( $topic->id ) ? [
				'id'    => $topic->ID,
				'title' => $topic->post_title,
				'url'   => get_permalink( $topic->ID )
			] : $topic,
			'quiz'   => [
				'id'         => $quiz->ID,
				'title'      => $quiz->post_title,
				'url'        => get_permalink( $quiz->ID ),
				'score'      => $quiz_data['score'],
				'pass'       => $quiz_data['pass'] === 1 ? 'Pass' : 'Fail',
				'percentage' => $quiz_data['percentage'],
				'started'    => gmdate('Y-m-d H:i:s', $quiz_data['started']),
				'completed'  => gmdate('Y-m-d H:i:s', $quiz_data['completed']),
			],
			'course_progress' => [
				"completed" => $course_progress['completed'],
				"total"     => $course_progress['total'],
				"last_id"   => $course_progress['last_id'],
				"status"    => $course_progress['status']
			],
		];

		EngageBay_LearnDash_Api::trigger_event( EngageBay_LearnDash_Preferences_Section::QUIZ_COMPLETED, $data, $quiz->post_title );
	}

	public function on_essay_submitted( $essay_id, $essay_args ): void {
		$user  = get_user( get_current_user_id() );
		$essay = get_post( $essay_id );
//		$essay_question_post_id = get_post_meta($essay->ID, 'question_post_id', true);
//		$essay_question_post = get_post($essay_question_post_id);

		if ( ! $essay || $essay->post_type !== 'sfwd-essays' || ! $user ) {
			return;
		}

		$course_id = get_post_meta( $essay->ID, 'course_id', true );
		if ( ! $course_id ) {
			return;
		}

		$course = get_post( $course_id );
		$data   = [
			'user'   => [
				'first_name' => $user->first_name,
				'last_name'  => $user->last_name,
				'email'      => $user->user_email,
			],
			'course' => [
				'id'      => $course->ID,
				'title'   => $course->post_title,
				'content' => $course->post_content,
				'url'     => get_permalink( $course->ID ),
			],
			'essay'  => [
				'id'      => $essay->ID,
				'title'   => $essay->post_title,
				'content' => $essay->post_content,
				'url'     => get_permalink( $essay->ID ),
			]
		];

		EngageBay_LearnDash_Api::trigger_event( EngageBay_LearnDash_Preferences_Section::ESSAY_SUBMITTED, $data, $essay->post_title );
	}
}