<?php
/**
 * Group events
 *
 * @link       https://engagebay.com
 * @since      1.0.0
 *
 * @package    EngageBayLearnDash
 * @subpackage EngageBayLearnDash/includes/events
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'You are not allowed to access this file directly.' );
}

class EngageBay_LearnDash_Group {
	public function on_user_enroll_to_group( $user_id, $group_id ) {

		$data = $this->get_user_group_data( $user_id, $group_id );

		EngageBay_LearnDash_Api::trigger_event( 'group.user_enrolled', $data );
	}

	public function on_user_removed_from_group( $user_id, $group_id ) {
		$data = $this->get_user_group_data( $user_id, $group_id );

		EngageBay_LearnDash_Api::trigger_event( 'group.user_removed', $data );
	}

	private function get_user_group_data( $user_id, $group_id ) {
		$user  = get_user( $user_id );
		$group = get_post( $group_id );

		return [
			'user'  => [
				'first_name' => $user->first_name,
				'last_name'  => $user->last_name,
				'email'      => $user->user_email
			],
			'group' => [
				'id'    => $group->ID,
				'title' => $group->post_title,
				'url'   => get_permalink( $group->ID )
			]
		];
	}
}