<?php
/**
 * Course events
 *
 * @link       https://engagebay.com
 * @since      1.0.0
 *
 * @package    EngageBayLearnDash
 * @subpackage EngageBayLearnDash/includes/events
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'You are not allowed to access this file directly.' );
}

class EngageBay_LearnDash_Course {
	public function on_courses_updated( $user_id, $course_id, $course_access_list, $remove ) {
		$course = get_post( $course_id );
		$user   = get_user( $user_id );

		if ( ! $course || $course->post_type !== 'sfwd-courses' || ! $user ) {
			return;
		}

		$course_details = [
			'user_id'      => $user_id,
			'first_name'   => $user->first_name,
			'last_name'    => $user->last_name,
			'email'        => $user->user_email,
			'course_id'    => $course_id,
			'course_title' => $course->post_title,
			'url'          => get_permalink( $course->ID ),
			'price'        => get_post_meta( $course->ID, '_ld_price', true )
		];

		$courseFee = get_post_meta($course->ID, '_ld_price_type', true);

		if ($courseFee === 'free') {
			EngageBay_LearnDash_Api::trigger_event( EngageBay_LearnDash_Preferences_Section::NEW_ENROLMENT, $course_details, $course->post_title );
		}
	}

	public function on_course_completed( $data ) {

		$course = $data['course'];
		$user   = wp_get_current_user();

		if ( ! $course || $course->post_type !== 'sfwd-courses' || ! $user ) {
			return;
		}

		$progress       = learndash_user_get_course_progress( $user->id, $course->ID );
		$course_details = [
			'email'           => $user->user_email,
			'course_id'       => $course->ID,
			'course'          => [
				'id'    => $course->ID,
				'title' => $course->post_title,
				'url'   => get_permalink( $course->ID )
			],
			'course_progress' => [
				"completed" => $progress['completed'],
				"total"     => $progress['total'],
				"last_id"   => $progress['last_id'],
				"status"    => $progress['status']
			],
			'course_title'    => $course->post_title
		];

		EngageBay_LearnDash_Api::trigger_event( EngageBay_LearnDash_Preferences_Section::COURSE_COMPLETED, $course_details, $course->post_title );
	}

	public function on_lesson_completed( $data ) {

		$user     = $data['user']->data;
		$course   = $data['course'];
		$lesson   = $data['lesson'];
		$progress = $data['progress'];

		$data = [
			'user'            => [
				'name'  => $user->display_name,
				'email' => $user->user_email,
				'roles' => $data['user']->roles
			],
			'course'          => [
				'id'    => $course->ID,
				'title' => $course->post_title,
				'url'   => get_permalink( $course->ID )
			],
			'lesson'          => [
				'id'    => $lesson->ID,
				'title' => $lesson->post_title,
				'url'   => get_permalink( $lesson->ID )
			],
			'course_progress' => [
				"completed" => $progress['completed'],
				"total"     => $progress['total'],
				"last_id"   => $progress['last_id'],
				"status"    => $progress['status']
			]
		];

		EngageBay_LearnDash_Api::trigger_event( EngageBay_LearnDash_Preferences_Section::LESSON_COMPLETED, $data, $lesson->post_title );
	}

	public function on_topic_completed( $data ) {

		$user     = $data['user']->data;
		$course   = $data['course'];
		$lesson   = $data['lesson'];
		$progress = $data['progress'];
		$topic    = $data['topic'];

		$data = [
			'user'            => [
				'name'  => $user->display_name,
				'email' => $user->user_email,
				'roles' => $data['user']->roles
			],
			'course'          => [
				'id'    => $course->ID,
				'title' => $course->post_title,
				'url'   => get_permalink( $course->ID )
			],
			'lesson'          => [
				'id'    => $lesson->ID,
				'title' => $lesson->post_title,
				'url'   => get_permalink( $lesson->ID )
			],
			'topic'           => [
				'id'    => $topic->ID,
				'title' => $topic->post_title,
				'url'   => get_permalink( $topic->ID )
			],
			'course_progress' => [
				"completed" => $progress['completed'],
				"total"     => $progress['total'],
				"last_id"   => $progress['last_id'],
				"status"    => $progress['status']
			],
		];

		EngageBay_LearnDash_Api::trigger_event( EngageBay_LearnDash_Preferences_Section::TOPIC_COMPLETED, $data, $topic->post_title );
	}
}
