<?php
/**
 * Fired during EngageBay_LearnDash deactivation
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @link       https://engagebay.com
 * @since      1.0.0
 *
 * @package    EngageBayLearnDash
 * @subpackage EngageBayLearnDash/includes/admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'You are not allowed to access this file directly.' );
}

class EngageBay_LearnDash_Payment_Gateway {
	/**
	 * on Plugin Deactivate
	 *
	 * @since    1.0.0
	 */
	public static function payment_processed( $event, $processed, $name ): void {

		$object = $event['data']['object'] ?? [];

		if ( ! isset( $object['metadata']['post_id'] ) ) {
			return;
		}

		$course_id = (int) $object['metadata']['post_id'];
		$course    = get_post( $course_id );

		$pricing_info = json_decode( $object['metadata']['pricing_info'], true );

		$data = [
			'course'         => [
				'id'    => $course_id,
				'title' => $course->post_title,
				'url'   => get_permalink( $course->ID ),
			],
			'paid_amount'    => $pricing_info['price'],
			'currency'       => $object['currency'],
			'payment_status' => $object['payment_status'],
			'user_id'        => $object['metadata']['user_id']
		];

		$course_details = [
			'user_id'      => $object['metadata']['user_id'],
			'course_id'    => $course_id,
			'course_title' => $course->post_title,
			'url'          => get_permalink( $course->ID ),
			'price'        => get_post_meta( $course->ID, '_ld_price', true )
		];

		EngageBay_LearnDash_Api::trigger_event( EngageBay_LearnDash_Preferences_Section::COURSE_PURCHASED, $data );
		EngageBay_LearnDash_Api::trigger_event( EngageBay_LearnDash_Preferences_Section::NEW_ENROLMENT, $course_details, $course->post_title );
	}
}
