<?php

/**
 * EngageBay LearnDash Settings Page Registration.
 *
 * @since 1.0.0
 * @package EngageBayLearnDash
 * @subpackage EngageBayLearnDash/includes/admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ( class_exists( 'LearnDash_Settings_Page' ) ) && ( ! class_exists( 'EngageBay_LearnDash_Settings_Page' ) ) ) {
	class EngageBay_LearnDash_Settings_Page extends LearnDash_Settings_Page {
		/**
		 * Public constructor for class
		 *
		 * @since 2.4.0
		 */
		public function __construct() {

			$this->parent_menu_page_url = 'admin.php?page=learndash_lms_settings';
			$this->menu_page_capability = LEARNDASH_ADMIN_CAPABILITY_CHECK;
			$this->settings_page_id     = 'learndash_lms_engagebay';

			// translators: Course Shortcodes Label.
			$this->settings_page_title   = esc_html__( 'EngageBay Settings', 'engagebay-add-on-for-learndash' );
			$this->settings_tab_title    = esc_html__( 'EngageBay', 'engagebay-add-on-for-learndash' );
			$this->settings_tab_priority = 110;
			$this->show_quick_links_meta = false;

			parent::__construct();
		}
	}
}

add_action(
	'learndash_settings_pages_init',
	function () {
		EngageBay_LearnDash_Settings_Page::add_page_instance();
	}
);
