<?php
/**
 * Fired during EngageBay_LearnDash deactivation
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @link       https://engagebay.com
 * @since      1.0.0
 *
 * @package    EngageBayLearnDash
 * @subpackage EngageBayLearnDash/includes/admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'You are not allowed to access this file directly.' );
}

class EngageBay_LearnDash_Deactivator {
	/**
	 * on Plugin Deactivate
	 *
	 * @since    1.0.0
	 */
	public static function deactivate(): void {
		try {
			if ( class_exists( 'EngageBay_LearnDash_Api' ) ) {
				EngageBay_LearnDash_Api::trigger_event( 'plugin.uninstalled', [
					'site_url' => site_url()
				] );
			}

			delete_option( 'learndash_engagebay_installed' );
			delete_option( 'learndash_settings_engagebay' );
			delete_option( 'learndash_engagebay_preferences' );

		} catch ( \Throwable $e ) {
			return;
		}
	}
}
