<?php
/**
 * Admin side functionality
 *
 * @link       https://engagebay.com
 * @since      1.0.0
 *
 * @package    EngageBayLearnDash
 * @subpackage EngageBayLearnDash/includes/admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'You are not allowed to access this file directly.' );
}

class EngageBay_LearnDash_Admin {
	public function __construct() {
	}

	public function engagebay_learndash_enqueue_admin_styles( $hook ) {
		// Only load on the LearnDash EngageBay settings page
		if ( ! str_contains( $hook, 'learndash_lms_engagebay' ) ) {
			return;
		}

		wp_enqueue_style(
			'engagebay-learndash-admin-style',
			ENGAGEBAY_LEARNDASH_URL . 'assets/css/admin-style.css',
			array(),
			'1.0.0'
		);
	}

	public function engagebay_learndash_enqueue_admin_scripts( $hook ) {
		$screen = get_current_screen();
		if ( str_contains( $screen->id, 'learndash_lms_engagebay' ) ) {
			wp_enqueue_script(
				'engagebay-learndash-admin-js',
				ENGAGEBAY_LEARNDASH_URL . 'assets/js/admin-engagebay.js',
				[ 'jquery' ],
				'1.0.0',
				true
			);
		}
	}
}
