<?php
/*
 * EngageBay Marketing Automation for LearnDash
 *
 * @package           EngageBayLearnDash
 * @author            EngageBay
 * @copyright         2025 EngageBay
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name: EngageBay Marketing Automation for LearnDash
 * Plugin URI:        https://www.engagebay.com/integrations/learndash-integration
 * Description:       Sync course enrollments with EngageBay to automate emails, track learner progress, and boost engagement through smart workflows
 * Version:           1.1
 * Requires at least: 5.2
 * Requires PHP:      7.4
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'You are not allowed to access this file directly.' );
}

if ( ! function_exists( 'engagebay_learndash_activate' ) ) {
	function engagebay_learndash_activate() {
		if ( ! is_plugin_active( 'sfwd-lms/sfwd_lms.php' ) ) {
			wp_die(
				esc_html( __( 'LearnDash is required for this plugin to function. Please install and activate LearnDash.', 'engagebay-add-on-for-learndash' ) )
			);
		}
		require_once plugin_dir_path( __FILE__ ) . 'includes/admin/class-engagebay-learndash-activator.php';
		register_uninstall_hook( __FILE__, 'engagebay_learndash_uninstall' );
		EngageBay_LearnDash_Activator::activate();
	}
}

if ( ! function_exists( 'engagebay_learndash_deactivate' ) ) {
	function engagebay_learndash_deactivate() {
		require_once plugin_dir_path( __FILE__ ) . 'includes/admin/class-engagebay-learndash-deactivator.php';
		EngageBay_LearnDash_Deactivator::deactivate();
	}
}

if ( ! function_exists( 'engagebay_learndash_uninstall' ) ) {
	function engagebay_learndash_uninstall() {
		require_once plugin_dir_path( __FILE__ ) . 'includes/admin/class-engagebay-learndash-deactivator.php';
		EngageBay_LearnDash_Deactivator::deactivate();
	}
}

/** CONSTANTS */
// Define plugin constants
define( 'ENGAGEBAY_LEARNDASH_PATH', plugin_dir_path( __FILE__ ) );
define( 'ENGAGEBAY_LEARNDASH_URL', plugin_dir_url( __FILE__ ) );
define( 'ENGAGEBAY_LEARNDASH_VERSION', '1.0.0' );

if ( ! function_exists( 'EngageBayLearnDash' ) ) {
	/**
	 * Returns the main instance of EngageBay_LearnDash to prevent the need to use globals.
	 *
	 * @return EngageBay_LearnDash
	 * @since  1.0
	 */
	function EngageBayLearnDash() {
		return EngageBay_LearnDash::instance();
	}
}

register_activation_hook( __FILE__, 'engagebay_learndash_activate' );
register_deactivation_hook( __FILE__, 'engagebay_learndash_deactivate' );

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function engagebay_learndash_init() {
	// Load required files AFTER WordPress and plugins are fully initialized.
	require_once plugin_dir_path( __FILE__ ) . 'includes/admin/class-engagebay-learndash-admin.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/events/class-engagebay-learndash-user.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/events/class-engagebay-learndash-course.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/events/class-engagebay-learndash-quiz.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/events/class-engagebay-learndash-group.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/admin/class-engagebay-learndash-settings-page.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/settings/class-engagebay-learndash-settings-section.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/settings/class-engagebay-learndash-preferences-section.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/settings/class-engagebay-learndash-metabox-section.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/api/class-engagebay-learndash-api.php';
	require_once plugin_dir_path( __FILE__ ) . 'services/class-engagebay-learndash-rest-api.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-engagebay-learndash.php';
	require_once plugin_dir_path( __FILE__ ) . 'includes/admin/class-engagebay-payment-gateway.php';

	// Initialize the main plugin class
	new EngageBay_LearnDash();
}

add_action( 'plugins_loaded', 'engagebay_learndash_init' );

