jQuery(function ($) {
    $('#course_enrolled_create_contact_and_deal').attr('checked', true);
    $('#course_enrolled_create_contact_and_deal').attr('disabled', true);

    let $checkboxes = $('input[type="checkbox"]');
    $checkboxes.each(function () {
        showOrHideElements(this.name, this.value, $(this).is(':checked'));
    });

    // Show/hide note textarea based on checkbox toggle
    $checkboxes.on('change', function () {
        showOrHideElements(this.name, this.value, $(this).is(':checked'));
    });

    function showOrHideElements(name, value, isChecked) {
        const match = name.match(/\[(.*?)\]/g);
        if (!match) return;

        const action = match[1].replace('.', '_').slice(1, -1);

        const textareaId = 'note_' + action + '_' + value;
        const $textarea = $('#' + textareaId);

        const selectId = 'contact_deal_' + action + '_' + value;
        const $select = $('#' + selectId);
        const $selectHint = $('#' + selectId + '_hint');
        const $selectClass = $('.contact_select_' + action + '_' + value);


        if ($textarea.length > 0) {
            isChecked ? $textarea.show() : $textarea.hide();
        }

        if ($select.length) {
            isChecked ? $select.show() : $select.hide();
            isChecked ? $selectHint.show() : $selectHint.hide();
            isChecked ? $selectClass.show() : $selectClass.hide();
        }
    }
});
