<?php
$services = ems_get_services();
$section  = isset( $_GET['section'] ) ? sanitize_text_field( $_GET['section'] ) : '';

$match = array_filter( $services, function( $service ) use ( $section ) {
	return $service['slug'] === $section;
} );

if ( ! $match ) $section = 'dashboard';
?>

<hr>
<div class="container">
    <section class="left">
		<h2>List Of Services</h2>

		<ul class="services">
			<?php foreach( $services as $service ) :
				$active_class = $service['slug'] === $section ? 'active' : '';
			?>
				<li>
					<a class="<?php echo esc_attr( $active_class ) ?>" href="<?php echo get_admin_url( null, '/admin.php?page=ems-jetpack-crm&section=' . $service['slug'] ) ?>">
						<?php echo esc_html( $service['name'] ) ?>
					</a>
				</li>
			<?php endforeach ?>
		</ul>
	</section>

    <section class="right">
		<?php do_action( 'ems_jetpack_crm_content_' . $section ) ?>
    </section>

	<?php if ( 'dashboard' === $section ) : ?>
		<section class="extra">
			<h4>Connect popular email marketing services and import contacts to Jetpack CRM.</h4>
		</section>
	<?php endif ?>
</div>
