<?php
namespace EMS;

/**
 * Scripts and Styles Class.
 */
class Assets {

    /**
     * Class constructor.
     */
    public function __construct() {
        add_action( 'admin_enqueue_scripts', [ $this, 'register' ], 5 );
    }

    /**
     * Register our app scripts and styles.
     *
     * @return void
     */
    public function register() {
        $this->register_scripts( $this->get_scripts() );
        $this->register_styles( $this->get_styles() );
    }

    /**
     * Register scripts.
     *
     * @param  array $scripts
     *
     * @return void
     */
    private function register_scripts( $scripts ) {
        foreach ( $scripts as $handle => $script ) {
            $deps      = isset( $script['deps'] ) ? $script['deps'] : false;
            $in_footer = isset( $script['in_footer'] ) ? $script['in_footer'] : false;
            $version   = isset( $script['version'] ) ? $script['version'] : EMS_JETPACK_CRM_VERSION;

            wp_register_script( $handle, $script['src'], $deps, $version, $in_footer );
        }
    }

    /**
     * Register styles.
     *
     * @param  array $styles
     *
     * @return void
     */
    public function register_styles( $styles ) {
        foreach ( $styles as $handle => $style ) {
            $deps = isset( $style['deps'] ) ? $style['deps'] : false;

            wp_register_style( $handle, $style['src'], $deps, EMS_JETPACK_CRM_VERSION );
        }
    }

    /**
     * Get all registered scripts.
     *
     * @return array
     */
    public function get_scripts() {
        $prefix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '.min' : '';

        $scripts = [
            // 'ems-jetpack-crm-script' => [
            //     'src'       => EMS_JETPACK_CRM_ASSETS . '/js/script.js',
            //     'deps'      => [ 'jquery' ],
            //     'version'   => filemtime( EMS_JETPACK_CRM_PATH . '/assets/js/script.js' ),
            //     'in_footer' => true
            // ]
        ];

        return $scripts;
    }

    /**
     * Get registered styles.
     *
     * @return array
     */
    public function get_styles() {
        $styles = [
            'ems-jetpack-crm-style' => [
                'src' =>  EMS_JETPACK_CRM_ASSETS . '/css/style.css'
            ],
        ];

        return $styles;
    }

}
