<?php
namespace EMS;

/**
 * Admin Pages Handler.
 */
class Admin {

    /**
     * Class constructor.
     */
    public function __construct() {
        add_action( 'admin_menu', [ $this, 'admin_menu' ] );
    }

    /**
     * Register our menu page.
     *
     * @return void
     */
    public function admin_menu() {
        $capability = 'manage_options';
        $slug       = 'ems-jetpack-crm';

        $hook = add_menu_page(
            __( 'Email Marketing Services: Jetpack CRM', 'ems-jetpack-crm' ),
            __( 'EMS for CRM', 'ems-jetpack-crm' ),
            $capability,
            $slug,
            [ $this, 'ems_jetpack_crm_page' ],
            'dashicons-email-alt',
            40
        );

        add_action( 'load-' . $hook, [ $this, 'init_hooks'] );
    }

    /**
     * Initialize our hooks for the admin page.
     *
     * @return void
     */
    public function init_hooks() {
        add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
    }

    /**
     * Load scripts and styles for the app.
     *
     * @return void
     */
    public function enqueue_scripts() {
        wp_enqueue_style( 'ems-jetpack-crm-style' );
        // wp_enqueue_script( 'ems-jetpack-crm-script' );
    }

    /**
     * Render our admin page.
     *
     * @return void
     */
    public function ems_jetpack_crm_page() { ?>
        <div class="wrap">
            <div id="ems_jetpack_crm">
                <h1 class="plugin-title">
                    <a href="<?php echo get_admin_url( null, '/admin.php?page=ems-jetpack-crm' ) ?>">
                        <?php echo get_admin_page_title() ?>
                    </a>
                </h1>

                <?php require_once EMS_JETPACK_CRM_INCLUDES . '/view.php' ?>
            </div>
        </div>
        <?php
    }
}
