<?php
/**
 * Plugin Name: License Key Manager for WooCommerce
 * Contributors: jhfahim
 * Plugin URI: https://profiles.wordpress.org/genzplugin/
 * Description: License Key Manager for WooCommerce is a powerful WordPress plugin designed to help store owners manage and distribute license keys for their digital products. It seamlessly integrates with WooCommerce, allowing automatic license key generation, validation, and detailed reporting, ensuring a secure and efficient experience for both merchants and customers.
 * Version: 1.0.0
 * Author: Eilmo
 * Author URI: https://profiles.wordpress.org/jhfahim/
 * License: GPLv2 or later
 * Text Domain: emlm-license-key-manager
 * Domain Path: /languages
 * Requires Plugins: woocommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once plugin_dir_path( __FILE__ ) . 'vendor/autoload.php';

if ( !function_exists( 'emlm_activate' ) ) {
    // The code that runs during plugin activation
    function emlm_activate() {
        $install = new Emlm\Installer\Installer();
        $install->activation();
    }

    register_activation_hook( __FILE__, 'emlm_activate' );
}

if ( !class_exists( "Emlm" ) ) {
    final class Emlm {

        // Define plugin properties
        private $version = '1.0.0';
        private $plugin_name = 'emlm-license-key-manager';
        private static $instance;

        public static function getInstance() {
            if ( !isset( self::$instance ) && !( self::$instance instanceof Emlm ) ) {
                self::$instance = new Emlm;
                self::$instance->includes();
            }

            return self::$instance;
        }

        public function includes() {
            new Emlm\Init();
        }

        // Constructor function
        public function __construct() {
            // Load plugin text domain
            define( 'EMLM_PLUGIN_VERSION', '1.0' );
            define( 'EMLM_PLUGIN_FILE', __FILE__ );
            define( 'EMLM_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
            define( 'EMLM_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
        }

    }
}

function emlm() {
    return Emlm::getInstance();
}

add_action( 'plugins_loaded', 'emlm' );