jQuery(document).ready(function($) {

     // Run the function when the select option is changed
     $('#emlm_license_type').on('change', function() {
        var licenseType = $('#emlm_license_type').val();

        if (licenseType === 'unlimited') {
            // Hide the validation days and maximum activation fields when "Unlimited" is selected
            $('.emlm-validation-days').hide();
            $('.emlm-maximun-activation').hide();
        } else if (licenseType === 'limitation') {
            // Show the validation days and maximum activation fields when "Limitation" is selected
            $('.emlm-validation-days').show();
            $('.emlm-maximun-activation').show();
        }
    });

    // Capture form submission or button click for license activation
    $('#emlm-activate-license').on('click', function(e) {
        e.preventDefault(); // Prevent form submission

        var license_key = $('#emlm_license_key').val();
        var email = $('#emlm_license_email').val();

        // Validate input fields
        if (!license_key || !email) {
            alert('Please enter both license key and email.');
            return;
        }

        // Prepare the AJAX request
        $.ajax({
            url: emlm_ajax_data.home_url + '/wp-json/emlm-license-key-manager/v1/activate/', // REST API endpoint
            method: 'POST',
            beforeSend: function(xhr) {
                // Set the nonce in the request header
                xhr.setRequestHeader('X-WP-Nonce', emlm_ajax_data.nonce);
            },
            data: {
                emlm_license_key: license_key,
                emlm_license_email: email
            },
            success: function(response) {
                // Handle successful response
                alert('License activated successfully on ' + domain);
                console.log(response);
            },
            error: function(response) {
                // Handle error response
                var message = response.responseJSON ? response.responseJSON.message : 'An error occurred';
                alert('Error: ' + message);
                console.log(response);
            }
        });
    });


     // Function to fetch data via AJAX
    function fetchLicenseStats() {
        $.ajax({
            url: '/wp-json/emlm/v1/license-stats/', // REST API endpoint
            method: 'GET',
            beforeSend: function(xhr) {
                // Set the nonce in the request header
                xhr.setRequestHeader('X-WP-Nonce', emlm_ajax_data.nonce);
            },
            dataType: 'json',
            success: function(apiData) {
                // Format the data to match the structure expected by Chart.js
                const data = apiData.map(item => ({
                    month: item.month,  // Month from API
                    count: item.count   // License count from API
                }));

                // Predefined palette of RGB colors (you can customize this as needed)
                const predefinedColors = [
                    'rgba(255, 99, 132, 0.7)',  // Red
                    'rgba(54, 162, 235, 0.7)',  // Blue
                    'rgba(255, 206, 86, 0.7)',  // Yellow
                    'rgba(75, 192, 192, 0.7)',  // Green
                    'rgba(153, 102, 255, 0.7)', // Purple
                    'rgba(255, 159, 64, 0.7)',  // Orange
                    'rgba(233, 30, 99, 0.7)',   // Pink
                    'rgba(66, 135, 245, 0.7)',  // Light Blue
                    'rgba(102, 252, 241, 0.7)', // Teal
                    'rgba(183, 28, 28, 0.7)',   // Dark Red
                    'rgba(0, 230, 64, 0.7)',    // Bright Green
                    'rgba(156, 39, 176, 0.7)'   // Dark Purple
                ];

                // Assign border colors with full opacity
                const borderColors = predefinedColors.map(color => color.replace('0.7', '1'));

                // Create the chart using Chart.js
                new Chart(
                    document.getElementById('emlm-monthly-analytics'),
                    {
                        type: 'bar',
                        data: {
                            labels: data.map(row => row.month), // Use months as labels
                            datasets: [{
                                label: 'License Active By Month',
                                data: data.map(row => row.count), // Data for the bar chart
                                backgroundColor: predefinedColors,  // Predefined RGB colors
                                borderColor: borderColors,  // Full opacity for the borders
                                borderWidth: 1
                            }]
                        },
                        options: {
                            scales: {
                                y: {
                                    beginAtZero: true
                                }
                            }
                        }
                    }
                );
            },
            error: function(error) {
                console.error('Error fetching license stats:', error);
            }
        });
    }

    // Call the function to fetch data and display the chart
    fetchLicenseStats();
    

    $('.emlm-options-wrapper .nav-tab-wrapper a').on( 'click', function(evt) {
        evt.preventDefault();
        var tabId = $(this).attr('href');
        $('.emlm-options-wrapper .nav-tab-wrapper a').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');
        $('.emlm-options-wrapper .tab-content').hide();
        $(tabId).show();
    });

    $('#delete-classiads-classified-ads-and-directory-listing').on('click', function() {
        // Display a confirmation dialog
        var confirmDelete = confirm('Are you sure you want to delete License Manager pro for woocommerce plugin and its data?');
        if( !confirmDelete ){
           return false;
        }
        
    });



});
