<?php
namespace Emlm\Traits\Fields;

trait Button {
    protected static $args;
    /**
     * Method Description.
     *
     * @param string $name Name of the text field.
     * @param array $args Arguments for the text field.
     */
    public function button( $args ) {
        $default = [
            'label'       => '',
            'description' => '',
            'type'        => '',
        ];

        self::$args = wp_parse_args( $args, $default );

        self::button_markup();
    }

    protected static function button_markup() {
        $args = self::$args;
        ?>
        <div class="emlm-form-field">
            <button name="emlm_settings_export" class="emlm_settings_export button"><?php echo esc_html( $args['label'] ) ?></button>
        </div>
        <?php
}
}
