<?php
namespace Emlm\Traits\Fields;

trait TextArea {
    protected static $args;
    /**
     * Method Description.
     *
     * @param type $param_name Description.
     * @return return_type Description.
     */
    public function textarea( $name, $args ) {
        $default = [
            'label'       => '',
            'description' => '',
            'type'        => '',
            'default'     => '',
            'label_block' => false,
        ];

        self::$args = wp_parse_args( $args, $default );
        self::$args['name'] = $name;

        self::textarea_markup();
    }

    public function textarea_markup() {
        $optionName = self::$optionName;
        $getData = self::$getOptionData;
        $args = self::$args;
        $fieldName = $args['name'];
        $value = !empty( $getData[$fieldName] ) ? $getData[$fieldName] : $args['default'];
        $label_block = ( $args['label_block'] == false ) ? 'emlm-label-block' : '';
        ?>
        <div class="emlm-form-field <?php echo esc_attr( $label_block ); ?>">
           <div class="emlm-label">
                <h4><?php echo esc_html( $args['label'] ) ?></h4>
                <p><?php echo esc_html( $args['description'] ) ?></p>
           </div>
            <textarea name="<?php echo esc_attr( $optionName ) . '[' . esc_attr( $fieldName ) . ']' ?>" ><?php echo esc_attr( $value ) ?></textarea>
        </div>
        <?php
}
}
