<?php
namespace Emlm\Traits\Fields;

trait Text {
    protected static $args;
    /**
     * Method Description.
     *
     * @param string $name Name of the text field.
     * @param array $args Arguments for the text field.
     */
    public function text( $name, $args ) {
        $default = [
            'label'       => '',
            'description' => '',
            'type'        => '',
            'default'     => '',
            'label_block' => false,
        ];

        self::$args = wp_parse_args( $args, $default );
        self::$args['name'] = $name;

        self::text_markup();
    }

    protected static function text_markup() {
        $optionName = self::$optionName;
        $getData = self::$getOptionData;
        $args = self::$args;
        $fieldName = $args['name'];
        $value = !empty( $getData[$fieldName] ) ? $getData[$fieldName] : $args['default'];
        $label_block = ( $args['label_block'] == false ) ? 'emlm-label-block' : '';
        ?>
        <div class="emlm-form-field <?php echo esc_attr( $label_block ); ?>">
            <div class="emlm-label">
                <h4><?php echo esc_html( $args['label'] ) ?></h4>
                <p><?php echo esc_html( $args['description'] ) ?></p>
            </div>
            <input type="text" name="<?php echo esc_attr( $optionName ) . '[' . esc_attr( $fieldName ) . ']' ?>" value="<?php echo esc_attr( $value ) ?>">
        </div>
        <?php
}
}
