<?php
namespace Emlm\Traits\Fields;
/**
 *
 * @package    emlm-license-key-manager
 * @since      3.0.0
 * @version    3.0.0
 * @author     ThemeLooks
 * @Websites:  http://themelooks.com/
 *
 */

trait Select {
    protected static $args;

    public function select( $name, $args ) {
        $default = [
            'label'       => '',
            'description' => '',
            'type'        => '',
            'options'     => [],
            'label_block' => false,
        ];

        self::$args = wp_parse_args( $args, $default );
        self::$args['name'] = $name;

        self::select_markup();
    }

    public function select_markup() {
        $optionName = self::$optionName;
        $getData = self::$getOptionData;
        $args = self::$args;
        $fieldName = $args['name'];
        $value = !empty( $getData[$fieldName] ) ? $getData[$fieldName] : $args['default'];
        $label_block = ( $args['label_block'] == false ) ? 'emlm-label-block' : '';

        $conditionData = '';
        if ( !empty( $args['condition'] ) ) {
            $conditionData = wp_json_encode( $args['condition'] );
        }
        ?>
		<div class="emlm-form-field <?php echo esc_attr( $label_block ); ?>" data-condition="<?php echo esc_attr( $conditionData ); ?>">
      <div class="emlm-label">
          <h4><?php echo esc_html( $args['label'] ) ?></h4>
          <p><?php echo esc_html( $args['description'] ) ?></p>
      </div>
			<div class="field-group">
			<select name="<?php echo esc_attr( $optionName ) . '[' . esc_attr( $fieldName ) . ']'; ?>">
				<?php
                foreach ( $args['options'] as $key => $option ) {
                    echo '<option value="' . esc_attr( $key ) . '" ' . selected( $value, $key, false ) . '>' . esc_attr( $option ) . '</option>';
                }
                ?>
                    </select>
                    </div>
                </div>
                <?php
        }
}
