<?php
namespace Emlm\Traits\Fields;
/**
 *
 * @package    FoodBook
 * @since      3.0.0
 * @version    3.0.0
 * @author     ThemeLooks
 * @Websites:  http://themelooks.com/
 *
 */

trait MultiSelect {
    protected static $args;

    public function multi_select( $name, $args ) {
        $default = [
            'label'       => '',
            'description' => '',
            'type'        => '',
            'options'     => [],
            'label_block' => false,
        ];

        self::$args = wp_parse_args( $args, $default );
        self::$args['name'] = $name;

        self::multi_select_markup();
    }

    protected static function multi_select_markup( $name, $args ) {

        $optionName = self::$optionName;
        $getData = self::$getOptionData;
        $args = self::$args;
        $fieldName = $args['name'];
        $value = !empty( $getData[$fieldName] ) ? $getData[$fieldName] : '';

        $conditionData = '';
        if ( !empty( $args['condition'] ) ) {
            $conditionData = wp_json_encode( $args['condition'] );
        }
        ?>
		<div class="emlm-form-field admin-field-multiple-select" data-condition="<?php echo esc_attr( $conditionData ); ?>">
			<div class="emlm-label">
                <h4><?php echo esc_html( $args['label'] ) ?></h4>
                <p><?php echo esc_html( $args['description'] ) ?></p>
            </div>
			<div class="fb-field-group">
				<select name="<?php echo esc_attr( $optionName ) . '[' . esc_attr( $fieldName ) . ']'; ?>[]" multiple>
				<?php
                    foreach ( $args['options'] as $key => $option ) {

                        $v = '';
                        if ( !empty( $value ) && in_array( $key, $value ) ) {
                            $v = $key;
                        }

                        echo '<option value="' . esc_attr( $key ) . '" ' . selected( $key, $v, false ) . '>' . esc_attr( $option ) . '</option>';
                    }
                 ?>
                 </select>
                 <?php
                    if ( !empty( $args['description'] ) ) {
                        echo '<p>' . esc_html( $args['description'] ) . '</p>';
                        }
                 ?>
			</div>
		</div>
		<?php
}
}
