<?php
namespace Emlm\Traits\Fields;
/**
 *
 * @package    FoodBook
 * @since      3.0.0
 * @version    3.0.0
 * @author     ThemeLooks
 * @Websites:  http://themelooks.com/
 *
 */

trait MultiCheck {
    protected static $args;

    public function multi_check( $name, $args ) {
        $default = [
            'label'       => '',
            'description' => '',
            'type'        => '',
            'options'     => [],
            'label_block' => false,
        ];

        self::$args = wp_parse_args( $args, $default );
        self::$args['name'] = $name;

        self::multi_check_markup();
    }

    protected static function multi_check_markup() {

        $optionName = self::$optionName;
        $getData = self::$getOptionData;
        $args = self::$args;
        $fieldName = $args['name'];
        $value = !empty( $getData[$fieldName] ) ? $getData[$fieldName] : '';

        $conditionData = '';
        if ( !empty( $args['condition'] ) ) {
            $conditionData = wp_json_encode( $args['condition'] );
        }
        ?>
		<div class="emlm-form-field admin-field-multiple-checkbox" data-condition="<?php echo esc_attr( $conditionData ); ?>">
			<div class="emlm-label">
                <h4><?php echo esc_html( $args['label'] ) ?></h4>
                <p><?php echo esc_html( $args['description'] ) ?></p>
            </div>
			<div class="fb-field-group">
				<?php foreach ( $args['options'] as $key => $option ): ?>
					<label>
						<input type="checkbox" name="<?php echo esc_attr( $optionName ) . '[' . esc_attr( $fieldName ) . '][]'; ?>" value="<?php echo esc_attr( $key ); ?>" <?php checked( in_array( $key, (array) $value ) );?>>
						<?php echo esc_html( $option ); ?>
					</label><br>
				<?php endforeach;?>
				<?php if ( !empty( $args['description'] ) ): ?>
					<p><?php echo esc_html( $args['description'] ); ?></p>
				<?php endif;?>
			</div>
		</div>
		<?php
}
}
